#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)login:login.mk	1.1"

ROOT =

#	Where MAINS are to be installed.
INSDIR = $(ROOT)/bin

INC = $(ROOT)/usr/include

CONS = -DCONSOLE='"/dev/console"'
CFLAGS = $(CONS) -O -I$(INC)

#	Common Libraries not found in /lib or /usr/lib.
COMLIB = 

#	Common Libraries and -l<lib> flags.
LDFLAGS = -s $(COMLIB) -lcrypt $(LDLIBS)

STRIP = strip

#top#
# Generated by makefile 1.43    Mon Jan 14 09:39:34 EST 1985

MAKEFILE = login.mk


MAINS = login

OBJECTS =  login.o

SOURCES =  login.c

ALL:		$(MAINS)

login:		login.o	
	$(CC) $(CFLAGS)  -o login  login.o   $(LDFLAGS)


login.o:	 $(INC)/sys/types.h $(INC)/utmp.h	\
		 $(INC)/signal.h	$(INC)/sys/signal.h \
		 $(INC)/pwd.h $(INC)/stdio.h \
		 $(INC)/sys/stat.h $(INC)/dirent.h $(INC)/sys/dirent.h \
		 $(INC)/sys/utsname.h $(INC)/sys/param.h \
		 $(INC)/errno.h $(INC)/sys/errno.h \
		 $(INC)/fcntl.h 

GLOBALINCS = $(INC)/errno.h $(INC)/fcntl.h $(INC)/pwd.h \
	$(INC)/signal.h $(INC)/stdio.h $(INC)/dirent.h $(INC)/sys/dirent.h \
	$(INC)/sys/errno.h $(INC)/sys/param.h \
	$(INC)/sys/signal.h $(INC)/sys/stat.h \
	$(INC)/sys/types.h $(INC)/sys/utsname.h \
	$(INC)/utmp.h 


clean:
	rm -f $(OBJECTS)
	
clobber:	
	rm -f $(OBJECTS) $(MAINS)

newmakefile:
	makefile -m -f $(MAKEFILE) -s INC $(INC)
#bottom#

save:
	cd $(INSDIR); set -x; for m in $(MAINS); do  cp $$m OLD$$m; done

restore:
	cd $(INSDIR); set -x; for m in $(MAINS); do; cp OLD$$m $$m; done

install:	$(MAINS) $(INSDIR)
	cpset $(MAINS) $(INSDIR) 04555 root bin

strip:
	$(STRIP) $(MAINS)

remove:
	cd $(INSDIR);  rm -f $(MAINS)

$(INSDIR):
	mkdir $(INSDIR);  chmod 755 $(INSDIR);  chown bin $(INSDIR)

partslist:
	@echo $(MAKEFILE) $(LOCALINCS) $(SOURCES)  |  tr ' ' '\012'  |  sort

product:
	@echo $(MAINS)  |  tr ' ' '\012'  | \
		sed -e 's;^;$(INSDIR)/;' -e 's;//*;/;g'

productdir:
	@echo $(INSDIR)

srcaudit:	# will not report missing nor present object or product files.
	@fileaudit $(MAKEFILE) $(LOCALINCS) $(SOURCES) -o $(OBJECTS) $(MAINS)
