#ident	"@(#)ipc:nnlist.c	1.2"
#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include "/usr/.include.BSD/a.out.h"
#include <sys/param.h>
#include <sys/ioctl.h>
#include <machine/pte.h>
#include <sys/vm.h>
#include "kvar.h"

extern struct nlist *nl;		/* all because we can't init unions */
extern int nllen;			/* # of nlist entries */
int	Syssize;
off_t	vtophys();
struct	pte *Sysmap;

/*
 * nlist - retreive attributes from name list (string table version)
 */
nlist(symfilename, kmemfd, namelist, coreflag)
	char *symfilename;
	int kmemfd;
	char  *namelist[];
	int coreflag;
{
	register struct nlist *p, *q;
	register char *s1, *s2;
	register n, m, i;
	int maxlen, nreq, type;
	FILE *f, *sf;
	off_t sa, ss;
	struct exec buf;
	struct nlist space[BUFSIZ/sizeof (struct nlist)];
	char nambuf[BUFSIZ];
	long	addr;

	init_nlist(namelist);
	maxlen = 0;
	for (q=nl, nreq=0; q->n_un.n_name && q->n_un.n_name[0]; q++, nreq++) {
		q->n_type = 0;
		q->n_value = 0;
		q->n_desc = 0;
		q->n_other = 0;
		n = strlen(q->n_un.n_name);
		if (n > maxlen)
			maxlen = n;
	}
	if ((f = fopen(symfilename, "r")) == NULL)
		return (-1);
	fread((char *)&buf, sizeof buf, 1, f);
	if (N_BADMAG(buf)) {
		fclose(f);
		return (-1);
	}
	if ((sf = fopen(symfilename, "r")) == NULL) {
		fclose(f);
		return(-1);
	}
	sa = N_SYMOFF(buf);
	ss = sa + buf.a_syms;
	n = buf.a_syms;
	fseek(f, sa, 0);
	while (n) {
		m = sizeof (space);
		if (n < m)
			m = n;
		if (fread((char *)space, m, 1, f) != 1)
			break;
		n -= m;
		for (q = space; ((int)(m -= sizeof(struct nlist))) >= 0; q++) {
			if (q->n_un.n_strx == 0 || q->n_type & N_STAB)
				continue;
			/*
			 * since we know what type of symbols we will get,
			 * we can make a quick check here -- crl
			 */
			type = q->n_type & (N_TYPE | N_EXT);
			if ((q->n_type & N_TYPE) != N_ABS
			    && type != (N_EXT | N_DATA)
			    && type != (N_EXT | N_BSS))
				continue;
			fseek(sf, ss+q->n_un.n_strx, 0);
			fread(nambuf, maxlen+1, 1, sf);
			for (p = nl; p->n_un.n_name && p->n_un.n_name[0]; p++) {
				s1 = p->n_un.n_name;
				s2 = nambuf;
				if (strcmp(p->n_un.n_name, nambuf) == 0) {
					p->n_value = q->n_value;
					p->n_type = q->n_type;
					p->n_desc = q->n_desc;
					p->n_other = q->n_other;
					--nreq;
					break;
				}
			}
		}
	}

	if (nl[0].n_type == 0)
		return(-1);
	if (coreflag) {
		Syssize = nl[SYSSIZE].n_value;
		Sysmap = (struct pte *)
			calloc((unsigned) Syssize, sizeof (struct pte));
		if (Sysmap == NULL) {
			fprintf(stderr, "Out of space for Sysmap\n");
			exit(1);
		}
		addr = (long) nl[SYSMAP].n_value;
		addr &= ~0xF0000000;
		(void) lseek(kmemfd, addr, 0);
		read(kmemfd, (char *) Sysmap, Syssize * sizeof (struct pte));
		for (i = 0 ; i < nllen ; i++)
			if (nl[i].n_value)
				if ((nl[i].n_value=vtophys(nl[i].n_value))==-1)
					nl[i].n_value = 0;
	}
	fclose(f);
	fclose(sf);
	return (0);
}


/*
 * since we can't init unions, the cleanest way to use a.out.h instead
 * of nlist.h (required since nlist() uses some defines) is to do a
 * runtime copy into the nl array -- sigh
 */
init_nlist(namelist)
	register char **namelist;
{
	register struct nlist *np;
	register char **namep;

	np = nl = (struct nlist *) malloc(nllen * sizeof (struct nlist));
	if (np == NULL) {
		fprintf(stderr, "ps: out of memory allocating namelist\n");
		exit(1);
	}
	namep = &namelist[0];
	while (nllen > 0) {
		np->n_un.n_name = *namep;
		if (**namep == '\0')
			break;
		namep++;
		np++;
	}
}

/*
 * This routine was stolen from adb to simulate memory management
 * on the VAX.
 */
off_t
vtophys(loc)
long	loc;
{
	register	p;
	off_t	newloc;
	int	mask;

	mask = 0xF0000000;
	newloc = loc & ~mask;
	p = btop(newloc);
	if ((loc & mask) == 0) {
		fprintf(stderr, "Vtophys: translating non-kernel address\n");
		return((off_t) -1);
	}
	if (p >= Syssize) {
		fprintf(stderr, "Vtophys: page out of bound (%d>=%d)\n",
			p, Syssize);
		return((off_t) -1);
	}
	if (Sysmap[p].pg_v == 0
	&& (Sysmap[p].pg_fod || Sysmap[p].pg_pfnum == 0)) {
		fprintf(stderr, "Vtophys: page not valid\n");
		return((off_t) -1);
	}
	loc = (long) (ptob(Sysmap[p].pg_pfnum) + (loc & PGOFSET));
	return(loc);
}

