#
# $Header: graph.mk,v 1.1 87/09/17 13:27:58 root Exp $
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)graph:graph.mk	1.8"

#	Makefile for graph

ROOT =

DIR = $(ROOT)/usr/bin

INC = $(ROOT)/usr/include

LDFLAGS = -lm -lplot

CFLAGS = -O -I$(INC)

STRIP = strip

SIZE = size

LIST = lp

#top#
# Generated by makefile 1.47

MAKEFILE = graph.mk


MAINS = graph

OBJECTS =  graph.o

SOURCES =  graph.c

ALL:		$(MAINS)

graph:		graph.o	
	$(CC) $(CFLAGS)  -o graph  graph.o   $(LDFLAGS)


graph.o:	 $(INC)/stdio.h $(INC)/ctype.h \
		 $(INC)/math.h 

GLOBALINCS = $(INC)/ctype.h $(INC)/math.h $(INC)/stdio.h 


clean:
	rm -f $(OBJECTS)

clobber:
	rm -f $(OBJECTS) $(MAINS)

newmakefile:
	makefile -m -f $(MAKEFILE)  -s INC $(INC)
#bottom#

all : ALL

install: ALL
	cpset $(MAINS) $(DIR)

size: ALL
	$(SIZE) $(MAINS)

strip: ALL
	$(STRIP) $(MAINS)

#	These targets are useful but optional

partslist:
	@echo $(MAKEFILE) $(SOURCES) $(LOCALINCS)  |  tr ' ' '\012'  |  sort

productdir:
	@echo $(DIR) | tr ' ' '\012' | sort

product:
	@echo $(MAINS)  |  tr ' ' '\012'  | \
	sed 's;^;$(DIR)/;'

srcaudit:
	@fileaudit $(MAKEFILE) $(LOCALINCS) $(SOURCES) -o $(OBJECTS) $(MAINS)

listing:
	pr -n $(MAKEFILE) $(SOURCES) | $(LIST)

listmk:
	pr -n $(MAKEFILE) | $(LIST)
