/*
 * $Header: fuser.c,v 1.1 87/09/17 12:33:25 root Exp $
 */
/*    ofiles.c
 *    ofiles  [-p] file
 *      determine which processes have given file (or file system) open
 *       reports owner, process and inode number
 *	  -p  gives brief (pids only) report
 *        -d level     can be used for debugging info
 *  we stat the file, then step through the process table
 *   looking at open files for each process to see if we have a match
 *   user table is fetched for reporting
 *
 *  doesn't handlle remote NFS files yet.
 */
#include <sys/param.h>
#include <sys/signal.h>
#include <sys/dir.h>
#include <sys/user.h>
#define	KERNEL
#include "/sys/h/file.h"
#undef	KERNEL
#include <sys/vnode.h>
#include <ufs/inode.h>
#include <machine/pte.h>
#include <sys/proc.h>
#include "/usr/.include.BSD/a.out.h"
#include <sys/stat.h>
#include <pwd.h>
#include <sys/vmmac.h>
#include <stdio.h>
#include <sys/mount.h>
#include <sys/sema.h>
#include <sys/comm.h>
#include <sys/rfsnode.h>


#define CDIR	0x01
#define PDIR	0x02
#define RDIR	0x04
#define OFILE	0x08
#define RUSER	0x10


char *nl_names[] = {
#define X_PROC		0
	"_proc",
#define X_NPROC 	1
	"_nproc",
#define X_USRPTMA	2
    	"_Usrptmap",	
#define X_USRPT		3
	"_usrpt",
	0
};


char *rfsnl_names[] = {
#define X_NRFSMOUNT	0
	"_nrfsmount",
#define X_RFSMOUNT	1
	"_rfsmount",
#define X_NSNDD		2
	"_nsndd",
#define	X_SNDD		3
	"_sndd",
#define	X_NRCVD		4
	"_nrcvd",
#define X_RCVD		5
	"_rcvd",
	0
};

struct nlist *nl, *rfsnl;
int nrfsmount, nsndd, nrcvd;
struct rcvd *krcvd;
struct rfsmount *rfsmount;
struct sndd sndda, *ksndd;
int nproc;		/* number of entries in proc table 		*/
int mem;		/* fd for /dev/mem				*/
int kmem;
int swap;		/* fd for /dev/swap				*/
struct pte *usrpt, *Usrptma;
long procbase;
int gun, usrid, errcnt, newfile, remote;

long eseek();

main(argc, argv)
int 	argc;
char	*argv[];
{

	struct vnode vnodea, vnodeb;
	struct inode inode;
	struct user *u, *getuser();
	struct proc p;
	struct file f;

	register int filen, flags, procn, i, j, k;

	if(argc < 2) {
		fprintf(stderr, "Usage:  %s { [-[ku]] file } ... \n", argv[0]);
		exit(1);
	}

	if((mem = open("/dev/mem", 0)) < 0)
		error("can't open /dev/mem. ");
	if((kmem = open("/dev/kmem", 0)) < 0)
		error("can't open /dev/kmem. ");
	if((swap = open("/dev/drum", 0)) < 0) 
		error("can't open /dev/drum. ");
	getsyms();

	for (i = 1 ; i < argc ; i++) {
		if(argv[i][0] == '-') {
			/* options processing */
			if(newfile) {
				gun = 0;
				usrid = 0;
			}
			newfile = 0;
			for(j = 1; argv[i][j] != '\0'; j++)
			switch(argv[i][j]) {
			case 'k':
				gun++; 
				break;
			case 'u':
				usrid++; 
				break;
			default:
				fprintf(stderr,
					"Illegal option %c ignored.\n",
						argv[i][j]);
			}
			continue;
		} else
			newfile = 1;
		fflush(stdout);
	
		/* First print file name on stderr (so stdout (pids) can
		 * be piped to kill) */
		fprintf(stderr, "%s: ", argv[i]);

		/* then convert the path into an inode */
		if (path_to_inode(argv[i], &inode))
			remote = 0;
		else if (rsrc_to_vnode(argv[i], &vnodea)
			   && getsndd(vnodea.v_data, &sndda))
			remote = 1;
		else {
			fprintf(stderr,"not found\n");
			errcnt++;
			continue;
		}
		for(procn = 0; procn < nproc; procn++){
			procslot(procn, &p);
			flags = 0;
			if(p.p_stat == 0 || p.p_stat == SZOMB)
				continue;
			u = getuser(&p);
			if (u == (struct user *)NULL)
				continue;
			if (u->u_cdir != NULL){
				getvnode(u->u_cdir, &vnodeb);
				if(check(&vnodea, &inode, &vnodeb))
					flags |= CDIR;
			}
/*
			if (u->u_pdir != NULL){
				getvnode(u->u_pdir, &vnodeb);
				if(check(&vnodea, &inode, &vnodeb))
					flags |= PDIR;
			}
*/
			if (u->u_rdir != NULL){
				getvnode(u->u_rdir, &vnodeb);
				if(check(&vnodea, &inode, &vnodeb))
					flags |= RDIR;
			}
			for(filen = 0; filen < NOFILE; filen++) {
				if(u->u_ofile[filen] == NULL)
					continue;

				eseek(kmem,(long)u->u_ofile[filen],0,"file");
				eread(kmem,(char *)&f, sizeof(f), "file");

				if(f.f_count > 0) {
					if (f.f_type != DTYPE_VNODE)
						continue;
					getvnode((char *)f.f_data, &vnodeb);
					if(check(&vnodea, &inode, &vnodeb))
						flags |= OFILE;
				}
			}
			if(flags) {
				gotone(u,&p,flags);
				if (gun && !(p.p_flag & SSYS))
					kill(p.p_pid, 9);
			}
		}

		for(k = 0; k < nrcvd; k++) {
			if (!(krcvd[k].rd_stat & RDUNUSED)
			    && (getvnode(krcvd[k].rd_vnode, &vnodeb))
			    && (check(&vnodea, &inode, &vnodeb)))
				flags |= RUSER;
		}
		if (flags & RUSER)
			printf("REMOTE USER(S)");
		printf("\n");
	}
	exit(errcnt);
}		

/*
 * print the name of the user owning process "p" and the pid of that process
 */
gotone(u,p,f)
struct user *u;
struct proc *p;
int f;
{
	register struct passwd *pw;
	struct passwd *getpwuid();

	fprintf(stdout, "%7d", p->p_pid);
	fflush(stdout);
	if(f & CDIR)  fprintf(stderr, "c");/* proc's current dir is on device */
	if(f & PDIR)  fprintf(stderr, "p");/* proc's parent dir is on device */
	if(f & RDIR)  fprintf(stderr, "r");/* proc's root dir is on device */
	if (usrid) {
	    pw = getpwuid(p->p_uid);
	    if (pw)
		fprintf(stderr, "(%s)", pw->pw_name);
	}
}

path_to_inode(path, in)
char *path;
struct inode *in;
{	/* Converts a path to inode info by the stat system call */

	struct stat s;

	if(stat(path, &s) == -1) {
		return(0);
	}
	in->i_mode = s.st_mode;
	in->i_dev = s.st_dev;
	in->i_number = s.st_ino;
	in->i_rdev = s.st_rdev;
	return(1);
}

/*
 * is inode "i" on device "s"? returns TRUE or FALSE 
 */
check(va, s, vb)
struct vnode *va, *vb;
struct inode *s;
{
	struct inode *i, inode;
	struct sndd snddb;
	int rc;

	i = (struct inode *)&inode;
	if (remote)
		if (vb->v_flag & VRFSNODE)
			if (getsndd((struct rfsnode *)vb->v_data , &snddb)
			   && (sndda.sd_queue == snddb.sd_queue)
			   && (sndda.sd_mntindx == snddb.sd_mntindx))
				rc = 1;
			else
				rc = 0;
		else
			rc = 0;
	else if (vb->v_flag & VRFSNODE)
		rc = 0;
	else if (getinode((struct inode *)vb->v_data, &inode) == 0)
		rc = 0;
	else if ((s->i_mode & IFMT) == IFBLK && s->i_rdev == i->i_dev) 
		rc = 1;
	else if ((s->i_dev == i->i_dev) && (s->i_number == i->i_number))
		rc = 1;
	else 
		rc = 0;
	if (rc)
		errcnt++;
	return(rc);
}


/* 
 *	getvnode - read an vnode from from mem at address "addr"
 * 	      return pointer to vnode struct. 
 */
getvnode(vp, vnode)
struct vnode *vp, *vnode;
{
	if (vp == NULL) return(0);
	eseek(kmem, (long)vp, 0, "vnode");
	eread(kmem, (char *)vnode, sizeof(struct vnode), "vnode");
	return (1);
}

/* 
 *	getinode - read an inode from from mem at address "addr"
 * 	      return pointer to inode struct. 
 */
getinode(ip, inode)
struct inode *ip, *inode;
{
	register int *i;

	if (ip == NULL) return(0);
	eseek(kmem, (long)ip, 0, "inode");
	eread(kmem, (char *)inode, sizeof(struct inode), "inode");

/*
 * The following BSD to SYSV inode conversion (from int ot short)
 * is gross!!!!!!!!!!!!!!!!!!!!!!!!!
 */
	i = (int *)&inode->i_number;
	inode->i_number = *i;

	return (1);
}


/* 
 * get user page for proc "p" from core or swap
 * return pointer to user struct
 */
struct user *getuser(p)
struct proc *p;
{
	struct pte *ptep, apte;
	struct pte mypgtbl[UPAGES];
	int n, nbytes;
	int upage;
	char *up;
	static struct user user;

	/* easy way */
	if ((p->p_flag & SLOAD) == 0) {
		(void) lseek(swap, (long)dtob(p->p_swaddr), 0);
		if (read(swap, (char *)&user, sizeof(struct user)) <= 0){
			return (struct user *)NULL;
		}
	} else { 	/* boo */
		/* now get user page tbl */
		eseek(kmem,p->p_addr,0);
		if (read(kmem, mypgtbl, sizeof(mypgtbl))!= sizeof(mypgtbl)){
			return (struct user *)NULL;
		}
		/* now collect pages of u area */
		up = (char *)&user;
		ptep = mypgtbl;
		for(nbytes = sizeof(struct user); nbytes>0; nbytes -= NBPG){
		  eseek(mem,ptep++->pg_pfnum * NBPG,0);
		  n = MIN(nbytes, NBPG);
		  if (read(mem,up,n) != n){
			return (struct user *)NULL;
	  	  }
		  up += n;
		}
	}
	return &user;
}

/*
 * read with error checking
 */
eread( fd, p, size, s)
int fd;
char *p;
int size;
char *s;
{
	int n;
	char buf[100];
	if(( n =  read(fd, p, size)) != size){
		sprintf(buf, "read error for %s. ", s);
		error(buf);
	}
	return n;
}

/*
 * seek with error checking
 */
long eseek(fd, off, whence, s)
int fd;
long off;
int whence;
char *s;
{
	long lseek();
	long ret;
	char buf[100];

	if(( ret = lseek(fd, off, whence)) != off) {
		sprintf(buf, "seek for %s failed, wanted %o, got %o. ",
			s, off, ret);
		error(buf);
	}
	return ret;
}

/*
 * print mesg "s" followed by system erro msg. exit.
 */
error(s)
char *s;
{
	if (s)
		fprintf(stderr,s);
	perror("");
	exit(1);
}

procslot(n, p)
int n;
struct proc *p;
{
	eseek(kmem, procbase + (long)(n * sizeof(struct proc)), 0);
	eread(kmem, (char *)p, sizeof(struct proc), "proc");
	return;
}
			
/*
 * get some symbols form the kernel
 */
getsyms()
{
	register i;
	struct nlist *init_nlist();

	nl = init_nlist(nl_names, sizeof(nl_names)/sizeof(char *));
	nlist("/vmunix", nl);
	for(i = 0; i < (sizeof (nl_names)/sizeof(char *))-1; i++)
		if(nl[i].n_value == 0) {
			fprintf(stderr,"%s: can't nlist for %s.\n",
				nl[i].n_value);
			exit(1);
		}
	eseek(kmem, (long)nl[X_PROC].n_value, 0);
	eread(kmem, &procbase, sizeof(procbase), "procbase 1");
	eseek(kmem, (long)nl[X_NPROC].n_value, 0);
	eread(kmem, &nproc, sizeof(nproc), "nproc");
	Usrptma = (struct pte *)nl[X_USRPTMA].n_value;
	usrpt = (struct pte *)nl[X_USRPT].n_value;	/* used by <vmmac.h>*/
	rfsnl = init_nlist(rfsnl_names, sizeof (rfsnl_names)/sizeof (char *));
	nlist("/vmunix", rfsnl);
	if(rfsnl[X_NRFSMOUNT].n_value == 0) {
		nrfsmount = 0;
	} else {
	    eseek(kmem, (long)rfsnl[X_NRFSMOUNT].n_value, 0);
	    eread(kmem, &nrfsmount, sizeof(nrfsmount), "nrfsmount");
	}
	if (nrfsmount) {
	    rfsmount=(struct rfsmount *)malloc(nrfsmount*sizeof(struct rfsmount));
	    eseek(kmem, (long)rfsnl[X_RFSMOUNT].n_value, 0);
	    eread(kmem, rfsmount, nrfsmount*sizeof(struct rfsmount),"rfsmount");
	}
	if(rfsnl[X_NSNDD].n_value == 0) {
		nsndd = 0;
	} else {
	    eseek(kmem, (long)rfsnl[X_NSNDD].n_value, 0);
	    eread(kmem, &nsndd, sizeof(nsndd), "nsndd");
	}
	if (nsndd) {
	    ksndd=(struct sndd *)malloc(nsndd*sizeof(struct sndd));
	    eseek(kmem, (long)rfsnl[X_NSNDD].n_value, 0);
	    eread(kmem, ksndd, nsndd*sizeof(struct sndd),"sndd");
	}

	if(rfsnl[X_NRCVD].n_value == 0) {
		nrcvd = 0;
	} else {
	    eseek(kmem, (long)rfsnl[X_NRCVD].n_value, 0);
	    eread(kmem, &nrcvd, sizeof(nrcvd), "nrcvd");
	}
	if (nrcvd) {
	    krcvd=(struct rcvd *)malloc(nrcvd*sizeof(struct rcvd));
	    eseek(kmem, (long)rfsnl[X_RCVD].n_value, 0);
	    eread(kmem, krcvd, nrcvd*sizeof(struct rcvd),"rcvd");
	}
}
	

rsrc_to_vnode(name, vno)
char *name;
struct vnode *vno;
{
	int i;
	struct rfsmount *mp;

	/* search kernel mount table for the resource name. */
	if(nrfsmount)
		for(i = 0, mp = rfsmount; i < nrfsmount ; i++, mp++)
			if ((mp->m_flags & MINUSE)
			    && nmck(name, mp->m_name)
			    && getvnode(mp->m_rfsvp, vno))
				return(1);
	return(0);	/* resource not found in mount table */
}

nmck(n1,addr)
char *n1;
{
	char *nm, kname[NMSZ];

	eseek(kmem, (long)addr, 0);
	eread(kmem, kname, NMSZ, "rcvd");
	if(!strncmp(n1, kname, NMSZ))
		return(1);
	return(0);
}

/* 
 *	getsend - read the send descripter for an rfsnode.
 */
getsndd(rp, sndd)
struct rfsnode *rp;
struct sndd *sndd;
{
	struct rfsnode rfsnode;

	if (rp == NULL) return(0);
	eseek(kmem, (long)rp, 0, "rfsnode");
	eread(kmem, (char *)&rfsnode, sizeof(rfsnode), "rfsnode");
	eseek(kmem, (long)rfsnode.rf_fsptr, 0, "sndd");
	eread(kmem, (char *)sndd, sizeof(struct sndd), "sndd");
	return (1);
}

/*
 * since we can't init unions, the cleanest way to use a.out.h instead
 * of nlist.h (required since nlist() uses some defines) is to do a
 * runtime copy into the nl array -- sigh
 */
struct nlist *init_nlist(nlp, nllen)
char *nlp[];
register int nllen;
{
	register struct nlist *np, *tnl;
	register char **namep;

	np = tnl = (struct nlist *) malloc(nllen * sizeof (struct nlist));
	if (np == NULL) {
		fprintf(stderr, "ps: out of memory allocating namelist\n");
		exit(1);
	}
	namep = &nlp[0];
	while (nllen > 0) {
		np->n_un.n_name = *namep;
		if (*namep == '\0')
			break;
		namep++;
		np++;
	}
	return(tnl);
}

/*
 * nlist - retreive attributes from name list (string table version)
 * 	modified to add wait channels - Charles R. LaBrec 8/85
 */
nlist(name, list)
	char *name;
	struct nlist *list;
{
	register struct nlist *p, *q;
	register char *s1, *s2;
	register n, m;
	int maxlen, nreq, type;
	FILE *f, *sf;
	off_t sa, ss;
	struct exec buf;
	struct nlist space[BUFSIZ/sizeof (struct nlist)];
	char nambuf[BUFSIZ];

	maxlen = 0;
	for (q = list, nreq = 0; q->n_un.n_name && q->n_un.n_name[0]; q++, nreq++) {
		q->n_type = 0;
		q->n_value = 0;
		q->n_desc = 0;
		q->n_other = 0;
		n = strlen(q->n_un.n_name);
		if (n > maxlen)
			maxlen = n;
	}
	f = fopen(name, "r");
	if (f == NULL)
		return (-1);
	fread((char *)&buf, sizeof buf, 1, f);
	if (N_BADMAG(buf)) {
		fclose(f);
		return (-1);
	}
	sf = fopen(name, "r");
	if (sf == NULL) {
		/* ??? */
		fclose(f);
		return(-1);
	}
	sa = N_SYMOFF(buf);
	ss = sa + buf.a_syms;
	n = buf.a_syms;
	fseek(f, sa, 0);
	while (n) {
		m = sizeof (space);
		if (n < m)
			m = n;
		if (fread((char *)space, m, 1, f) != 1)
			break;
		n -= m;
		for (q = space; ((int)(m -= sizeof(struct nlist))) >= 0; q++) {
			if (q->n_un.n_strx == 0 || q->n_type & N_STAB)
				continue;
			/*
			 * since we know what type of symbols we will get,
			 * we can make a quick check here -- crl
			 */
			type = q->n_type & (N_TYPE | N_EXT);
			if ((q->n_type & N_TYPE) != N_ABS
			    && type != (N_EXT | N_DATA)
			    && type != (N_EXT | N_BSS))
				continue;
			fseek(sf, ss+q->n_un.n_strx, 0);
			fread(nambuf, maxlen+1, 1, sf);
			for (p = list; p->n_un.n_name && p->n_un.n_name[0]; p++) {
				s1 = p->n_un.n_name;
				s2 = nambuf;
				if (strcmp(p->n_un.n_name, nambuf) == 0) {
					p->n_value = q->n_value;
					p->n_type = q->n_type;
					p->n_desc = q->n_desc;
					p->n_other = q->n_other;
					--nreq;
					break;
				}
			}
		}
	}
alldone:
	fclose(f);
	fclose(sf);
	return (nreq);
}
