/*
 * $Header: getnodes.c,v 1.1 87/09/17 12:32:57 root Exp $
 */
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)rmntstat:getnodes.c	1.20"
		/* this module is used in the fumount, fusage
		   and rmntstat  commands */

		/* getnodes() retrieves the necessary tables from the Kernel,
		   builds a table of nodes (clients) that have the
		   resource mounted including block transfer counts */

		/* getcount() returns the block transfer count for a
		   mounted resource.  It is included here because it
		   requires the same kernel access routines used by getnodes */

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/sema.h>
#include <sys/comm.h>
#include "fumount.h"
#include <sys/nserve.h>
#include <sys/cirmgr.h>
#include <sys/idtab.h>
#include <sys/mount.h>
#include <sys/stat.h>
#include <sys/adv.h>
#include "/usr/.include.BSD/a.out.h"

/* definition of memory page size */
#ifdef u3b2
#define PSIZE	2048
#define PSHIFT	11
#endif

/* symbol names */
#define MAXADV_STR "_nadvertise"
#define ADVTAB_STR "_advertise"
#define NRCVD_STR "_nrcvd"
#define RCVD_STR "_rcvd"
#define MNT_STR "_rfsmount"
#define NSRMNT_STR "_nsrmount"
#define SRMNT_STR "_srmount"
#define GDP_STR "_gdp"
#define MGDP_STR "_maxgdp"
#define	MAX_MOUNT "_nrfsmount"

char * nl_names[]= {
	MAXADV_STR,
	ADVTAB_STR,
	NRCVD_STR,
	RCVD_STR,
	MNT_STR,
	NSRMNT_STR,
	SRMNT_STR,
	GDP_STR,
	MGDP_STR,
	MAX_MOUNT,
	""
};
struct nlist nl[sizeof(nl_names)/sizeof(char *)] ;
int nllen;	/*  number of nlist entries  */

#if u3b5 || u3b2 || m68k
#define MEMF "/dev/kmem"
#endif

#define SYSTEM "/vmunix"
#define NLDATA "/etc/nl_data"

void perror();
char nullptr[] = "";
extern char *malloc();
extern struct clnts *client;

int mem;
int NLload;			/* nlist load flag */
int nrfsmount,maxadv, nsrmnt, gdpsiz;
unsigned nrfsmount_adr, adv_adr, maxadv_adr;
unsigned mnt_adr, srmnt_adr, nsrmnt_adr, gdp_adr, mgdp_adr;
struct advertise *Advtab;
struct mount *Mount;
struct srmnt *Srmount;
struct rcvd Rcvd;
struct gdp *gdpp;

getnodes(resrc, advflg)
char *resrc;
int advflg;
{	
	int clx, advx, srmx, gdpx;
	struct rcvd *rcvdp;
	struct vnode *vnop;
	sysid_t sysid;

	if(nlload() != 0)
		return(-1);

/*	we have a resource name.  The advertise table has
**	a pointer to a receive descriptor.  The receive
**	descriptor has a pointer to the inode of the resource.
**
**	The srmount table also has an inode pointer.  We can
**	scan the srmount table for instances of this inode,
**	pick up the sysid, and match it in the gdp structure.
**	The gdp structure which contains (finally) the system name.
*/
		/* find inode pointer for this resource */
	for(advx = 0; advx < maxadv; advx++)
		if((strncmp(Advtab[advx].a_name, resrc, NMSZ) == 0)
	 	&& (Advtab[advx].a_flags & A_INUSE))
			break;	/* found it */
	if(advx >= maxadv) {
		return(1);	/* is this an error? */
	}

	rcvdp = Advtab[advx].a_queue;
	if(rread(mem, rcvdp, &Rcvd, sizeof(struct rcvd)))
		return(2);
	vnop = Rcvd.rd_vnode;	/* this is the thing to match */

			/* there may be mutiple srmount entries pointing
				to this inode */
	
	for(srmx = 0, clx = 0; srmx < nsrmnt; srmx++) {
		if(!(Srmount[srmx].sr_flags & MINUSE))
			continue;
		if(Srmount[srmx].sr_rootvnode == vnop) {
			sysid = Srmount[srmx].sr_sysid; /* sysid of client */
			for(gdpx = 0; gdpx < gdpsiz; gdpx++) {
				if((gdpp[gdpx].flag & GDPCONNECT)
				&& (gdpp[gdpx].sysid == sysid)) {
						/* load client list structure */
					strncpy(client[clx].node, 
				gdpp[gdpx].token.t_uname, 
						MAXDNAME);
					client[clx].node[MAXDNAME] = '\0';
					client[clx].sysid = sysid;
					client[clx].bcount = 
							Srmount[srmx].sr_bcount;
					client[clx++].flags = advflg | KNOWN;
					break;
				}
			}
		}
	}
	while(clx < (nsrmnt + 1))
		client[clx++].flags = EMPTY;

	if(client[0].flags == EMPTY)	/* nothing found */
		return(3);
	return(0);
}

getcount(fs)
char *fs;
{
#ifdef	NOTDEF
	struct rfsmount *mp;
	struct stat stb;
	int i;

			/* return the block io count from the kernel
			   mount table for the file system requested */

	if(nlload() != 0)
		return(-1);

	if(stat(fs,&stb) == -1) {
		perror("getcount");
		return(-1);
	}
	for (mp = Mount, i = 0; i < v.v_mount; mp++, i++) {
		if (mp->m_flags & MINUSE) {
			if(mp->m_dev == stb.st_dev) {
				return(mp->m_bcount);
			}
		}
	}
	return(-1);
#endif	NOTDEF
	return(0);
}

nlload()
{
	int i, nlfd;
	struct stat nls, uxs;

	if(NLload)
		return(0);

	/* once only code */
	NLload++;

	/* initialise the nlist structure with the names of variables */
	init_nlist();

	/* open file to access memory */
	if((mem = open(MEMF, O_RDONLY)) == -1) {
		perror(MEMF);
		return(-1);
	}
	/* get values of system variables */

	if((stat(NLDATA,&nls) < 0)
	|| (stat(SYSTEM,&uxs) < 0)
	|| (uxs.st_mtime > nls.st_mtime)) {
getnl:
		if(nlist(SYSTEM, nl) == -1) {
			perror("nlist:");
			return(-1);
		}
		if((nlfd = open(NLDATA, O_WRONLY | O_CREAT)) >= 0 ) {
			chmod(NLDATA,0664);
			for(i = 0; i < sizeof(nl) / sizeof(struct nlist); i++)
				write(nlfd, &nl[i].n_value, sizeof(long));
			close(nlfd);
		}
	} else {
		if((nlfd = open(NLDATA, O_RDONLY)) >= 0) {
			for(i = 0; i < sizeof(nl) / sizeof(struct nlist); i++)
				if(read(nlfd, &nl[i].n_value, sizeof(long))
						!= sizeof(long))
					goto getnl;
			close(nlfd);
		} else {
			goto getnl;
		}
	}

	if(copylval(MAX_MOUNT, &nrfsmount_adr)
	|| copylval(MAXADV_STR, &maxadv_adr)
	|| copylval(GDP_STR, &gdp_adr)
	|| copylval(MGDP_STR, &mgdp_adr)
	|| copylval(ADVTAB_STR, &adv_adr)
	|| copylval(MNT_STR, &mnt_adr)
	|| copylval(NSRMNT_STR, &nsrmnt_adr)
	|| copylval(SRMNT_STR, &srmnt_adr))
		return(-1);

	if(rread(mem, nrfsmount_adr, &nrfsmount, sizeof(nrfsmount )))
		return(-1);

	/* get space for advertise, mount, srmount, and gdp tables */

	if(rread(mem, maxadv_adr, &maxadv, sizeof(maxadv)))
		return(-1);
	Advtab = (struct advertise *)malloc(maxadv * sizeof(struct advertise));
	if(Advtab) {
		if(rread(mem,adv_adr,Advtab,maxadv * sizeof(struct advertise)))
			return(-1);
	} else {
		printf("could not allocate space for advertise table\n");
		return(-1);
	}
	Mount = (struct rfsmount *)malloc(nrfsmount * sizeof(struct rfsmount));
	if(Mount)  {
		if(rread(mem,mnt_adr,Mount,nrfsmount * sizeof(struct rfsmount)))
			return(-1);
	} else {
		printf("could not allocate space for mount table\n");
		return(-1);
	}
	if(rread(mem, nsrmnt_adr, &nsrmnt, sizeof(nsrmnt)))
		return(-1);
	Srmount = (struct srmnt *)malloc(nsrmnt * sizeof(struct srmnt));
	if(Srmount)  {
		if(rread(mem,srmnt_adr,Srmount,nsrmnt * sizeof(struct srmnt)))
			return(-1);
		
	} else {
		printf("could not allocate space for srmount table\n");
		return(-1);
	}
	if(rread(mem, mgdp_adr, &gdpsiz, sizeof(maxgdp)))
		return(-1);
	gdpp = (struct gdp *)malloc(gdpsiz * sizeof(struct gdp));
	if(gdpp)  {
		if(rread(mem, gdp_adr, gdpp, gdpsiz * sizeof(struct gdp)))
			return(-1);
	} else {
		printf("could not allocate space for gdp table\n");
		return(-1);
	}
		/* also need space for the client list */
	client = (struct clnts *)malloc((nsrmnt + 1) * sizeof(struct clnts));
	if(client == 0) {
		printf("could not allocate space for gdp\n");
		return(-1);
	}
	for(i = 0; i < (nsrmnt + 1); i++)
		client[i].flags = EMPTY;
	return(0);
}

/*	copylval(), and rread() were stolen from fuser.c */

copylval(symbol, ptr)
char *symbol;
unsigned *ptr;
{		/* Copies the lvalue of the UNIX symbol "symbol" into
		 * the variable pointed to by "ptr". The lvalue of
		 * "symbol" is read from SYSTEM.
		 */
	int i = 0;

	while(nl[i].n_un.n_name[0] != '\0') {
		if(!strcmp(symbol,nl[i].n_un.n_name)) {
			if(nl[i].n_value == 0) {
				printf("copylval: '%s' is undefined\n",symbol);
				return(-1);
			}
			*ptr = nl[i].n_value;
			return(0);
		}
		i++;
	}
	printf("copylval cannot find '%s'\n",symbol);
	return(-1);
}

rread(device, position, buffer, count)
char *buffer;
int count, device;
long position;
{	/* Seeks to "position" on device "device" and reads "count"
	 * bytes into "buffer". Zeroes out the buffer on errors.
	 */
	int i;
	long lseek();
	static int p1 = 0;

	if(lseek(device, position, 0) == (long) -1) {
		fprintf(stderr, "Seek error in %s ",MEMF);
		perror("");
		for(i = 0; i < count; buffer++, i++) *buffer = '\0';
		return(-1);
	}
	if(read(device, buffer, (unsigned) count) == -1) {
		fprintf(stderr, "Read error in %s ",MEMF);
		perror("");
		for(i = 0; i < count; buffer++, i++) *buffer = '\0';
		return(-1);
	}
	return(0);
}
/*
 * since we can't init unions, the cleanest way to use a.out.h instead
 * of nlist.h (required since nlist() uses some defines) is to do a
 * runtime copy into the nl array -- sigh
 */
init_nlist()
{
	register struct nlist *np;
	register char **namep;

	nllen = sizeof nl_names / sizeof (char *);
/*****
	np = nl = (struct nlist *) malloc(nllen * sizeof (struct nlist));
	if (np == NULL) {
		fprintf(stderr, "ps: out of memory allocating namelist\n");
		exit(1);
	}
*****/
	namep = &nl_names[0];
	np = &nl[0];
	while (nllen > 0) {
		np->n_un.n_name = *namep;
		if (**namep == '\0')
			break;
		namep++;
		np++;
	}
}
/*
 * nlist - retreive attributes from name list (string table version)
 * 	modified to add wait channels - Charles R. LaBrec 8/85
 */
nlist(name, list)
	char *name;
	struct nlist *list;
{
	register struct nlist *p, *q;
	register char *s1, *s2;
	register n, m;
	int maxlen, nreq, type;
	FILE *f, *sf;
	off_t sa, ss;
	struct exec buf;
	struct nlist space[BUFSIZ/sizeof (struct nlist)];
	char nambuf[BUFSIZ];

	maxlen = 0;
	for (q = list, nreq = 0; q->n_un.n_name && q->n_un.n_name[0]; q++, nreq++) {
		q->n_type = 0;
		q->n_value = 0;
		q->n_desc = 0;
		q->n_other = 0;
		n = strlen(q->n_un.n_name);
		if (n > maxlen)
			maxlen = n;
	}
	f = fopen(name, "r");
	if (f == NULL)
		return (-1);
	fread((char *)&buf, sizeof buf, 1, f);
	if (N_BADMAG(buf)) {
		fclose(f);
		return (-1);
	}
	sf = fopen(name, "r");
	if (sf == NULL) {
		/* ??? */
		fclose(f);
		return(-1);
	}
	sa = N_SYMOFF(buf);
	ss = sa + buf.a_syms;
	n = buf.a_syms;
	fseek(f, sa, 0);
	while (n) {
		m = sizeof (space);
		if (n < m)
			m = n;
		if (fread((char *)space, m, 1, f) != 1)
			break;
		n -= m;
		for (q = space; ((int)(m -= sizeof(struct nlist))) >= 0; q++) {
			if (q->n_un.n_strx == 0 || q->n_type & N_STAB)
				continue;
			/*
			 * since we know what type of symbols we will get,
			 * we can make a quick check here -- crl
			 */
			type = q->n_type & (N_TYPE | N_EXT);
			if ((q->n_type & N_TYPE) != N_ABS
			    && type != (N_EXT | N_DATA)
			    && type != (N_EXT | N_BSS))
				continue;
			fseek(sf, ss+q->n_un.n_strx, 0);
			fread(nambuf, maxlen+1, 1, sf);
			for (p = list; p->n_un.n_name && p->n_un.n_name[0]; p++) {
				s1 = p->n_un.n_name;
				s2 = nambuf;
				if (strcmp(p->n_un.n_name, nambuf) == 0) {
					p->n_value = q->n_value;
					p->n_type = q->n_type;
					p->n_desc = q->n_desc;
					p->n_other = q->n_other;
					--nreq;
					break;
				}
			}
		}
	}
alldone:
	fclose(f);
	fclose(sf);
	return (nreq);
}
