
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)df:df.c	1.3"

/*	Distributed Unix, FS Switching Version	*/

/*
 *	Modified for is68k20 dual port
 */
#include <sys/param.h>
#include <errno.h>
#include <ufs/fs.h>
#include <sys/stat.h>
/*	#include <sys/vfs.h> */

#include <stdio.h>
#include <mntent.h>

#include <sys/types.h>
/*	#include <mnttab.h> Don't know yet whether needed! */
#include <ustat.h>
#include <sys/statfs.h>
#include <sys/fs/s5dir.h>
#include <setjmp.h>
#include <string.h>

#define EQ(x,y) (strcmp(x,y)==0)
#define S5MNTTAB "/etc/mnttab"
			/* a link to /etc/mtab in BSD universe */
#define S5MOUNTED fs_name[0]
#define	DEVLEN	32	/* What it was in System V */
#define DEVLSZ 200	/* number of unique file systems we can remember */
/*	#define FREMOTE	0x0002	/* file is remote (see <sys/user.h>)  */

extern char *optarg;
extern int optind, opterr;
extern int errno;
char *devnm();

struct stat	S;
union {
	struct fs iu_fs;
	char dummy[SBSIZE];
} sb;
#define sblock sb.iu_fs
struct fs	*Fs = &sblock;
struct statfs	Fs_info;
struct mntent	*mnt;

int	freflg, totflg, locflg;
int	fd;
daddr_t	blkno	= 1;

char nfsmes[] = "          (%-10.32s): \
is not a file system, directory, or mounted resource\n";

char usage[] = "Usage: \
df [-lt] [-f] [{<file system> <directory> <mounted resource>}] ...\n";

char *
basename(s)
char *s;
{
	int n = 0;

	while(*s++ != '\0') n++;
	while(n-- > 0)
		if(*(--s) == '/') 
			return(++s);
	return(--s);
}

main(argc, argv)
char **argv;
{
	register FILE * fi;
	register i;
	char	 dev[DEVLEN+1], *res_name, *s;
	int	 c, k, errcnt = 0;

	s = basename(argv[0]);
	if(!strncmp(s,"devnm",5)) {

		while(--argc) {
			if(stat(*++argv, &S) == -1) {
				fprintf(stderr,"devnm: ");
				errcnt++;
				continue;
			}
			res_name = devnm();
			if(res_name[0] != '\0')
				printf("%s %s\n", res_name, *argv);
			else {
				printf("devnm: %s not found\n", *argv);
				errcnt++;
			}
		}
		exit(errcnt);
	}
	while((c = getopt(argc,argv,"tfl")) != EOF) {
		switch(c) {

			case 'l':	/* do local resources only */
				locflg = 1;
				break;

			case 'f':	/* freelist count only */
				freflg++;
				break;

			case 't':	/* include total allocations */
				totflg = 1;
				break;

			default:
				fprintf(stderr,usage);
				exit(1);
		}
	}

	if((fi = setmntent(MOUNTED,"r")) == 0) {
		fprintf(stderr,"df: cannot open %s\n",S5MNTTAB);
		exit(1);
	}
	while ((mnt = getmntent(fi))) {
		if(locflg && (strcmp(mnt->mnt_type, MNTTYPE_43)))
			continue;
		if (strcmp(mnt->mnt_type, MNTTYPE_IGNORE) == 0 ||
		    strcmp(mnt->mnt_type, MNTTYPE_SWAP) == 0)
			continue;
		sprintf(dev,"%.32s",mnt->mnt_fsname);
		if(argc > optind) {
				/* we are looking for specific file systems
				   in the mount table */
			for(k=optind;k < argc; k++) {
				if(argv[k][0] == '\0')
					continue;
				if(stat(argv[k], &S) == -1)
					S.st_dev = -1;

					/* does the argument match either
					   the mountpoint or the device? */
				if(EQ(argv[k], mnt->mnt_fsname)
				|| EQ(argv[k], mnt->mnt_dir)) {
					errcnt += printit(dev, mnt->mnt_dir);
					argv[k][0] = '\0';
				} else	
					/* or is it on one of 
						the mounted devices? */
					if( ((S.st_mode & S_IFMT) == S_IFDIR)
					&& (EQ(devnm(), mnt->mnt_fsname))) {
						/* must re-do stat cuz
						   devnm() wiped it out */
						if(stat(argv[k], &S) == -1)
							S.st_dev = -1;
						errcnt += printit(dev, argv[k]);
						argv[k][0] = '\0';
					}
			}
		} else {
				/* doing all things in the mount table */
			if(stat(mnt->mnt_dir, &S) == -1)
				S.st_dev = -1;
			errcnt += printit(dev, mnt->mnt_dir);
		}
	}

			/* process arguments that were not in /etc/mnttab */
	for(i = optind; i < argc; ++i) {
		if(argv[i][0])
			errcnt += printit(argv[i], "\0");
	}

	endmntent(fi);
	exit(errcnt);
}

printit(dev, fs_name)
char *dev, *fs_name;
{
	char mark;


	if(S5MOUNTED && (!EQ(mnt->mnt_type,MNTTYPE_43)))
		if(freflg)
			return(0);

	if(!S5MOUNTED || freflg) {
		if((fd = open(dev, 0)) < 0) {
			fprintf(stderr,"df: cannot open %s\n",dev);
			close(fd);
			return(1);
		}
		if(stat(dev, &S) < 0) {
			fprintf(stderr, "df: cannot stat %s\n", dev);
			close(fd);
			return(1);
		}

		if(((S.st_mode & S_IFMT) == S_IFREG) 
		|| ((S.st_mode & S_IFMT) == S_IFIFO)) {
			fprintf(stderr,nfsmes, dev);
			close(fd);
			return(1);
		}

		sync();
		if(bread(fd,SBLOCK,(char *)&sblock,SBSIZE) == 0) {
			close(fd);
			return(1);
		}
		Fs_info.f_bfree = (Fs->fs_cstotal.cs_nbfree * Fs->fs_frag +
				Fs->fs_cstotal.cs_nffree) * (Fs->fs_fsize/512);
		Fs_info.f_ffree = Fs->fs_cstotal.cs_nifree;
	} else {	/* mounted file system */

		if(statfs(fs_name, &Fs_info, sizeof(struct statfs), 0) < 0) {
			fprintf(stderr, "df: cannot statfs %s\t", dev);
			perror(" statfs");
			return(1);
		}
	}

	if(!freflg) {
		if(S5MOUNTED) 
			printf("%-9s", fs_name);
		printf(" (%-16.32s):", dev);

			/* mark 2nd and subsequent reports on the same
							remote resource.  */
		mark = (firstpik()) ? ' ' : '*';
		printf(" %8ld blocks%c %7u i-nodes\n",
			Fs_info.f_bfree, mark, Fs_info.f_ffree);
	} else {
		printf("%-10s(%-12s): %8ld blocks\n",fs_name, dev,
			Fs_info.f_bfree);
		close(fd);
	}
	if(totflg) {
		printf("                   total: ");
		if(S5MOUNTED && !freflg)
			printf("%8ld blocks %7u i-nodes\n",
				Fs_info.f_blocks,
				Fs_info.f_files);
		else
			printf("%8ld blocks %7u i-nodes\n",
				sblock.fs_size*(sblock.fs_fsize/512), 
				sblock.fs_ncg*sblock.fs_ipg);
	}
	return(0);
}

firstpik()
{
	static dev_t devlst[DEVLSZ];
	static	int i, ndev;

	if(S.st_dev == -1)
		return(1);	/* stat() failed.. data invalid */
	if(ndev)
		for(i = 0; i < ndev; i++) 
			if(S.st_dev == devlst[i])
				return(0);
	if(ndev < DEVLSZ)
		devlst[ndev++] = S.st_dev;
	return(1);
}

struct direct dbuf;

char *
devnm()
{
	int i;
	static short fno;
	static struct devs {
		char *devdir;
		short dfd;
	} devd[] = {		/* in order of desired search */
		"/dev/dsk",0,
		"/dev",0,
		"/dev/rdsk",0
	};
	static char devnam[DEVLEN];

	devnam[0] = '\0';
	if(!devd[1].dfd) {	/* if /dev isn't open, nothing happens */
		for(i = 0; i < 3; i++) {
			devd[i].dfd = open(devd[i].devdir, 0);
		}
	}
	fno = S.st_dev;

	for(i = 0; i < 3; i++) {
		if((devd[i].dfd >= 0)
		   && (chdir(devd[i].devdir) == 0) 
		   && (dsearch(devd[i].dfd,fno))) {
			strcpy(devnam, devd[i].devdir);
			strcat(devnam,"/");
			strncat(devnam,dbuf.d_name,DIRSIZ);
			return(devnam);
		}
	}
	return(devnam);

}

dsearch(ddir,fno)
short ddir, fno;
{
	lseek(ddir, (long)0, 0);
	while(read(ddir, &dbuf, sizeof dbuf) == sizeof dbuf) {
		if(!dbuf.d_ino) continue;
		if(stat(dbuf.d_name, &S) == -1) {
			fprintf(stderr, "devnm: cannot stat %s\n",dbuf.d_name);
			return(0);
		}
		if((fno != S.st_rdev) 
		|| ((S.st_mode & S_IFMT) != S_IFBLK)
		|| (strcmp(dbuf.d_name,"swap") == 0)
		|| (strcmp(dbuf.d_name,"pipe") == 0)
			) continue;
		return(1);
	}
	return(0);
}

long lseek();

bread(fi, bno, buf, cnt)
	int fi;
	daddr_t bno;
	char *buf;
{
	int n;
	extern errno;

	(void) lseek(fi, (long)(bno * DEV_BSIZE), 0);
	if ((n=read(fi, buf, cnt)) != cnt) {
		/* probably a dismounted disk if errno == EIO */
		if (errno != EIO) {
			printf("\nread error bno = %ld\n", bno);
			printf("count = %d; errno = %d\n", n, errno);
		}
		return (0);
	}
	return (1);
}
