/*
 * $Header: trap.h,v 1.1 87/09/17 11:49:53 root Exp $
 */
/*	trap.h	6.1	83/11/30	*/

/*
 * IS68K {VQ}BUS 680{12}0 trap type values
 */

/* The first constant values are known to the real world <signal.h> */
#define	T_RESADFLT	0x00	/* reserved addressing fault */
#define	T_PRIVINFLT	0x01	/* privileged instruction fault */
#define	T_RESOPFLT	0x02	/* reserved operand fault */
/* End of known constants */
#define	T_BUSERR	0x03	/* bus error */
#define	T_ADDERR	0x04	/* address error */
#define	T_ZERODIV	0x05	/* divide by zero */
#define	T_CHK		0x06	/* CHK instruction */
#define	T_TRAPV		0x07	/* TRAPV instruction */
#define	T_SEGFLT	0x08	/* segment fault */
#define	T_PROTFLT	0x09	/* protection fault */
#define	T_TRCTRAP	0x0A	/* trace trap */
#define	T_NMI		0x0B	/* nonmaskable interrupt */
#define	T_PAGEFLT	0x0C	/* page fault */
#define	T_L1010EM	0x0D	/* line 1010 emulation */
#define	T_L1011EM	0x0E	/* line 1011 emulation */
#define	T_FMTERR	0x0F	/* stack format error */
#define	T_TRAP		0x10	/* trap instruction */
#define	T_SYSCALL	0x11	/* system call instruction */
#define	T_ASTFLT	0x12	/* asynchronous trap */
#define	T_STRAY		0x13	/* stray trap or interrupt */
#define	T_BPTFLT	0x14	/* breakpoint fault trap */
#define T_SEGVIO	0x15	/* segment violation */
#define T_CNTXFLT	0x16	/* context fault (68020) */
#define	T_COPROC	0x17	/* coprocessor protocol violation (68020) */
#define	T_FPE		0x18	/* floating point exception (68881) */
#define T_RESCHED	0x19	/* rescheduling trap */
#define T_PGRDFLT	0x17	/* page read fault */


#ifdef	TRAP_TYPE
/*
 * The following array must match above indexes.
 */
char	*trap_type[] = {
	"Reserved addressing mode",
	"Privileged instruction",
	"Reserved operand",
	"Bus error",
	"Address error",
	"Divide by zero",
	"CHK trap",
	"TRAPV trap",
	"Segment fault",
	"Protection violation",
	"Trace trap",
	"Nonmaskable interrupt",
	"Page fault",
	"Line 1010 emulation trap",
	"Line 1011 emulation trap",
	"Stack format trap",
	"Trap trap",
	"System call trap",
	"Asynchronous trap",
	"Stray interrupt",
	"Breakpoint trap",
	"Segment violation",
	"Context fault",
	"Coprocessor violation",
	"Floating point exception",
	"Reschedule CPU",
};
#define	NTRAP_TYPES	(sizeof trap_type / sizeof trap_type[0])

/*
 * 680{12}0 exception stack frame layouts and extended layouts.
 *
 * The "esf" structures describe the 68020 hardware stack frames.
 * The "xsf" structures extend the short status register to a full
 * longword to match the kernel stack (the pc and psl must look like
 * elements in an array of ints).
 */
#ifndef	LOCORE

/* 68010, and 68020
 * format 0:	Normal 4-word stack frame - interrupts, format errors,
 *		trap #n, illegal instructions, A-line and F-line emulator traps,
 *		privilege violations, coprocessor pre-instruction exceptions.
 */
struct esf0 {	
	ushort	esf_sw;		/* status register */
	uint	esf_pc;		/* program counter */
	ushort	esf_vec;	/* stack format and vector offset */
};
struct xsf0 {	
	uint	xsf_psl;	/* program status longword */
	uint	xsf_pc;		/* program counter */
	ushort	xsf_vec;	/* stack format and vector offset */
};

/* 68020
 * format 1:	Throwaway 4-word stack frame - interrupt while in master state.
 */
struct esf1 {
  	ushort	esf_sw;		/* status register */
	uint	esf_pc;		/* program counter */
	ushort	esf_vec;	/* stack format and vector offset */
};
struct xsf1 {	
	uint	xsf_psl;	/* program status longword */
	uint	xsf_pc;		/* program counter */
	ushort	xsf_vec;	/* stack format and vector offset */
};

/* 68020
 * format 2:	Normal 6-word stack frame - chk, chk2, cptrapcc, trapv trace,
 *		zero divide, and coprocessor post-instruction exceptions.
 */
struct esf2 {	
	ushort	esf_sw;		/* status register */
	uint	esf_pc;		/* program counter */
	ushort	esf_vec;	/* stack format and vector offset */
	uint	esf_iaddr;	/* addr of instr causing trap */
};
struct xsf2 {	
	uint	xsf_psl;	/* program status longword */
	uint	xsf_pc;		/* program counter */
	ushort	xsf_vec;	/* stack format and vector offset */
	uint	xsf_iaddr;	/* addr of instr causing trap */
};

/* 68010
 * format 8:	Bus Error on 68020.
 */
struct esf8 {	
	ushort	esf_sw;		/* status register */
	uint	esf_pc;		/* program counter */
	ushort	esf_vec;	/* stack format and vector offset */
	ushort	esf_ssw/*_10*/;	/* special status word */
	uint	esf_faddr/*_10*/;	/* data cycle fault addr */
	ushort	esf_rsv0;	/* reserved by Motorola */
	ushort	esf_dob;	/* data output buffer */
	ushort	esf_rsv1;	/* reserved by Motorola */
	ushort	esf_dib;	/* data input buffer */
	ushort	esf_rsv2;	/* reserved by Motorola */
	ushort	esf_ii[16];	/* internal information */
};
struct xsf8 {	
	uint	xsf_psl;	/* program status longword */
	uint	xsf_pc;		/* program counter */
	ushort	xsf_vec;	/* stack format and vector offset */
	ushort	xsf_ssw_10;	/* special status word */
	uint	xsf_faddr_10;	/* data cycle fault addr */
	ushort	xsf_rsv0;	/* reserved by Motorola */
	ushort	xsf_dob;	/* data output buffer */
	ushort	xsf_rsv1;	/* reserved by Motorola */
	ushort	xsf_dib;	/* data input buffer */
	ushort	xsf_rsv2;	/* reserved by Motorola */
	ushort	xsf_ii[16];	/* internal information */
};

/* 68020
 * format 9:	Coprocessor mid-instruction 10-word stack frame.
 */
struct esf9 {	
	ushort	esf_sw;		/* status register */
	uint	esf_pc;		/* program counter */
	ushort	esf_vec;	/* stack format and vector offset */
	uint	esf_iaddr;	/* addr of coproc instr */
	uint	esf_ireg[2];	/* internal regs */
};
struct xsf9 {	
	uint	xsf_psl;	/* program status longword */
	uint	xsf_pc;		/* program counter */
	ushort	xsf_vec;	/* stack format and vector offset */
	uint	xsf_iaddr;	/* addr of coproc instr */
	uint	xsf_aireg[2];	/* internal regs */
};

/* 68020
 * format A:	Short bus cycle fault stack frame - address error or bus error
 *		on instruction boundary.
 */
struct esfa {	
	ushort	esf_sw;		/* status register */
	uint	esf_pc;		/* program counter */
	ushort	esf_vec;	/* stack format and vector offset */
	ushort	esf_reg1;	/* internal reg */
	ushort	esf_ssw;	/* special status word */
	ushort	esf_ipipec;	/* instr pipe stage C */
	ushort	esf_ipipeb;	/* instr pipe stage B */
	uint	esf_faddr;	/* data cycle fault addr */
	uint	esf_ireg2;	/* internal reg */
	uint	esf_idob;	/* data output buffer */
	uint	esf_ireg3;	/* internal reg */
};
struct xsfa {	
	uint	xsf_psl;	/* program status longword */
	uint	xsf_pc;		/* program counter */
	ushort	xsf_vec;	/* stack format and vector offset */
	ushort	xsf_sreg1;	/* internal reg */
	ushort	xsf_ssw;	/* special status word */
	ushort	xsf_ipipec;	/* instr pipe stage C */
	ushort	xsf_ipipeb;	/* instr pipe stage B */
	uint	xsf_faddr;	/* data cycle fault addr */
	uint	xsf_ireg2;	/* internal reg */
	uint	xsf_idob;	/* data output buffer */
	uint	xsf_ireg3;	/* internal reg */
};

/* 68020
 * format B:	Long bus cycle fault stack frame - address error or bus error
 *		not on instruction boundary.
 */
struct esfb {
	ushort	esf_sw;		/* status register */
	uint	esf_pc;		/* program counter */
	ushort	esf_vec;	/* stack format and vector offset */
	ushort	esf_sreg1;	/* internal reg */
	ushort	esf_ssw;	/* special status word */
	ushort	esf_ipipec;	/* instr pipe stage C */
	ushort	esf_ipipeb;	/* instr pipe stage B */
	uint	esf_faddr;	/* data cycle fault addr */
	uint	esf_ireg2;	/* internal reg */
	uint	esf_idob;	/* data output buffer */
	uint	esf_aireg3[2];	/* internal reg */
	uint	esf_ibaddr;	/* stage B addr */
	uint	esf_ireg4;	/* internal reg */
	uint	esf_idib;	/* data input buffer */
	uint	esf_aireg5[11];	/* internal regs */
};
struct xsfb {
	uint	xsf_psl;	/* program status longword */
	uint	xsf_pc;		/* program counter */
	ushort	xsf_vec;	/* stack format and vector offset */
	ushort	xsf_sseg1;	/* internal reg */
	ushort	xsf_ssw;	/* special status word */
	ushort	xsf_ipipec;	/* instr pipe stage C */
	ushort	xsf_ipipeb;	/* instr pipe stage B */
	uint	xsf_faddr;	/* data cycle fault addr */
	uint	xsf_ireg2;	/* internal reg */
	uint	xsf_idob;	/* data output buffer */
	uint	xsf_aireg3[2];	/* internal reg */
	uint	xsf_ibaddr;	/* stage B addr */
	uint	xsf_ireg4;	/* internal reg */
	uint	xsf_idib;	/* data input buffer */
	uint	xsf_aireg5[11];	/* internal regs */
};

/*
 * Union of all stack frame layouts
 */
union esf {
	struct esf0	f0;
	struct esf1	f1;
	struct esf2	f2;
	struct esf8	f8;
	struct esf9	f9;
	struct esfa	fa;
	struct esfb	fb;
};
union xsf {
	struct xsf0	xf0;
	struct xsf1	xf1;
	struct xsf2	xf2;
	struct xsf8	xf8;
	struct xsf9	xf9;
	struct xsfa	xfa;
	struct xsfb	xfb;
};
#endif	!LOCORE
#endif	TRAP_TYPE

/*
 * Stack frame formats in vector offset word.
 */
#define	ESF_VECMSK	0x0fff		/* mask for sVec vector offset */
#define	ESF_FMTMSK	0xf000		/* mask for sVec formats */
#define	ESF_FMT0	0x0000		/* stack format 0 68010, 68020*/
#define	ESF_FMT1	0x1000		/* stack format 1 68020*/
#define	ESF_FMT2	0x2000		/* stack format 2 68020*/
#define	ESF_FMT8	0x8000		/* stack format 8 68010*/
#define	ESF_FMT9	0x9000		/* stack format 9 68020*/
#define	ESF_FMTA	0xa000		/* stack format A 68020*/
#define	ESF_FMTB	0xb000		/* stack format B 68020*/
#define	ESF_SOFT	0x4000		/* Software collapse frame bit */
#define	ESF_SOFT_BIT	6		/* bit in upper byte */

/*
 * Stack frame sizes in bytes.
 */
#define	ESF_ISIZE0	8
#define	ESF_ISIZE1	8
#define	ESF_ISIZE2	12
#define	ESF_ISIZE8	58
#define	ESF_ISIZE9	20
#define	ESF_ISIZEA	32
#define	ESF_ISIZEB	92

#define	XSF_ISIZE0	(ESF_ISIZE0 + 2)
#define	XSF_ISIZE1	(ESF_ISIZE1 + 2)
#define	XSF_ISIZE2	(ESF_ISIZE2 + 2)
#define	XSF_ISIZE8	(ESF_ISIZE8 + 2)
#define	XSF_ISIZE9	(ESF_ISIZE9 + 2)
#define	XSF_ISIZEA	(ESF_ISIZEA + 2)
#define	XSF_ISIZEB	(ESF_ISIZEB + 2)

/*
 * Special status word
 */
#define	ESF_SSW_AFC	0x0007		/* data cycle address function code */
#define	ESF_SSW_SIZ	0x0030		/* data cycle size code */
#define	ESF_SSW_RW	0x0040		/* data cycle read/write (read==1) */
#define	ESF_SSW_RM	0x0080		/* data cycle read/modify/write  */
#define	ESF_SSW_DF	0x0100		/* data cycle fault/rerun flag  */
#define	ESF_SSW_RB	0x1000		/* instr pipe stage B rerun flag */
#define	ESF_SSW_RC	0x2000		/* instr pipe stage C rerun flag */
#define	ESF_SSW_FB	0x4000		/* instr pipe stage B fault flag */
#define	ESF_SSW_FC	0x8000		/* instr pipe stage C fault flag */
#define ESF_SSW_SOFTMSK	~(ESF_SSW_DF|ESF_SSW_RB|ESF_SSW_RC) /* dont rerun */

#define	ESF_SSW_10_AFC	0x0007		/* data cycle address function code */
#define	ESF_SSW_10_RW	0x0100		/* data cycle read/write (read==1) */
#define	ESF_SSW_10_BY	0x0200		/* byte transfer flag */
#define	ESF_SSW_10_HB	0x0400		/* high byte */
#define	ESF_SSW_10_RM	0x0800		/* read/modify/write cycle */
#define	ESF_SSW_10_DF	0x1000		/* data fetch flag */
#define	ESF_SSW_10_IF	0x2000		/* instruction fetch flag */
#define	ESF_SSW_10_RR	0x8000		/* Re-run flag, 1-> software rerun */
