/*
 * $Header: psl.h,v 1.1 87/09/17 11:48:31 root Exp $
 */
/*	psl.h	6.1	83/11/29	*/

/*
 * IS680{12}0 program status longword
 */

#define	PSL_C		0x00000001	/* carry bit */
#define	PSL_V		0x00000002	/* overflow bit */
#define	PSL_Z		0x00000004	/* zero bit */
#define	PSL_N		0x00000008	/* negative bit */
#define	PSL_X		0x00000010	/* extend bit */
#define	PSL_ALLCC	0x0000001F	/* all cc bits - unlikely */
#define	PSL_IPL		0x00000700	/* interrupt priority level */
#define PSL_M		0x00001000	/* 68020 master (interrupt mode=0) */
#define PSL_S		0x00002000	/* system mode (user mode = 0) */
#define	PSL_T0		0x00004000	/* 68020 flow trace bit */
#define	PSL_T1		0x00008000	/* trace bit */

#define	PSL_MBZ		0xFFFF58E0	/* must be zero bits */
#define	PSL_CURMOD	PSL_S
#define	PSL_T		PSL_T1

#define	PSL_USERSET	(0)
#define	PSL_USERCLR	(PSL_S|PSL_M|PSL_IPL|PSL_MBZ)

#define PSL_IPL_SHIFT	8		/* shift for interrupt priority */
#define	PSL_HIGH	0x00000700	/* or bits for high priority */
#define	PSL_LOW		0xFFFFF8FF	/* and bits for low priority */

#define	PSL_IPL0	(PSL_CURMOD+(0<<PSL_IPL_SHIFT))
#define	PSL_IPL1	(PSL_CURMOD+(1<<PSL_IPL_SHIFT))
#define	PSL_IPL2	(PSL_CURMOD+(2<<PSL_IPL_SHIFT))
#define	PSL_IPL3	(PSL_CURMOD+(3<<PSL_IPL_SHIFT))
#define	PSL_IPL4	(PSL_CURMOD+(4<<PSL_IPL_SHIFT))
#define	PSL_IPL5	(PSL_CURMOD+(5<<PSL_IPL_SHIFT))
#define	PSL_IPL6	(PSL_CURMOD+(6<<PSL_IPL_SHIFT))
#define	PSL_IPL7	(PSL_CURMOD+(7<<PSL_IPL_SHIFT))
