/*
 * $Header: dart.h,v 1.1 87/09/17 11:46:16 root Exp $
 */
/*
 * Zilog DART device registers.
 * Note that port B can be accessed
 * as port A+2.
 */
struct daregs {
	char fill0;	unsigned char adata;
	char fill1;	unsigned char bdata;
	char fill2;	unsigned char actrl;
	char fill3;	unsigned char bctrl;
};

/* read register 0  (status) */
#define R0_RXRDY	0x01		/* Rx char available */
#define R0_TXRDY	0x04		/* Tx buffer empty */
#define R0_DCD		0x08		/* data carrier detect */
#define R0_RING		0x10		/* ring indicator */
#define R0_CTS		0x20		/* clear to send */
#define R0_BREAK	0x80		/* break received */

/* write register 0  (command register) */
#define W0_RMASK	0x07	/* bits for register selection */
#define W0_NULL		0x00	/* null code */
#define W0_REXT		0x10	/* reset external & status interrupts */
#define W0_RESET	0x18	/* channel reset */
#define W0_RXINT	0x20	/* enable interrupt on next Rx char */
#define W0_TXPEND	0x28	/* reset Tx interrupt char */
#define W0_RERR		0x30	/* error reset */
#define W0_RETINT	0x38	/* return from interrupt (port A only) */

/* write register 1  (recv/xmit interrupt ctrl) */
#define W1_EXTINT	0x01	/* external interrupt enable */
#define W1_TXINT	0x02	/* xmit interrupt enable */
#define W1_STATVEC	0x04	/* status affects vector (port B only) */
#define W1_RXDISBL	0x00	/* Rx intr disable */
#define W1_RX1ST	0x08	/* Rx intr on 1st char */
#define W1_RXALLPV	0x10	/* Rx interrupt on all chars w/parity vector */
#define W1_RXALL	0x18	/* Rx interrupt on all chars */
#define W1_WRDYRT	0x20	/* wait/ready request on recv/xmit */
#define W1_WRDYRF	0x40	/* wait/ready request function */
#define W1_WRDYRE	0x80	/* wait/ready request enable */

/* write register 2  (interrupt vector, port B only) */

/* write register 3  (recv params & control) */
#define W3_RXENBL	0x01	/* Rx enable */
#define W3_AUTO		0x20	/* auto enable */
#define W3_5BITS	0x00	/* 5 bits/char */
#define W3_7BITS	0x40	/* 7 bits/char */
#define W3_6BITS	0x80	/* 6 bits/char */
#define W3_8BITS	0xc0	/* 8 bits/char */
#define W3_BMASK	0xc0	/* mask for Rx bits/char */

/* write register 4  (parameter register) */
#define W4_PENBL	0x01	/* parity enable */
#define W4_PEVEN	0x02	/* even parity */
#define W4_1STOP	0x04	/* 1 stop bit */
#define W4_2STOP	0x0c	/* 2 stop bits */
#define W4_X1		0x00	/* x1 clock mode */
#define W4_X16		0x40	/* x16 clock mode */
#define W4_X32		0x80	/* x32 clock mode */
#define W4_X64		0xc0	/* x64 clock mode */
#define W4_XMASK	0xc0	/* mask for clock bits */

/* write register 5  (xmit params & control) */
#define W5_RTS		0x02	/* request to send */
#define W5_TXENBL	0x08	/* Tx enable */
#define W5_BREAK	0x10	/* send break */
#define W5_5BITS	0x00	/* 5 bits/char */
#define W5_7BITS	0x20	/* 7 bits/char */
#define W5_6BITS	0x40	/* 6 bits/char */
#define W5_8BITS	0x60	/* 8 bits/char */
#define W5_BMASK	0x60	/* mask for Tx bits/char */
#define W5_DTR		0x80	/* data terminal ready */

/* structure for storing baud rate parameters */
struct daspeeds {
	char da_ctc;	/* time constant for CTC chip */
	char da_dart;	/* prescale constant for DART chip */
};

/*
 * Zilog CTC device registers.
 */
struct ctcregs {
	char fill4;	char ctrl;
};

#define CTC_CTRL	0x01	/* control word */
#define CTC_RESET	0x02	/* software reset */
#define CTC_TCF		0x04	/* time constant follows */
#define CTC_CNT		0x40	/* select counter mode */
#define CTC_IENBL	0x80	/* interrupt enable */
