/*
 * $Header: cpureg.h,v 1.1 87/09/17 11:45:54 root Exp $
 */
/*
 * IS-68010 VME CPU card constants:
 */

#define	MEMR_MASK	0xFF800000	/* memory region mask */
#define	MAXU_ADDR	0x00800000	/* size of user virtual space */
#define	SYSV_BASE	0x00000000	/* system virtual base */
#define	NONT_MASK	0x007FFFFF	/* non-translated address space mask */

/* CONTEXT/BOARD STATUS REGISTER (CBX) */
#ifdef LOCORE
#define	CBX		0xC1A000
#else  LOCORE
#define	CBX		((ushort *)0xC1A000)
#endif LOCORE
#define CXR		CBX
#define BSR		CBX
#define CTXMASK		0x0f
#define CTXSHIFT	0

/* CONSOLE BAUD RATE */
#define	BSR_E39		0x0080		/* jumper to E38, reads as zero */
#define	BSR_E40		0x0040		/* jumper to E38, reads as zero */
#define	BSR_BAUD	(BSR_E39|BSR_E40)/* E39 and E40 determine baud rate */
#define BSR_BAUD_9600	(BSR_E39|BSR_E40)/* no jumpers at E39 or E40 */
#define BSR_BAUD_19200	(BSR_E39)	/* E40 jumpered to E38 */
#define BSR_BAUD_1200	(BSR_E40)	/* E39 jumpered to E38 */
#define BSR_BAUD_300	(0) 		/* E39 and E40 jumpered to E38 */

/* CPU SPEED */
#define BSR_NSPEEDS	4
#define	BSR_E41		0x0020		/* jumper in, reads as zero */
#define	BSR_E42		0x0010		/* jumper in, reads as zero */
#define	BSR_CPUSPEED	(BSR_E41|BSR_E42) /* E42 determines the CPU speed */
#define	BSR_CPUSPEED10	(BSR_E41|BSR_E42) /* no jumper on E41 or E42 */
#define	BSR_CPUSPEED12	(BSR_E41)	/* E42 is jumpered to E38 */
#define	BSR_CPUSPEED11	(BSR_E42)	/* E41 is jumpered to E38 */
#define	BSR_CPUSPEED8	(0)		/* E41 and E42 are jumpered to E38 */

/* PARITY ENABLE/DISABLE */
#define	BSR_PARITYON	0x0100		/* turn parity checking on */
#define	BSR_PARITYOFF	0x0200		/* turn parity checking off */

/* PROM */
#ifdef LOCORE
#define	PROM		0xC00000
#else  LOCORE
#define	PROM		((ushort *)0xC00000)
#endif LOCORE

#define	PROM_BASE	PROM
#define PROM_REBOOT	PROM+8

/* NUMBER OF CONTEXTS */
#define NCTX	16	

/* SEGMENT REGISTERS */
#define NSEGPERCTX	64		/* number of segs per context */
#define NSEGREG		NSEGPERCTX*NCTX	/* total number of seg registers */
#define	SEGREGBASE	0x810001	/* base address of seg registers */
#define	SEGPROTMASK	0xC0		/* mask for protection bits */
#define SEGPROT_NO	0x00		/* protection for no access */
#define SEGPROT_REO	0x40		/* protection for read execute only */
#define SEGPROT_ALL	0x80		/* protection for all access */
#define SEGPROT_EO	0xC0		/* protection for user execute only */
#define	SEGPROTSHIFT	6		/* shift to right justify protection */
#define SEGINVALID	0		/* SEGPROT_NO, invalid segment   vio */
#define SEGPAGEDOUT	1		/* SEGPROT_NO, paged out segment flt */
#define	SEGREGINCR	0x020000	/* incr to next seg reg in same ctx */
#define SEGREGSHIFT	17		/* shift for #<=>seg reg conversion */
#define SEGCTXINCR	0x000800	/* incr to same seg reg in next ctx */
#define SEGCTXSHIFT	11		/* shift for #<=>ctx reg conversion */
#define SEGNXTINCR	1		/* incr contents of reg for next seg */

/* PAGE REGISTERS */
#define NPAGPERSEG	32		/* number of pages in a segment */
#define PAGSEGSHIFT	5		/* shift for pag<=>seg conversion */
#define NPAGBANKS	64		/* number of page register banks */
#define NPAGREG		NPAGBANKS*NPAGPERSEG /* number of page registers */
#define	PAGREGBASE	0xC18000	/* base address of page registers */
#define	PAGREGINCR	0x000002	/* incr to next page register */
#define PAGREGSHIFT	1		/* shift for #<=>pag reg conversion */
#define PAGNXTINCR	1		/* incr contents of pag for next page */
#define PAGREFBIT	15		/* page referenced bit */
#define PAGMODBIT	14		/* page modified bit */
#define PAGOUTBIT	13		/* paged out bit */
#define PAGINVBIT	12		/* page invalid bit */
#define PAGNUMMASK	0xFFF		/* mask for physical page number */
