/*
 * $Header: pfdat.h,v 1.1 87/09/17 11:31:49 root Exp $
 */
/* @(#)pfdat.h	1.1 */


typedef struct pfdat {
	unsigned int	pf_flags : 8,	/* page flags		*/
			pf_blkno : 24;	/* Disk block nummber.	*/
	cnt_t		pf_use;		/* share use count	*/
	dev_t		pf_dev;		/* Disk device code.	*/
	char		pf_swpi;	/* Index into swaptab.	*/
	struct pfdat	*pf_next;	/* Next free pfdat.	*/
	struct pfdat	*pf_prev;	/* Previous free pfdat.	*/
	struct pfdat	*pf_hchain;	/* Hash chain link.	*/
} pfd_t;

#define	P_QUEUE		0x01	/* Page on free queue		*/
#define	P_BAD		0x02	/* Bad page (ECC error, etc.)	*/
#define	P_HASH		0x04	/* Page on hash queue		*/
#define	P_DONE		0x08	/* IO done on page		*/
#define	P_WANT		0x10	/* page needed			*/

extern struct pfdat phead;
extern struct pfdat pbad;
extern struct pfdat *pfdat;
extern struct pfdat *phash;
extern struct pfdat ptfree;
extern int phashmask;

extern struct pfdat	*pfind();



#define BLKNULL		0	/* pf_blkno null value		*/
