/*
 * $Header: mmu.h,v 1.1 87/09/17 11:31:12 root Exp $
 */
/*
 * Constants and definitions for the CPU board
 */

#define	CPUSTAT		0xC30000	/* System configuration & status reg */
#define	CTCBASE		0xC20000	/* Clock chan 0 base address */
#define	CPUEXCP		0xC10000	/* System context & exception reg */
#define	CPUSPEED	0xC00000	/* CPU speed register (in PROM) */

/*
 * CPU Status Reg bits
 */
#define	ST_PWRFL	0x200		/* Power fail in 4ms */
#define	ST_QBPAR	0x100		/* Q-bus parity error */
#define	ST_OBPAR	0x080		/* On-board parity error */
#define	ST_HALT		0x040		/* HALT line asserted */

/*
 * Constants to define the Context Register.
 * The CPU has a Context Register which selects
 * one sixteenth of the Segment Map. Writing to the
 * Context Register sets the current context number.
 */

#define CONTEXT 0xC10000	/* Context base address */

#define SYSCX	0		/* System context */
#define USERCX	1		/* Beginning of user contexts */
#define NUMUCONTX 15		/* Number of user contexts */
#define NUMCONTX 16		/* Number of contexts */

/* Constants to define the Segment Map Structures */

#define SEGBASE	0x400000	/* Segment map base address */
#define	NSEGMAP 64		/* Number of segments per context */
#define	SEGINCR	0x10000		/* Increment from one entry to next */
#define	SEGSIZE	0x10000		/* Segment size */

/*
 * Segment map access control.
 * The Access Controls for each segment are defined
 * in terms of Read, Write, and Execute access.
 * These are defined in the table below.
 */
#define ___	0x00
#define r_x	0x40
#define rwx	0x80
#define __x	0xC0

/* mask for above bits */
#define PROTMASK 0xC0

/* Constants to define the Page Map */

#define PAGEBASE 0x800000	/* Page map base address */
#define NPAGEMAP 1024		/* Number of Page Map entries */
#define PAGEINCR 0x1000		/* Increment from one entry to next */
#define PAGESIZE 0x1000		/* Page size */
#define PGINVAL	 0x3FC		/* Page is invalid */

/*
 * Definitions for memory management.
 */
#define SEGMASK		0x3F0000	/* mask of segment number as address */
#define SEGNMASK	0x3F		/* mask of segment number as number */
#define SEGSHIFT	16		/* shift of segment number */
#define PAGEMASK	0xF000		/* mask of page number */
#define PAGESHIFT	12		/* shift of page number */
#define OFFMASK		0xFFF		/* mask of address offset */
#define SMASK		0x03F		/* page number mask in seg reg */
#define PMASK		0x0FFF		/* phys base in page register */
#define CXSHIFT		4		/* shift of context number in reg */
#define CXMASK		0xF0		/* mask of context number */
#define NPPS	(SEGSIZE/PAGESIZE)	/* Number of pages per segment */
#define ADDRMASK	0x7FFFFF	/* valid address bits */

	/* context number to actual context data */
#define cxntocx(x)	((x) << CXSHIFT)

	/* context data to context number */
#define cxtocxn(x)	(((x) >> CXSHIFT) & 0xF)

	/* virtual address to segment number */
#define vtosegn(x)	(((int)(x) & SEGMASK) >> SEGSHIFT)

	/* read context register and return a context number */
#define readcx()	((*(short *)CONTEXT & CXMASK) >> CXSHIFT)
#define setcx(cx)	(*(short *)CONTEXT = cx)

	/* page bits to page register and back */
#define pbtopr(x)	((int)(x)<<2)
#define prtopb(x)	((int)(x)>>2)

short *vtoseg();
short *vtopage();
short *sysvtoseg();
short *sysvtopage();

	/* size of the current process */
#define procsize(p)	((p)->p_size)
