/*
 * $Header: lpv11.h,v 1.1 87/09/17 11:31:02 root Exp $
 */
/*
** LPV11 Device Registers
*/
struct lpvregs
{
	short lpcs;
	char fill;	char lpdb;
};

/* Status register */
# define CS_ERROR	0x8000		/* General purpose error bit */
# define CS_DONE	0x80		/* Ready for next character */
# define CS_IE		0x40		/* Interrupt enable */
# define CS_ONLINE	0x02		/* On-line (for SOME printers) */
# define CS_BUSY	0x01		/* Printing/advancing (SOME printers) */


/* Data register */
# define DB_PARITY	0x80		/* Parity bit (not in lpv11 driver) */

# define LPPRI		(PZERO + 8)
# define LPLOWAT	40
# define LPHIWAT	100
# define LPMAX		2

# define FORM		0xC
