/*
 * $Header: context.h,v 1.1 87/09/17 11:29:12 root Exp $
 */
/*
 * Copyright 1982 UniSoft Corporation
 */

/*
 * Context structure.
 * One allocated per active page
 * register context. There are
 * NUMCONTX (16) contexts in hardware.
 */
struct context {
	struct	context *cx_forw;	/* forward pointer */
	struct	context *cx_back;	/* back pointer */
	struct	proc *cx_proc;		/* pointer to proc structure */
	short	cx_daddr;		/* starting data segment address */
	short	cx_dsize;		/* data size of allocated segments */
	short	cx_num;			/* context number of this slot 1 to 1 */
	struct cxphys {
		short	cx_phaddr;	/* sysphys address slot */
		short	cx_phsize;	/* sysphys data slot count */
	} cx_phys[NPHYS];
};

extern struct context context[];

struct context *cxalloc();
struct context *cxunlink();

#ifdef LINT
struct dp {
	int	dp_anything;
};
#endif
