/*
 * $Header: config.h,v 1.1 87/09/17 11:29:08 root Exp $
 */
/*
 * System specific configuration information
 */

/*
 * Define layout of memory for the CTx-300
 * 000000-3FFFFF can be mapped
 * 400000-7FFFFF is segment map
 *	01SSSSSSCCCC------------ where
 *		SSSSSS is segment number
 *		CCCC is context number
 * 800000-BFFFFF is page map
 * C00000-FFFFFF is I/O space
 */

#define NSYSSEG		4		/* Number of kernel system segments */
#define CTLSEG		0x3F0000	/* Control segment */
#define IOPAGE0		0x3FF000	/* page for Q-bus I/O */
#define IOPAGE1		0x3FE000	/* page for Q-bus I/O */
#define UDOTPAGE	0x3FB000	/* Logical base of udot area */
#define SCRPG3		0x3FA000	/* Scratch page 3 */
#define SCRPG2		0x3F9000	/* Scratch page 2 */
#define SCRPG1		0x3F8000	/* Scratch page 1 */
#define SCRPG0		0x3F7000	/* Scratch page 0 */

#define BOOTADDR	0xC00008	/* PROM reboot address */
