/*
 * $Header: nscdef.h,v 1.1 87/09/17 11:28:07 root Exp $
 */
#ifndef	ATM
#include	"sys/nsc.h"
#endif


#define min(a, b)	(a < b ? a : b)

/*
	constant definitions for message and data block x-fer
							*/


#define BLOCK	1		/* wait until adapter message available */
#define NOBLOCK 0		/* if no message available, return immediately */


struct nsconf{
	int	n_fd;		/* open file descriptor from open */
	char	n_flags;	/* library flags */
	char	n_mode;		/* file open mode */
	short	n_resid;	/* residual word count for writes */
	short	n_blksz;	/* maximum block size for writes */
	int	(*n_func)();	/* function to call if write fails with errno = EINTR */
	short	n_retry;	/* number of retries before abort */
	short	n_rmb;		/* number of bytes always in message on read (DATA MODE ONLY) */
	short	n_wmb;		/* number of bytes always in message on write (DATA MODE ONLY) */
};

#define	N_CALL		010
#define	N_SPLIT		020
#define	N_DATA		040
#define	N_CTRL		0100

#define	NSCIOBLKSZ	(('n'<<8)|20)
#define	NSCIORINTR	(('n'<<8)|21)
#define	NSCIORETRY	(('n'<<8)|22)
#define	NSCIOSPLIT	(('n'<<8)|23)
#define	NSCIONSPLIT	(('n'<<8)|24)

struct nscdest{
	char	*lnknm;
	int	netadr;
	int	trunk;
};

/*	NSC error codes		*/

#define EAOK		0	/*   All is fine */
#define	ECRMOD		1	/* Can't clear rcv mode - a-data in adapter */
#define	EMSGL		2	/* incorrect message length (<9, >64) */
#define	ESPAC		3	/* no space available in adapter */
#define	EDOWN		4	/* "to" port marked down */
#define	EABIG		5	/* no space available for associated data */
#define	ELARG		6	/* associated data too large for adapter */
#define	EFUNC		7	/* illegal function code */
#define	EFEWP		10	/* not enough parameters */
#define	EMANYP		11	/* too many parameters */
#define	EFEWD		12	/* not enough data sent to adapter */
#define	EMUCHD		13	/* too much data send to adapter */
#define	EDATA		14	/* not all data read from adapter */
#define	ETDAT		15	/* host attempted to read too much data */
#define	ENOMSG		16	/* no messages waiting to input */
#define	EMCLR		17	/* host master-cleared during transfer */
#define	EQUIT		18	/* host quit early, not all data xferred */
#define	ELPAR		19	/* parity error on adapter to host xfer */
#define	ETABT		20	/* trunk abort - see bytes 2-4 */
#define	ELRSV		21	/* device reserved to this adapter */
#define	ETRY		22	/* trunk x-missions counter expired */
#define	ENODAT		23	/* remote adapter did not send a-data */
#define	EOPN		24	/* to many open to driver */
#define	EISDA		25	/* invalid symbolic destination addr */
#define	EFOPN		26	/* file not open or open failed */
#define	ETYPE		27	/* conection of same type already exists */
#define	ESTAT		28	/* status failed, reason unknown */
#define	EPAHX		29	/* internal adapter parity error */
#define	EARSV		30	/* receiving adapter rsrvd by another adapter */
#define	EDRSV		31	/* receiving adapter rsrvd by attached dev. */
#define	ERSRVD		32	/* adapter trunk logic reserved */
#define	ERFLG		33	/* error in receiving adapter fflag bits */
#define	EXFER		34	/* error in xfer to receiving adapter */
#define	EIFNC		35	/* Illegal frame function detected by rcvr */
#define	EABUSY		36	/* receiving adapter busy temporarily */
#define	EDBUSY		37	/* function rejected, driver busy */
#define	ELBUSY		38	/* function rejected by adapter, adapter busy */
#define	ETIME		39	/* trunk timeout - remote did not answer */
#define	ERESP		40	/* header error on last x-mit response */
#define	EPTRK		41	/* Parity error on data x-mitted onto trunk */
#define	ECRSP		42	/* checkwork error on response */
#define	ETAVAIL		43	/* trunks specified not available */
#define	EIRR		44	/* invalid response by remote */
#define	EDRJT		45	/* incorrect funcition code sequence */
#define	ECONF		46	/* no nsc destination specified */
#define	ERDSC		47	/* error on read system call */
#define	EWRSC		48	/* error on write system call */
#define	ESTSC		49	/* error on error on stty/gtty (ioctl) call */
#define	ECLSC		50	/* error on close system call */

/*
 *    NSCGETTY - structure to return driver configuration parameters
 */

struct nscgetty{
	short	g_flags;	/* connection flags	*/
	char	g_openm;	/* open mode	*/
	char	g_vchan;	/* virtual channel of this connection	*/
	short	g_taddr;	/* to network address	*/
	char	g_acode;	/* access code	*/
	char	g_tmsk;		/* trunk mask	*/
	struct	nscasmb	g_asm;	/* assembly/disassembly modes	*/
};


/*
 *	NSCVCHAN - structure to configure virtual channel into driver
 */

struct nscvchan {
	short	v_tonad;	/* to network address	*/
	char	v_vchan;	/* virtual channel number	*/
	char	v_tmsk;		/* trunk mask	*/
	char	v_acode;	/* access code	*/
};

