#
# $Header: csh.mk,v 1.1 87/09/17 11:26:48 root Exp $
#
# invoked with DEST RELOC INCLUDE DOFF SHARED SHAREDV
RELOC = 00000

CC=	cc
LD=	ld
M=	.
DEST=	.
DOFF=	0
INCLUDE=	./head3
#	LDFLAGS=-R $(RELOC) -F $(DOFF) $(SHARED) $(SHAREDV)
#	LDFLAGS=-R $(RELOC) -s -F $(DOFF) $(SHARED) $(SHAREDV)
LDFLAGS= -s 
CFLAGS=	-DPWB -DTELL -DBUFSIZ=1024 -I$(INCLUDE) -O -v
B=	$(DEST)/bin
RM=	-rm
CTAGS=	ctags
CXREF=	cxref

OBJS=sh.o sh.dol.o sh.err.o sh.exec.o sh.exp.o sh.func.o sh.glob.o sh.hist.o \
	sh.lex.o sh.misc.o sh.parse.o sh.print.o sh.sem.o sh.set.o \
	sh.wait.o alloc.o sh.init.o printf.o doprnt.o $(PW) dup2.o

csh:	$(OBJS) sh.local.h
	$(CC) $(LDFLAGS) -o csh $(OBJS)

install:	csh
		install -o -n $(ROOT)/bin ./csh

lint:
	lint sh*.h sh*.c

print:
	@pr READ_ME
	@pr makefile makefile.*
	@(size -l csh; size *.o) | pr -h SIZES
	@$(CXREF) sh*.c | pr -h XREF
	@ls -l | pr 
	@pr sh*.h [a-rt-z]*.h sh*.c alloc.c

clean:
	$(RM) -f *.o
	$(RM) -f csh

clobber:	clean

tags:
	$(CTAGS) sh*.c

sh.o:	sh.c sh.h sh.local.h
