#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#):cpio.mk	1.1"

#	Makefile for cpio

ROOT =

DIR = $(ROOT)/bin

INC = $(ROOT)/usr/include

LDFLAGS = -s -lgen $(LDLIBS)

CFLAGS = -O -I$(INC)

STRIP = strip

SIZE = size

#top#
# Generated by makefile 1.46

MAKEFILE = Makefile


MAINS = cpio

OBJECTS =  cpio.o

SOURCES =  cpio.c

ALL:		$(MAINS)

cpio:		cpio.o	
	$(CC) $(CFLAGS)  -o cpio  cpio.o   $(LDFLAGS)


cpio.o:	 errmsg.h $(INC)/stdio.h \
		 $(INC)/sys/types.h $(INC)/errno.h \
		 $(INC)/sys/errno.h $(INC)/fcntl.h \
		 $(INC)/memory.h $(INC)/stdio.h \
		 $(INC)/signal.h $(INC)/sys/signal.h \
		 $(INC)/varargs.h	$(INC)/sys/stat.h	\
		 $(INC)/pwd.h 

GLOBALINCS = errmsg.h $(INC)/errno.h $(INC)/fcntl.h \
	$(INC)/memory.h $(INC)/pwd.h $(INC)/signal.h \
	$(INC)/stdio.h $(INC)/sys/errno.h \
	$(INC)/sys/signal.h $(INC)/sys/stat.h \
	$(INC)/sys/types.h $(INC)/varargs.h 


clean:
	rm -f $(OBJECTS)

clobber:
	rm -f $(OBJECTS) $(MAINS)

newmakefile:
	makefile -m -f $(MAKEFILE)  -s INC $(INC)
#bottom#

all : ALL

install: ALL
	cpset $(MAINS) $(DIR)

size: ALL
	$(SIZE) $(MAINS)

strip: ALL
	$(STRIP) $(MAINS)

#	These targets are useful but optional

partslist:
	@echo $(MAKEFILE) $(SOURCES) $(LOCALINCS)  |  tr ' ' '\012'  |  sort

productdir:
	@echo $(DIR) | tr ' ' '\012' | sort

product:
	@echo $(MAINS)  |  tr ' ' '\012'  | \
	sed 's;^;$(DIR)/;'

srcaudit:
	@fileaudit $(MAKEFILE) $(GLOBALINCS) $(SOURCES) -o $(OBJECTS) $(MAINS)
