/***********************************************************************
 * laserxt.h	-- misc includes for laser light show Xtoolkit routines
 *
 * Ron Wilder -- Integrated Solutions
 * 1 Sep 1989 -- date of birth
 *
 * $Header: laserxt.h,v 1.6 89/09/09 17:24:02 laser Locked $
 *
 ***********************************************************************/

typedef struct {
    int start_x, start_y, last_x, last_y;
    GC  gc;
} line_segment_data;


/* command button structure */
/* used to build up a menu button set of widgets */

typedef struct {
	char		*label;			/* string printed on button label */
	/* LOCAL storage */
	void		(*cmdfunc)();	/* pointer to command function */
} BUTTON;

/**********************************************************************/
/* this section sets the hard values for window locations             */
/*        PARAMETER      # OF PIXELS    General Comments              */
/*--------------------------------------------------------------------*/
#define OUTSIDE_BORDER		5		/* outside border */
#define INSIDE_BORDER		3		/* inside border */
#define PIX					1		/* size of a pixel */

/*#define GENERAL_LABEL_HEIGHT 20*/		/* most labels are this tall */
#define GENERAL_LABEL_HEIGHT 15		/* most labels are this tall */
#define GENERAL_BUTTON_WIDTH  60	/* most buttons are this wide */

#define GAIN_LABEL_WIDTH	45		/* width of X/Y gain labels */
#define GAIN_SBAR_LENGTH	200		/* height of X/Y scroll bars */

#define DRAW_RATE_LABEL_WIDTH 60	/* width of Draw rate label */
#define DRAW_RATE_SBAR_LENGTH 500	/* height of draw rate scroll bar */

/*---------------------------------------------------------------------*/

/***********************************************************************/
/**************** BE CAREFUL IF YOU MAKE CHANGES BELOW *****************/
/***********************************************************************/

#define ISI_LABEL_START_X	0
#define ISI_LABEL_START_Y	0

/* width of X/Y gain control label */
#define XY_GAIN_LABEL_WIDTH	GAIN_LABEL_WIDTH +		\
						INSIDE_BORDER +				\
						GAIN_LABEL_WIDTH 

/* width of entire xy gain box */
#define	XY_GAIN_WIDTH	INSIDE_BORDER + 			\
						GAIN_LABEL_WIDTH + 			\
						INSIDE_BORDER + 			\
						GAIN_LABEL_WIDTH + 			\
						INSIDE_BORDER +				\
						4 * PIX

/* height of entire xy gain box */
#define XY_GAIN_HEIGHT	INSIDE_BORDER +	 			\
						GENERAL_LABEL_HEIGHT + 		\
						INSIDE_BORDER + 			\
						GENERAL_LABEL_HEIGHT + 		\
						GAIN_SBAR_LENGTH + 			\
						INSIDE_BORDER  +			\
						6 * PIX

/* starting X pos. gang switch */
#define XY_GAIN_LABEL_START_X		INSIDE_BORDER	

/* starting Y pos. gang switch */
#define XY_GAIN_LABEL_START_Y		INSIDE_BORDER 	

/* start X pos. X gain section */ 
#define X_GAIN_START_X		INSIDE_BORDER	

/* start X pos. Y gain section */
#define Y_GAIN_START_X		INSIDE_BORDER + 		\
							GAIN_LABEL_WIDTH + 		\
							INSIDE_BORDER

/* start X pos entire xy gain box */
#define XY_GAIN_START_X		OUTSIDE_BORDER	

/* start Y pos. xy gain box*/
#define XY_GAIN_START_Y		ISI_LABEL_START_Y + 		\
							ISI_LABEL_HEIGHT +		\
							OUTSIDE_BORDER

#define X_GAIN_LABEL_START_X	INSIDE_BORDER

#define Y_GAIN_LABEL_START_X	X_GAIN_LABEL_START_X +\
								GAIN_LABEL_WIDTH +\
								INSIDE_BORDER

/* start Y pos. XY gain sections */
#define GAIN_LABEL_START_Y	INSIDE_BORDER +			\
							GENERAL_LABEL_HEIGHT + 	\
							INSIDE_BORDER

/* start Y for scroll bars*/
#define GAIN_SBAR_START_Y	XY_GAIN_START_Y + 		\
							GENERAL_LABEL_HEIGHT +	\
							INSIDE_BORDER

/* start X for draw area */
#define DRAW_AREA_START_X	XY_GAIN_START_X +		\
							XY_GAIN_WIDTH +			\
							OUTSIDE_BORDER


/* start Y for draw area */
#define DRAW_AREA_START_Y	ISI_LABEL_START_Y +		\
							ISI_LABEL_HEIGHT +		\
							OUTSIDE_BORDER

#define DRAW_AREA_WIDTH		MAX_XWINDOW_X	/* file: laser.h */
#define DRAW_AREA_HEIGHT	MAX_XWINDOW_Y	/* file: laser.h */
							
/* entire draw rate width */
#define	DRAW_RATE_WIDTH		INSIDE_BORDER +	  		\
							DRAW_RATE_LABEL_WIDTH +	\
							INSIDE_BORDER +			\
							2 * PIX

/* entire draw rate height*/
#define DRAW_RATE_HEIGHT	INSIDE_BORDER +	\
							GENERAL_LABEL_HEIGHT + 	\
							DRAW_RATE_SBAR_LENGTH +	\
							INSIDE_BORDER +			\
							4 * PIX

#define DRAW_RATE_START_X	DRAW_AREA_START_X + 	\
							DRAW_AREA_WIDTH +  		\
							OUTSIDE_BORDER

#define DRAW_RATE_LABEL_START_X	INSIDE_BORDER
#define DRAW_RATE_LABEL_START_Y	INSIDE_BORDER

#define DRAW_RATE_SBAR_START_X	DRAW_RATE_LABEL_START_X
#define DRAW_RATE_SBAR_START_Y	DRAW_RATE_LABEL_START_Y + \
								GENERAL_LABEL_HEIGHT +\
								INSIDE_BORDER

/* start Y for draw rate */
#define DRAW_RATE_START_Y	XY_GAIN_START_Y 	

/* start X pos. for quit button */
#define QUIT_START_X	XY_GAIN_START_X		

/* start Y pos. for quit button */
#define QUIT_START_Y	XY_GAIN_START_Y +	\
						XY_GAIN_HEIGHT +	\
						OUTSIDE_BORDER

/* start X pos. for help button */
#define HELP_START_X	XY_GAIN_START_X		

/* start Y pos. for help button */

#define HELP_START_Y	QUIT_START_Y +		  	\
						GENERAL_LABEL_HEIGHT +  \
						INSIDE_BORDER 

#define BUTTON_BOX_START_X	DRAW_RATE_START_X +	\
							DRAW_RATE_WIDTH +	\
							INSIDE_BORDER +		\
							OUTSIDE_BORDER 

#define BUTTON_BOX_START_Y	DRAW_AREA_START_Y 

#define BUTTON_BOX_WIDTH	GENERAL_BUTTON_WIDTH * 2 + \
							2 * INSIDE_BORDER +\
							2 * PIX


#define FRAME_HEIGHT	OUTSIDE_BORDER +  	\
						ISI_LABEL_HEIGHT +  \
						INSIDE_BORDER +  	\
						DRAW_RATE_HEIGHT + 	\
						OUTSIDE_BORDER

/* width of entire frame */
#define FRAME_WIDTH 	OUTSIDE_BORDER +	\
						XY_GAIN_WIDTH +  	\
						INSIDE_BORDER +  	\
						DRAW_AREA_WIDTH +  	\
						INSIDE_BORDER +  	\
						DRAW_RATE_WIDTH +  	\
						INSIDE_BORDER +  	\
						OUTSIDE_BORDER+		\
						BUTTON_BOX_WIDTH +	\
						OUTSIDE_BORDER +	\
						5 * PIX

/* width of isi label */
#define ISI_LABEL_WIDTH		FRAME_WIDTH
						
/* in case we want diff font*/
#define ISI_LABEL_HEIGHT	GENERAL_LABEL_HEIGHT  + 5

