/***********************************************************************
 * laserglobals.h -- misc globals for laser light show widgets
 * 
 * Ron Wilder -- Integrated Solutions Inc.
 * 1 Sep 1989 -- Date of Birth
 *
 * $Header: laserglobals.h,v 1.6 89/09/09 17:23:19 laser Locked $
 ***********************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "laser.h"


/* external functions */

extern void test(); /* temporary local test program */

/*extern void redisplay(); */
extern void start_image_capture();
extern void draw_next_segment();
extern void send_image();
extern void draw_rate_Scrolled();
extern void draw_rate_Thumbed();
extern void X_gain_Scrolled();
extern void X_gain_Thumbed();
extern void Y_gain_Scrolled();
extern void Y_gain_Thumbed();
extern void clear_image();
extern void lissajous();
extern void canned_image();
extern void full_scale();
extern void laser_on();
extern void laser_off();
extern void invert_X();
extern void invert_Y();
extern void help_key();
extern void quit_key();
extern void quit_but_handler();
extern void XY_gain_gang();
extern void XY_gain_separate();
extern void save_image();
extern void get_image();
extern void connect_dots();
extern void set_point_plot();

/* GENERAL GLOBALS */

boolean					user_interface_test = FALSE; /* test X only-- no laser*/
boolean					helpflag = FALSE;	/* global flag for help mode */
boolean					XY_ganged = FALSE;	/* global flag for XY gang mode */
boolean					laser_on_flg = FALSE;/* global flag for laser on */
boolean					points_only = FALSE; /* global flag: point/line draw*/

int 					serverSock; 		/* server socket descriptor */
int last_image_length = 0;					/* to prevent mult. image sends */
float 					current_draw_rate = 0.25; /* holds laser draw rate */
float					current_X_gain = 1;	/* holds X gain factor (0 to 1) */
float					current_Y_gain = 1;	/* holds Y gain factor (0 to 1) */
line_segment_data 		data;				/* line draw structure */

char message[] = "                                                                                ";
int leftMargin;

char	*correct_password[] = "isi";
XGCValues 				values; /* used to set up GC for line draw */

/* next add laser image directory name */
char 	*fname[] = "./LASER_IMAGES/yyy"; 
/*char 	*fname[] = "yyy"; */
FILE	*f1, *open();

/* message buffer */
char	*msgbuf[80];		/* used for temp message printing */

char	*pword[80];
boolean	pass_flag = FALSE;

ENET_CMD_PACKET     cmdbuf;				/*command buffer*/
ENET_IMAGE_PACKET   imagebuf;	 		/*laser image packet */
ENET_IMAGE_PACKET   imageoutbuf; 		/*laser image xlated output packet */


						/***********************/
						/* *** W I D G E T S ***/
						/***********************/
/************************************************************************/
/* general heirarchy is shown here for better understanding. It can get */
/* pretty confusing without a picture!  (tab = 4 chars) (set ts=4 in vi)*/
/************************************************************************/
Widget 	toplevel, 							/* at XtInitialize time */
			frame,							/* composite widget */ 
				isilabel,					/* plain old label widget */ 
				button_box,					/* composite widget */
				draw,						/* instantiated core widget */ 
				help,						/* command widget */ 
				quit,
				XY_gain_comp,				/* composite widget */
					XY_gain_label,			/* label widget */
					X_gain_label, 			/* label widget */
					X_gain_scroll,			/* scrollbar widget */
					Y_gain_label, 			/* label widget */
					Y_gain_scroll,			/* scrollbar widget */
				draw_rate,					/* composite widget */ 
					draw_rate_label,		/* label widget */ 
					draw_rate_scroll,		/* scrollbar widget */
				msg_label,					/* message area label widget */
				msg_area,					/* message area widget (text) */
		popup,								/* shell level popup widget */
			pop_but;						/* popup button */

Widget build_popup();

/* Command line options table.  Only resources are entered here...there is a
   pass over the remaining options after XtParseCommand is let loose. */

XrmOptionDescRec options[] = {
	{"-label",	"label",		 XrmoptionSepArg, NULL},
};
int Num_options = XtNumber(options);

/**********************/ 
/* callback arguments */
/**********************/ 
/*
 * These arrays are used when an event happens to determine what routine
 * gets called.  This is also the place where the parameters are passed.
 */
XtCallbackRec draw_rate_scrollCallbacks[] = {
      { draw_rate_Scrolled, NULL },
      { NULL, NULL },
};

XtCallbackRec draw_rate_thumbCallbacks[] = {
      { draw_rate_Thumbed, NULL },
      { NULL, NULL },
};

XtCallbackRec X_gainscrollCallbacks[] = {
      { X_gain_Scrolled, NULL },
      { NULL, NULL },
};

XtCallbackRec X_gainthumbCallbacks[] = {
      { X_gain_Thumbed, NULL },
      { NULL, NULL },
};

XtCallbackRec Y_gainscrollCallbacks[] = {
      { Y_gain_Scrolled, NULL },
      { NULL, NULL },
};

XtCallbackRec Y_gainthumbCallbacks[] = {
      { Y_gain_Thumbed, NULL },
      { NULL, NULL },
};

XtCallbackRec helpCallbacks[] = {
      { help_key, NULL },
      { NULL, NULL },
};

XtCallbackRec quitCallbacks[] = {
      { quit_key, NULL },
      { NULL, NULL },
};

/* widget arguments */

/***********************************************/
/* Top level frame arguments                   */
/***********************************************/
Arg frameargs[] = {
	{ XtNwidth,			(XtArgVal)FRAME_WIDTH},
	{ XtNheight,		(XtArgVal)FRAME_HEIGHT},
	{ XtNx,				(XtArgVal)0},
	{ XtNy,				(XtArgVal)0}, 
};
int Num_frameargs = XtNumber(frameargs);

/***********************************************/
/* ISI Label arguments                         */
/***********************************************/
Arg isilabelargs[] = {
	{ XtNlabel,		(XtArgVal)"Integrated Solutions Inc. Laser Light Demo -- Version 1.0"},
	{ XtNjustify,		(XtArgVal)XtJustifyCenter},
	{ XtNx,				(XtArgVal)ISI_LABEL_START_X},
	{ XtNy,				(XtArgVal)ISI_LABEL_START_X}, 
	{ XtNwidth,			(XtArgVal)ISI_LABEL_WIDTH},
	{ XtNheight,		(XtArgVal)ISI_LABEL_HEIGHT},
};
int Num_isilabelargs = XtNumber(isilabelargs);

/***********************************************/
/* Draw area arguments                         */
/***********************************************/
Arg drawargs[] = {
	{ XtNx,				(XtArgVal)DRAW_AREA_START_X},
	{ XtNy,				(XtArgVal)DRAW_AREA_START_Y},
	{ XtNwidth,			(XtArgVal)DRAW_AREA_WIDTH},
	{ XtNheight,		(XtArgVal)DRAW_AREA_HEIGHT},
/*	{ XtNcallback,		{XtArgVal)redisplayCallbacks}, */
};
int Num_drawargs = XtNumber(drawargs);

/***********************************************/
/* HELP button arguments                       */
/***********************************************/
Arg helpargs[] = {
	{ XtNlabel,			(XtArgVal)"HELP"},
	{ XtNcallback,		(XtArgVal)helpCallbacks},
	{ XtNjustify,		(XtArgVal)XtJustifyCenter},
	{ XtNx,				(XtArgVal)HELP_START_X},
	{ XtNy,				(XtArgVal)HELP_START_Y},
	{ XtNwidth,			(XtArgVal)GENERAL_BUTTON_WIDTH},
	{ XtNheight,		(XtArgVal)GENERAL_LABEL_HEIGHT},
};
int Num_helpargs = XtNumber(helpargs);

/***********************************************/
/* QUIT button arguments                       */
/***********************************************/
Arg quitargs[] = {
	{ XtNlabel,			(XtArgVal)"QUIT"},
	{ XtNcallback,		(XtArgVal)quitCallbacks},
	{ XtNjustify,		(XtArgVal)XtJustifyCenter},
	{ XtNx,				(XtArgVal)QUIT_START_X},
	{ XtNy,				(XtArgVal)QUIT_START_Y},
	{ XtNwidth,			(XtArgVal)GENERAL_BUTTON_WIDTH},
	{ XtNheight,		(XtArgVal)GENERAL_LABEL_HEIGHT},
};
int Num_quitargs = XtNumber(quitargs);

/****************************************************************/
/* X_Y gain composite: (2) labels, (2) scrollbars and a command */
/****************************************************************/

/* X_Y gain composite */
Arg XY_gainargs[] = {
	{ XtNx,				(XtArgVal)XY_GAIN_START_X},
	{ XtNy,				(XtArgVal)XY_GAIN_START_Y}, 
	{ XtNwidth,			(XtArgVal)XY_GAIN_WIDTH},
	{ XtNheight,		(XtArgVal)XY_GAIN_HEIGHT},
};
int Num_XY_gainargs = XtNumber(XY_gainargs);


/* X_Y gain label */

Arg XY_gain_labelargs[] = {
	{ XtNlabel,			(XtArgVal)"GAIN CONTROLS"},
	{ XtNjustify,		(XtArgVal)XtJustifyCenter},
	{ XtNx,				(XtArgVal)XY_GAIN_LABEL_START_X},
	{ XtNy,				(XtArgVal)XY_GAIN_LABEL_START_Y},
	{ XtNwidth,			(XtArgVal)XY_GAIN_LABEL_WIDTH},
	{ XtNheight,		(XtArgVal)GENERAL_LABEL_HEIGHT},
};
int Num_XY_gain_labelargs = XtNumber(XY_gain_labelargs);

/* X gain label */
Arg X_gain_labelargs[] = {
	{ XtNlabel,			(XtArgVal)"X AXIS"},
	{ XtNjustify,		(XtArgVal)XtJustifyCenter},
	{ XtNx,				(XtArgVal)X_GAIN_LABEL_START_X},
	{ XtNy,				(XtArgVal)GAIN_LABEL_START_Y}, 
	{ XtNwidth,			(XtArgVal)GAIN_LABEL_WIDTH},
	{ XtNheight,		(XtArgVal)GENERAL_LABEL_HEIGHT},
};
int Num_X_gain_labelargs = XtNumber(X_gain_labelargs);

/* X gain scrollbar */
Arg X_gain_scrollargs[] = {
	{ XtNscrollProc,	(XtArgVal)X_gainscrollCallbacks },
	{ XtNthumbProc,		(XtArgVal)X_gainthumbCallbacks },
	{ XtNorientation,	(XtArgVal)XtorientVertical}, 
	{ XtNx,				(XtArgVal)X_GAIN_START_X}, 
	{ XtNy,				(XtArgVal)GAIN_SBAR_START_Y}, 
	{ XtNthickness,		(XtArgVal)GAIN_LABEL_WIDTH},
	{ XtNlength,		(XtArgVal)GAIN_SBAR_LENGTH},
};
int Num_X_gain_scrollargs = XtNumber(X_gain_scrollargs);


/* Y gain label */
Arg Y_gain_labelargs[] = {
	{ XtNlabel,			(XtArgVal)"Y AXIS"},
	{ XtNjustify,		(XtArgVal)XtJustifyCenter},
	{ XtNx,				(XtArgVal)Y_GAIN_LABEL_START_X},
	{ XtNy,				(XtArgVal)GAIN_LABEL_START_Y}, 
	{ XtNwidth,			(XtArgVal)GAIN_LABEL_WIDTH},
	{ XtNheight,		(XtArgVal)GENERAL_LABEL_HEIGHT},
};
int Num_Y_gain_labelargs = XtNumber(Y_gain_labelargs);

/* Y gain scrollbar */
Arg Y_gain_scrollargs[] = {
	{ XtNscrollProc,	(XtArgVal)Y_gainscrollCallbacks },
	{ XtNthumbProc,		(XtArgVal)Y_gainthumbCallbacks },
	{ XtNorientation,	(XtArgVal)XtorientVertical}, 
	{ XtNx,				(XtArgVal)Y_GAIN_START_X}, 
	{ XtNy,				(XtArgVal)GAIN_SBAR_START_Y}, 
	{ XtNthickness,		(XtArgVal)GAIN_LABEL_WIDTH},
	{ XtNlength,		(XtArgVal)GAIN_SBAR_LENGTH},
};
int Num_Y_gain_scrollargs = XtNumber(Y_gain_scrollargs);


/***********************************************/
/* Draw rate composite: label and scrollbar    */
/***********************************************/
Arg draw_rateargs[] = {
	{ XtNx,				(XtArgVal)DRAW_RATE_START_X},
	{ XtNy,				(XtArgVal)DRAW_RATE_START_Y}, 
	{ XtNwidth,			(XtArgVal)DRAW_RATE_WIDTH},
	{ XtNheight,		(XtArgVal)DRAW_RATE_HEIGHT},
};
int Num_draw_rateargs = XtNumber(draw_rateargs);

Arg draw_rate_labelargs[] = {
	{ XtNlabel,			(XtArgVal)"Draw Rate"},
	{ XtNjustify,		(XtArgVal)XtJustifyCenter},
	{ XtNx,				(XtArgVal)DRAW_RATE_LABEL_START_X},
	{ XtNy,				(XtArgVal)DRAW_RATE_LABEL_START_Y}, 
	{ XtNwidth,			(XtArgVal)DRAW_RATE_LABEL_WIDTH},
	{ XtNheight,		(XtArgVal)GENERAL_LABEL_HEIGHT},
};
int Num_draw_rate_labelargs = XtNumber(draw_rate_labelargs);

Arg draw_rate_scrollargs[] = {
	{ XtNscrollProc,	(XtArgVal)draw_rate_scrollCallbacks },
	{ XtNthumbProc,		(XtArgVal)draw_rate_thumbCallbacks },
	{ XtNorientation,	(XtArgVal)XtorientVertical}, 
	{ XtNx,				(XtArgVal)DRAW_RATE_SBAR_START_X},
	{ XtNy,				(XtArgVal)DRAW_RATE_SBAR_START_Y}, 
	{ XtNthickness,		(XtArgVal)DRAW_RATE_LABEL_WIDTH},
	{ XtNlength,		(XtArgVal)DRAW_RATE_SBAR_LENGTH },
};
int Num_draw_rate_scrollargs = XtNumber(draw_rate_scrollargs);


BUTTON	button[] = {
/*   Button Label    		Callback routine    */
/*  ------------------------------------------- */
	{ "Laser ON",			laser_on}
	{ "Laser OFF",			laser_off} 
	{ "X/Y Gain Gang",		XY_gain_gang}
	{ "X/Y Gain Separate",	XY_gain_separate} 
	{ "Plot Points Only",	set_point_plot}
	{ "Connect the Dots",	connect_dots}
	{ "Invert X", 			invert_X}
	{ "Invert Y", 			invert_Y}
	{ "Full Scale",			full_scale}
/*	{ "ISI pattern",		canned_image}*/
	{ "Lissajous",			lissajous}
	{ "Clear",				clear_image}
	{ "Save Image To Disk",	save_image}
	{ "Get Image From Disk",get_image} 
	{ "HELP",				help_key}
	{ "QUIT",				quit_but_handler}
};
int	num_buttons = (sizeof(button) / sizeof(BUTTON));

/* for now just use an array of generic widgets */
Widget button_labels[(sizeof(button) / sizeof(BUTTON))];

