/***********************************************************************
 * laser.h	-- misc includes for laser light show Xtoolkit routines
 *             communications structures, commands, etc.
 *
 * Ron Wilder -- Integrated Solutions
 * 8 Aug 1989 -- date of birth
 *
 * $Header: laser.h,v 1.4 89/09/07 11:08:42 laser Locked $
 *
 ***********************************************************************/

#include "/vx/h/types.h

/***************************************************************************/
/**************** U S E R    M O D I F I A B L E   A R E A *****************/
/***************************************************************************/
/* the following values would be most likely changed */
#define	HOSTNAME "porsche"		/* default name of laser host */
#define	SERVER_NUM	1506		/* port number for socket communication */
#define MAX_IMAGE_DOTS	1000	/* Max num of points in image sent from host.
								 * Increasing MAX_IMAGE_DOTS will slow scan
								 * rate down and increase flicker. */
								/* Beware that enet send has a bug over
								 * 4096 bytes and that an image is 
								 * header (8) + (4 * MAX_IMAGE_DOTS)
								 * or about 4008 dots ... so you can't go
								 * too much further without breaking up
								 * the packet into smaller chunks */
#define MAX_XWINDOW_X 500		/* Max horizontal pixels in window */
#define MAX_XWINDOW_Y 500		/* Max vertical pixels in window */
#define MAX_DRAW_RATE 8000		/* Maximum dots per second */

/***************************************************************************/
/************* U S E R    U N - M O D I F I A B L E   A R E A **************/
/***************************************************************************/
#define XPOS 	0				/* hard coded array index for X value */
#define YPOS 	1				/* hard coded array index for Y value */
#define SEC		60				/* ticks of clock for two seconds 68225 */

/* XWindow Constants */
#define MIN_XWINDOW_X 0		/* Minimum window X position */
#define MIN_XWINDOW_Y 0		/* Minimum window Y position */

/* XWindow Center of image (X axis) */
#define CENTER_OF_XWINDOW_X (MAX_XWINDOW_X - MIN_XWINDOW_X)/2
/* XWindow Center of image (Y axis) */
#define CENTER_OF_XWINDOW_Y (MAX_XWINDOW_Y - MIN_XWINDOW_Y)/2

#define MIN_DRAW_RATE 30		/* Minimum dots per second (CPU DEPENDENT!)*/
#define DEFAULT_DRAW_RATE 2000	/* Default draw rate */

/* max value to send from host to target for full gain */
#define MAX_GAIN 100			/* Maximum gain (ie. 100 = gain of 1)

/* some angular floating point stuff */
#define PI 3.14159265			/* approx value of PI */
#define DEG_PER_RAD 180/PI		/* approx value of degrees per radian */
#define RAD_PER_DEG PI/180		/* approx value of radians per degree */

/* Angular resolution for rotation increment */
#define DELTA_THETA_RAD DELTA_THETA_DEG * RAD_PER_DEG /* value in radians */
#define DELTA_THETA_DEG  10	/* degrees moved for newly rotated image */	

/* Conversion commands */
/*#define STRAIGHT 0	*/			/* Straight conversion */
/*#define INVERT_X 1	*/			/* Invert X coordinate */
/*#define INVERT_Y 2	*/			/* Invert Y coordinate */
/*#define INVERT_XY 3	*/			/* Invert X & Y coordinates */
/*#define SCALE_X 4	*/			/* Scale X coordinate */
/*#define SCALE_Y 5	*/			/* Scale Y coordinate */
/*#define ROTATE_XY 6	*/			/* Rotate about X/Y center */

/* ACK/NACK with laser host values */
#define CMD_ACK		0			/* value for receipt of good command*/
#define CMD_NACK	1			/* value for receipt of bad command*/
#define IMAGE_ACK	2			/* value for receipt of good image*/
#define IMAGE_NACK	3			/* value for receipt of bad image*/

/***************************************************************************/
/*****************  L A S E R    H O S T    C O M M A N D S  ***************/
/***************************************************************************/
/* ethernet commands from laser host to laser server */
/* the following commands do not require secondary command word values */
#define LASER_OFF 0				/* turn off laser beam */
#define LASER_ON 1				/* turn on laser beam */
#define IM_ALIVE 2				/* message sent every so often (watchdog) */
#define INVERT_IMAGE_X 3		/* invert current image in X direction */
#define INVERT_IMAGE_Y 4		/* invert current image in Y direction */
#define INVERT_IMAGE_XY 5		/* invert current image in both X&Y directions*/
#define GO_FULL_SCALE 6			/* display image in full scale */

/* the following primary commands require secondary command words*/

#define NEW_DRAW_RATE 9			/* change draw rate
								 * NEW_DRAW_RATE command requires the 
								 * secondary command word to contain the 
								 * new draw rate: (factor to be determined...)
								 * subcmd1 = new draw rate*/

#define SCALE_IMAGE 10	 		/* change scale factor of current image 
								 * SCALE_IMAGE command requires the secondary 
								 * command word to contain the scale factor 
								 * which is a factor of MAX_GAIN
								 * ie. if subcmd1 = 75 and MAX_GAIN = 100
								 * then gain factor is .75 or 75%
								 *  subcmd1 = X scale factor     
								 *  subcmd2 = Y scale factor */

#define ROTATE_IMAGE 11			/* rotate current image 
								 * ROTATE_IMAGE command requires the secondary 
								 * command word subcmd1 to indicate the rate 
								 * of angular change (from 0 to 360 degrees)
								 * and the direction with a sign (positive is
								 * counter-clockwise; negative is clockwise) */

#define LISSAJOUS_PATTERN 12	/* display a calculated lissajous pattern 
								 * LISSAJOUS_PATTERN requires the secondary 
								 * command words to be the ratio of X to Y 
								 * sine waves as follows:
								 * subcmd1=1; subcmd2=1 : one to one (X=1,Y=1)
								 * subcmd1=2; subcmd2=3 : two to three (X=2,Y=3)
								 * subcmd1=3; subcmd2=1 : three to one, etc. */

#define SPIRAL_PATTERN 13		/* display a calculated spiral pattern 
								 * SPIRAL_PATTERN requires the seconary command
								 * word subcmd1 to indicate the number of loops
								 * to get to the center, and the direction of 
								 * the spiral. (positive: counter-clockwise;
								 * negative: clockwise); */

#define DBL_SPIRAL_PATTERN 14	/* display a calculated double spiral pattern 
								 * DOUBLE_SPIRAL_PATTERN requires the secondary
								 * word subcmd1 to indicate the number of loops
								 * to get to the center. (no direction sign) */

#define CANNED_IMAGE 15			/* display a canned image 
								 * CANNED_IMAGE requires that the secondary
								 * command word subcmd1 indicate the canned 
								 * image number.  (If image selected is illegal,
								 * then image 0 will be displayed) */

#define SKIP_DOTS 16			/* skip dots when displaying image 
								 * SKIP_DOTS causes the display routine to 
								 * skip the number of dots specified in 
								 * the command word subcmd1. If subcmd1 is
								 * zero, then no dots will be skipped and the
								 * image will be complete. Essentially, this
								 * allows the user to select a new display
								 * resolution */

#define END_PROGRAM 99			/* Abort the laser light show program
								 * ABORT_PROGRAM requires two more parameters 
								 * to make sure that this is really the command
								 * desired.  Both parameters are decimal 99 
								 * for now. */

#define NEW_IMAGE 100			/* A new image is coming from the laser host. 
								 * The secondary command subcmd1 provides the
								 * length of the image packet (standard image
								 * structure + number of bytes in image being
								 * transfered).
								 * The second packet (the image structure) 
								 * should conform to the enet_image_packet 
								 * structure noting that image_length is the 
								 * number of dots in the image array. */

/**************************************************************************/
/************** S T R U C T U R E    D E F I N I T I O N S ****************/
/**************************************************************************/

typedef short boolean;			/* make it easier to see meaning of variable */

struct enet_cmd_packet {		/* command packet structure */
    short	command;			/* command from laser host */
    short	subcmd1;			/* secondary command number 1*/
    short	subcmd2;			/* secondary command number 2*/
};

typedef struct enet_cmd_packet ENET_CMD_PACKET;  /* new type for enet cmds */

struct enet_image_packet {		/* laser image structure */
    short	image_length;		/* # of points in image ( one point = X & Y)*/
    short	draw_rate;			/* laser motion rate */
    short	rotate_rate;		/* image rotation rate (+/-) */
    boolean	converted_format;	/* T: laser img fmt; F: XWindow fmt */
    short	full_scale_image[MAX_IMAGE_DOTS][2];	/* full size image */
};

typedef struct enet_image_packet ENET_IMAGE_PACKET; /*new type enet image pkts*/

/* don't forget to make sure that scale factors are float and not double */
struct laser_image {			/* laser image structure */
    short	image_length;		/* # of points in image */
    float	x_scale_factor;		/* DAC gain for X */
    float	y_scale_factor;		/* DAC gain for Y */
    short	draw_rate;			/* laser motion rate */
    short	rotate_rate;		/* image rotation rate */
    boolean	use_full_scale;		/* T: use full_scale_image; F: actual*/
	short	current_pos;		/* current position to display */
    short	full_scale_image[MAX_IMAGE_DOTS][2]; /* full size image */
    short	actual_image[MAX_IMAGE_DOTS][2];     /* scaled image */
};

typedef struct laser_image LASER_IMAGE;		/* new type for declarations */

/* network socket stuff */
#define ENET_CMD_PKT_SIZE	sizeof(ENET_CMD_PACKET) /* command from host */
#define	ENET_IMAGE_PKT_SIZE	sizeof(ENET_IMAGE_PACKET) /*new image frm host*/
#define LASER_IMAGE_SIZE	sizeof(LASER_IMAGE)		/* laser output struct */

