/***********************************************************************
 * dac.h	-- misc includes for laser light show Digital to Analog
 *             converter
 *
 * Ron Wilder  -- Integrated Solutions
 * 26 Aug 1989 -- date of birth
 *
 * $Header: dac.h,v 1.3 89/09/07 11:08:03 laser Locked $
 *
 ***********************************************************************/

#include "/vx/h/types.h"

/***************************************************************************/
/**************** U S E R    M O D I F I A B L E   A R E A *****************/
/***************************************************************************/
/* the following values would be most likely changed */
#define LASER_CPU_68225 1
/*#define LASER_CPU_E5 1*/

/* DAC window constants */
#define MAX_DAC 0xfff			/* Maximum value to send to DAC */
#define MIN_DAC 0				/* Minimum value to send to DAC */
#define DAC_ZERO ((MAX_DAC-MIN_DAC)/2 + 1) /* Zero volts on DAC */ 

/**************************************************************************/
/************** S T R U C T U R E    D E F I N I T I O N S ****************/
/**************************************************************************/

/* DAC board port structure */
/* structure for the VMIC 4100 board (16 channel) */

struct dacdevice_VMIC {
	u_short	dac_1;						/* port #1 */
	u_short	dac_2;						/* port #2 */
	u_short	dac_3;						/* port #3 */
	u_short	dac_4;						/* port #4 */
	u_short	dac_5;						/* port #5 */
	u_short	dac_6;						/* port #6 */
	u_short	dac_7;						/* port #7 */
	u_short	dac_8;						/* port #8 */
	u_short	dac_9;						/* port #9 */
	u_short	dac_10;						/* port #10 */
	u_short	dac_11;						/* port #11 */
	u_short	dac_12;						/* port #12 */
	u_short	dac_13;						/* port #13 */
	u_short	dac_14;						/* port #14 */
	u_short	dac_15;						/* port #15 */
	u_short	dac_16;						/* port #16 */
};
typedef struct dacdevice_VMIC VMIC_DAC_BOARD;

/* DAC board address */

#ifdef LASER_CPU_68225
	VMIC_DAC_BOARD *LASERDAC = (VMIC_DAC_BOARD *) 0x08000060;
#else
#ifdef LASER_CPU_E5
		VMIC_DAC_BOARD *LASERDAC = (VMIC_DAC_BOARD *) 0xefff0060;
#endif
#endif


/*
extern char	vme_short[];
u_short *dacbase_VMIC[] = {
                (u_short *)&vme_short[0x0060],
                0 };
struct dacdevice_VMIC *LASERDAC=0x0;
*LASERDAC = dacbase_VMIC[0];
*/

/* control register data values */
/* currently, values are for VMIC board -- change for another DAC board */
#define Straight_through	0xc100
#define Synched_transfer	0xc300

/* DAC port names */
#define L1X			(LASERDAC->dac_1)		/* Laser #1 X Channel */
#define L1Y 	  	(LASERDAC->dac_2)		/* Laser #1 Y Channel */
#define L1ON_OFF   	(LASERDAC->dac_3)		/* Laser #1 ON/OFF port */

/* beam control values */
#define BEAM_ON		0xfff
#define BEAM_OFF	0x7ff

