/*******************************************************************
 * widgetsetup.c -- Module that contains widget-related setup 
 *                  routines.
 * 
 * Ron Wilder -- Integrated Solutions Inc.
 * 1 Sep 1989 -- Date of Birth
 *
 *******************************************************************/ 

#include <X11/StringDefs.h>
#include <X11/Cardinals.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Scroll.h>
#include <X11/Command.h>
#include <X11/Core.h>
#include <X11/Box.h>
#include <X11/Form.h>
#include <X11/Composite.h>
#include <X11/cursorfont.h>
#include <stdio.h>
#include "laser.h"
#include "laserxt.h"		/* Xtoolkit specific laser show stuff */
#include "laser.bm"

/* external functions */

extern void start_image_capture();
extern void draw_next_segment();
extern void redisplay();

/* widget arguments */

extern Arg frameargs[];
extern int Num_frameargs;

extern Arg isilabelargs[];
extern int Num_isilabelargs;

extern Arg drawargs[];
extern int Num_drawargs;

extern Arg draw_rateargs[];
extern int Num_draw_rateargs;

extern Arg helpargs[];
extern int Num_helpargs;

extern Arg quitargs[];
extern int Num_quitargs;

extern Arg XY_gainargs[];
extern int Num_XY_gainargs;

extern Arg XY_gain_labelargs[];
extern int Num_XY_gain_labelargs;

extern Arg X_gain_labelargs[];
extern int Num_X_gain_labelargs;

extern Arg X_gain_scrollargs[];
extern int Num_X_gain_scrollargs;

extern Arg Y_gain_labelargs[];
extern int Num_Y_gain_labelargs;

extern Arg Y_gain_scrollargs[];
extern int Num_Y_gain_scrollargs;

extern Arg draw_rate_labelargs[];
extern int Num_draw_rate_labelargs;

extern Arg draw_rate_scrollargs[];
extern int Num_draw_rate_scrollargs;

extern BUTTON button[];
extern int num_buttons;

extern Widget button_labels[];

/* external GLOBALS */

extern int serverSock; 		/* server socket descriptor */

						/***********************/
						/* *** W I D G E T S ***/
						/***********************/
/************************************************************************/
/* general heirarchy is shown here for better understanding. It can get */
/* pretty confusing without a picture!  (tab = 4 chars) (set ts=4 in vi)*/
/************************************************************************/
extern 

Widget 	toplevel, 							/* at XtInitialize time */
			frame,							/* composite widget */ 
				isilabel,					/* plain old label widget */ 
				button_box,					/* box widget */
				draw,						/* instantiated core widget */ 
/****/			quit,						/* temporary quit button */
				help,						/* command widget */ 
				XY_gain_comp,				/* composite widget */
					XY_gain_label,			/* label widget */
					X_gain_label, 			/* label widget */
					X_gain_scroll,			/* scrollbar widget */
					Y_gain_label, 			/* label widget */
					Y_gain_scroll,			/* scrollbar widget */
				draw_rate,					/* composite widget */ 
					draw_rate_label,		/* label widget */ 
					draw_rate_scroll;		/* scrollbar widget */


extern line_segment_data data;
extern XGCValues	values;


/*******************************************************************
 *  create_all_windows()  -- creates all widgets and windows
 *  
 *  Ron Wilder -- Integrated Solutions
 *  1 Sep 1989 -- Date of Birth
 **********************************************************************/

void
create_all_windows()
{

	Arg	args[10];		/* place to hold arguments for XtSetArg */
	int	n;				/* loop index */
	static	XtCallbackRec	callbacks[2]; /* callbacks for menu buttons */
	
    frame = XtCreateManagedWidget("frame",compositeWidgetClass,
	    toplevel, (ArgList)frameargs, Num_frameargs);

	/* Create the ISI label using a label widget.  */
	isilabel = XtCreateManagedWidget("isilabel", labelWidgetClass, 
		frame, (ArgList)isilabelargs, Num_isilabelargs);
    
	/* Create the help button using a command widget.  */
	help = XtCreateManagedWidget("widget", commandWidgetClass, 
		frame, (ArgList)helpargs, Num_helpargs );

	/* Create the quit button using a command widget.  */
	quit = XtCreateManagedWidget("widget", commandWidgetClass, 
		frame, (ArgList)quitargs, Num_quitargs );

	/* Create the drawing area using an instantiated Core widget.  */
	draw = XtCreateManagedWidget("draw", widgetClass, frame, 
		(ArgList)drawargs, Num_drawargs );

	/* create a composite widget consisting of a label and scrollbar */
	draw_rate = XtCreateManagedWidget("draw_rate", compositeWidgetClass,
		frame, (ArgList)draw_rateargs, Num_draw_rateargs);

	draw_rate_label = XtCreateManagedWidget( "draw_rate_label", 
		labelWidgetClass, draw_rate, 
		(ArgList)draw_rate_labelargs, Num_draw_rate_labelargs);

	draw_rate_scroll = XtCreateManagedWidget( "draw_rate_scroll", 
		scrollbarWidgetClass, draw_rate, 
		(ArgList)draw_rate_scrollargs, Num_draw_rate_scrollargs);

	XY_gain_comp = XtCreateManagedWidget("XY_gain_comp",
		compositeWidgetClass, frame,
		(ArgList)XY_gainargs, Num_XY_gainargs);

	XY_gain_label = XtCreateManagedWidget("XY_gain", labelWidgetClass, 
		XY_gain_comp, (ArgList)XY_gain_labelargs, Num_XY_gain_labelargs );

	X_gain_label = XtCreateManagedWidget( "X_gain_label", labelWidgetClass,
		XY_gain_comp, (ArgList)X_gain_labelargs, Num_X_gain_labelargs);

	X_gain_scroll = XtCreateManagedWidget("X_gain_scroll",scrollbarWidgetClass,
		XY_gain_comp, (ArgList)X_gain_scrollargs, Num_X_gain_scrollargs);

	Y_gain_label = XtCreateManagedWidget( "Y_gain_label", labelWidgetClass,
		XY_gain_comp, (ArgList)Y_gain_labelargs, Num_Y_gain_labelargs);

	Y_gain_scroll = XtCreateManagedWidget("Y_gain_scroll",scrollbarWidgetClass,
		XY_gain_comp, (ArgList)Y_gain_scrollargs, Num_Y_gain_scrollargs);

	/* set up the menu button box for misc buttons */

	XtSetArg(args[0], XtNx,(XtArgVal)BUTTON_BOX_START_X);
	XtSetArg(args[1], XtNy,(XtArgVal)BUTTON_BOX_START_Y);
	XtSetArg(args[2], XtNwidth,(XtArgVal)BUTTON_BOX_WIDTH);
	XtSetArg(args[3], XtNheight,(XtArgVal)(((GENERAL_LABEL_HEIGHT  + 10) + 4) *
													num_buttons));
	
	button_box = XtCreateManagedWidget("button_box",compositeWidgetClass,
		frame, args, FOUR);

	/* now create all of the little buttons to go inside */
	for (n = 0 ; n < num_buttons; n++) {
		XtSetArg(args[0], XtNwidth, (XtArgVal)BUTTON_BOX_WIDTH - 
												(2 * INSIDE_BORDER));
		XtSetArg(args[1], XtNheight, (XtArgVal)GENERAL_LABEL_HEIGHT + 10 );
		XtSetArg(args[2], XtNjustify, (XtArgVal)XtJustifyCenter);
		XtSetArg(args[3], XtNlabel, (XtArgVal)button[n].label);
		XtSetArg(args[4], XtNx, (XtArgVal) INSIDE_BORDER );
		XtSetArg(args[5], XtNy, (XtArgVal)(INSIDE_BORDER + 
						((GENERAL_LABEL_HEIGHT + INSIDE_BORDER + 10) * n)));

		callbacks[0].callback = button[n].cmdfunc;

		XtSetArg(args[6], XtNcallback, callbacks);

		button_labels[n] = XtCreateManagedWidget(button[n].label,
					 commandWidgetClass, button_box, args, SEVEN);
	}

	/* ICON creation */
	XtSetArg(args[0], XtNiconPixmap,
			XCreateBitmapFromData (XtDisplay(toplevel),
			XtScreen(toplevel) -> root, laser_bits,
			laser_width, laser_height));
	XtSetArg(args[1], XtNallowShellResize, TRUE);
	XtSetValues (toplevel, args, TWO);
	

	/* make it all happen */
	XtRealizeWidget(toplevel); 

}
    
/* add event handlers for drawing window */

/********************************************************************
 *  add_all_event_handlers()  -- adds all event handlers for widgets
 *  
 *  Ron Wilder -- Integrated Solutions
 *  1 Sep 1989 -- Date of Birth
 **********************************************************************/

void
add_all_event_handlers()
{

	
	/* redraw the display whenever it is oncovered */
	XtAddEventHandler(draw, ExposureMask, Expose,
		redisplay, &data);

	XtAddEventHandler(draw, ButtonPressMask, FALSE,
		start_image_capture, &data);

	XtAddEventHandler(draw, Button3MotionMask, FALSE,
		draw_next_segment, &data);

	XGrabButton(XtDisplay(draw), AnyButton, AnyModifier,
				XtWindow(draw), TRUE,
				ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
				GrabModeAsync, GrabModeAsync,
				XtWindow(draw),
				XCreateFontCursor(XtDisplay(draw), XC_pencil));


	/* Set the line gc to draw a solid line. */
	/*
values.line_style = LineOnOffDash;
	values.function = GXclear;
	data.gc = XtGetGC(draw, GCForeground | GCBackground |
				GCFunction | GCLineStyle, &values);
*/
	/* draw a dashed line (large crosshair) for a center grid in draw window */
/*
	XDrawLine (XtDisplay(draw), XtWindow(draw),data.gc,
		CENTER_OF_XWINDOW_X, MIN_XWINDOW_Y,
		CENTER_OF_XWINDOW_X, MAX_XWINDOW_Y);

	XDrawLine (XtDisplay(draw), XtWindow(draw),data.gc,
		MIN_XWINDOW_X, CENTER_OF_XWINDOW_Y,
		MAX_XWINDOW_X, CENTER_OF_XWINDOW_Y);
*/
	/* Set the line gc to draw a solid line. */
/*	values.line_style = LineSolid;
	values.function = GXclear;
	data.gc = XtGetGC(draw, GCForeground | GCBackground |
				GCFunction | GCLineStyle, &values);
*/
}

