/*******************************************************************
 * lasermainx.c -- Top level program for laser light show demo
 * 
 * Ron Wilder -- Integrated Solutions Inc.
 * 1 Sep 1989 -- Date of Birth
 *
 * This module contains the main startup routine for the laser 
 * light show demonstration program.
 * Flow is as follows:
 *   - open socket connection with laser target system
 *   - open up windows for host side
 *   - set up callbacks and event handlers for windows
 *   - loop forever processing events
 *******************************************************************/ 

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Scroll.h>
#include <X11/Composite.h>
#include <X11/Command.h>
#include <X11/cursorfont.h>
#include <stdio.h>
#include "laserxt.h"			/* laser show misc xt related stuff */

#define ERROR		-1 			/* for laser draw app */

/* external functions */
extern int  connect_to_laser();		/* sets up connection to laser target */
extern void create_all_windows();	/* opens up all widgets and windows */
extern void add_all_event_handlers();	/* adds event handlers to widgets */

/* GLOBALS */
#include "laserglobals.h"	/* globals for event handlers and widgets */

void main(argc, argv)
    int argc;
    char *argv[];
{
	char	*s;

	system("clear");
	printf("*****************************************************\n"); 
	printf("************** W  E  L  C  O  M  E  *****************\n"); 
	printf("*****************************************************\n\n"); 
	printf("Real-time Laser Light Show Demo -- Version 1.0 \n");
	printf("Integrated Solutions Inc.\n\n"); 
	printf("For information about command line options, start the \n");
	printf("program with the command, \'laser -h\'\n\n");
	printf("If you have any suggestions, comments or questions,\n"); 
	printf("please contact Ron Wilder.   Enjoy!\n\n");
	
	user_interface_test = FALSE;

/*	if ((argc > 1)&& argv[1] user_interface_test = TRUE; */

	
	while (-- argc > 0 && (*++argv)[0] == '-')
		for (s = argv[0] + 1; *s != '\0'; s++)
			switch (*s) {
				case 'h': 					/* minimal usage help */
					printhelp();
					exit(0);

				case 'H':					/* lots more help */
					system("more laserhelp");
					exit(0);

				case 't':					/* test mode */
					user_interface_test = TRUE;
					break;
				
				case 'p':					/* bypass password check */
					checkpass(*++argv);		/* don't return on bad one */
					printf("Passing any other command line parameters to the\n");
					printf("X Windows client.\n\n");					
					break;

				default:					/* no command line params */
					/*
					printf("Please enter the startup password --> ");
					scanf("%s",pword);
					checkpass(pword);
					printf("\nPassing other command line parameter(s) to X Client.\n");
					*/
					break;
			}

	if ( (!user_interface_test) && (pass_flag == FALSE) 
		/*&& ( (argc == 1 && (*++argv)[0] != '-') || (argc != 1 ) )*/
	 ) {

		printf("Please enter the startup password --> ");
		scanf("%s",pword);
		checkpass(pword);
		printf("\nPassing other command line parameter(s) to X Client.\n");
	}
		
	printf("Let the show begin...\n\n");

	if (user_interface_test) {
		system("clear");
		printf("*******************************************************\n");
		printf("T E S T I N G    U S E R    I N T E R F A C E   O N L Y\n");
		printf("*******************************************************\n\n");
		printf("Real-time Laser Light Show Demo -- Version 1.0 \n");
		printf("Integrated Solutions Inc.\n\n"); 
		printf("YOU MUST BE RUNNING X WINDOWS FOR THIS PROGRAM TO RUN!\n");
	}

	/* set up connection to laser target */
	if(connect_to_laser(&serverSock) == ERROR) {
		printf("Exiting draw due to laser target problem.\n");
		exit(1);
	}

	/* Create the top level widget (initialize Xt) */
	toplevel = XtInitialize( NULL, "LaserShow", options, Num_options,
						&argc, argv);

	/* Open up the windows */
	create_all_windows(toplevel);

	/* add event handlers for drawing window */
	add_all_event_handlers();

	/* loop forever processing events */
	XtMainLoop();
}

printhelp()
{

printf("Command line syntax for the laser light show demo:\n\n");
printf("	laser [options][password]\n\n");

printf("OPTIONS\n\n");
	
printf("	-H		Displays more help from the file \'laserhelp\'\n");

printf("	-h		Displays some useful startup information. (this info)\n\n");

printf("	-p 		Causes the program to use the command line password.\n"); 
printf("			NOTE: This must be the first parameter to bypass the\n");
printf("			user interactive password check!\n\n");

printf("	-t		Puts the program into test mode which will not turn  \n");
printf("			on the laser beam.  This allows a user to use the \n");
printf("			X Windows user interface without having a laser attached.\n\n");

printf("	At least the following XWindows command line options are supported.\n");
printf("	-geom	Set the initial geometry up per X specification\n\n");
	
}

int
checkpass(password)
	char *password;

{
	/*if (strncmp(password,*correct_password,strlen(*correct_password)) == 0){*/
	if (strcmp(password,*correct_password) == 0){
			pass_flag = TRUE;
			return(0);
	}

	printf("Startup password is invalid. You must be trained to use this program\n");
	printf("correctly since there is a laser beam involved.\n\n");
	printf("If you wish to use the X Windows side only, start this program with\n");
	printf("\'laser -t\' which will not turn the laser beam on.\n\n");
	printf("Sorry for the inconvenience, but it is for your safety. (FDA regulations)\n");
	exit(1);
}
