static char *copyright = "Copyright 1989, Integrated Solutions, Inc.";
/**************************************************************************
 *
 * laserx - functions which handle the XWindows interface to the laser target
 *
 * Ron Wilder - Integrated Solutions Inc.
 * 26 Aug 89  - Date of birth
 */

/* $Header: laserx.c,v 1.2 89/09/06 23:47:34 laser Locked $ */


#include <stdio.h>
#include <errno.h>
#include <sys/time.h>

#include <sys/param.h>
#include <sys/socket.h>

#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>

#include "laser.h"		/* include laser demo header file */

#define	OK	0					/* 'good' return value */
#define ERROR	-1				/* 'bad' return value */
#define TRUE	1				/* 'true' value */
#define FALSE	! TRUE			/* 'false' value */

/**************************************************************************/
/*************************   G L O B A L S   ******************************/
/**************************************************************************/
extern boolean user_interface_test;		/* true if only X test; no laser conn*/
struct sockaddr_in serverAddr;			/* server's address */
struct sockaddr_in clientAddr;			/* client's address */
ENET_CMD_PACKET     cmdbuf;				/*command buffer*/
ENET_IMAGE_PACKET   imagebuf;	 		/*laser image packet */

int		serverSock;	/* socket fd */ 

int connect_to_laser();			/* routine to connect to laser socket */
int send_cmd_to_laser();			/* routine to send a command to laser */

/**************************************************************************/
/************************   F U N C T I O N S   ***************************/
/**************************************************************************/

/**************************************************************************
 * connect_to_laser - establishes the socket connection to the laser client
 *
 * uses connectSock internally to get client's address for serverSock
 * sets up serverSock to point to our socket to client (returns pointer)
 */

int connect_to_laser(pserverSock)
int	*pserverSock;			/* socket fd */ 

{
	int             client_len;	/* length of clientAddr */
	int connectSock;		/* used to connect, then discarded */

	/* Open the socket. Use ARPA Internet address format and stream
	 * sockets. Format described in "socket.h". */

	if (!user_interface_test) { /* only send command if not testing */

		if ((connectSock = socket(AF_INET, SOCK_STREAM, 0)) == ERROR) {
			return(ERROR);
		}
	}
	else printf("Simulated open socket to laser.\n");

	/* Zero out the sock_addr structures. */
	bzero(&serverAddr, sizeof(serverAddr));
	bzero(&clientAddr, sizeof(clientAddr));

	/* Set up our internet address, and bind it so the client can
	 * connect. */

	serverAddr.sin_family = AF_INET;
	serverAddr.sin_port = SERVER_NUM;

	if (!user_interface_test) { /* only send command if not testing */
		/*printf("\nBinding server socket # %d\n",serverAddr.sin_port);*/
		if (bind(connectSock, &serverAddr, sizeof(serverAddr)) == ERROR) {
			printf("\n************** E R R O R ! ! ! ****************\n");
			printf("Couldn\'t bind the server socket.\n");
			printf("You can either reboot this machine or recompile the\n");
			printf("program with a new socket number in laser.h.\n");
			printf("Another possibility is to wait 30 seconds & try again.\n\n");
			shutdown(connectSock,2);
			close(connectSock);
			return(ERROR);
		}

	/* Listen, for the client to connect to us. */
		printf("**********************************************************\n");
		printf("********** START THE LASER TARGET PROGRAM NOW ! **********\n");
		printf("**********************************************************\n");
		printf("\nThe command (on the vxWorks Plus target machine) is \'<l\'\n");
		printf("When the laser target synchronizes, this program will continue.\n\n");
		printf("\nWaiting for the laser target to connect...\n");
	
		if (listen(connectSock, 2) == ERROR) {
			printf("srvr: listen failed\n");
			shutdown(connectSock,2);
			close(connectSock);
			return(ERROR);
		}
	}
	else printf("Simulated target connection.\n");

	/* The client has connected.  Accept, and receive chars */
	client_len = sizeof(clientAddr);
	if (!user_interface_test) { /* only send command if not testing */
		*pserverSock = accept(connectSock, &clientAddr, &client_len);

		if (*pserverSock == ERROR) {
			printf("ERROR: There was a problem during the \'accept\' phase.\n");
			printf("       Closing sockets and aborting.\n");
			shutdown(connectSock,2);
			close(connectSock);
			shutdown(*pserverSock,2);
			close(*pserverSock);
			return(ERROR);
		}
	}
		else printf("Simulated accept of client.\n");

		printf("Laser host <--> target synchronization complete.\n");

	if (!user_interface_test) { /* only send command if not testing */
		shutdown(connectSock,2);
		close(connectSock);   /* don't need any more so free up descriptor */
	}
	else printf("Simulated close of connect socket leaving serverSock.\n");

	return(OK);		/* return with open server socket to client */

}


/***************************************************************************/
/*************************** send_cmd_to_laser *****************************/
/***************************************************************************/
int
send_cmd_to_laser() 		/* routine to send command to laser targe */
{
 
	int		n, nleft;					/* number of bytes in packet */
	ENET_IMAGE_PACKET	*pktptr;
	/* send command to laser */
	nleft = ENET_CMD_PKT_SIZE;
	if (!user_interface_test) { /* only send command if not testing */
		while (nleft > 0) { 		/* can only send so much data at a time */
			if ((n = send(serverSock, &cmdbuf, nleft, 0)) < 0) {
				/* need to recode for Xwindow printing to a text error window */
				/*
				printf("laser host: Couldn\'t send command to laser target.\n");
				printf("number of bytes sent in this packet: %d\n",n);
				*/
				return(ERROR);
			}
			nleft -=n;		/* next data packet */
		}
	}	
	else printf("Simulated command send to laser of %d bytes.\n",nleft);
	
	/* if we need to send a new image then do so now */
	if (cmdbuf.command == NEW_IMAGE) {
		/*
		printf("Formatting new image structure...\n");
		printf("Sending the image now...\n");
		*/	
		nleft = cmdbuf.subcmd1;	/* length of packet to send */
		/*printf("size of image buf: %d\n", nleft);*/
		pktptr = &imagebuf;
		if (!user_interface_test) { /* only send command if not testing */
			while (nleft > 0) { 	/* can only send so much data at a time */
				if ((n = send(serverSock, pktptr, nleft, 0)) < 0) {
					/* need error XWindow for following */
					/*
					printf("laser host: Couldn\'t send image to laser target.\n");
					printf("number of bytes sent: %d\n",n);
					*/
					return(ERROR);
				}
				pktptr +=n;
				nleft -= n;
				printf("# bytes sent in this packet should be: %d = %d\n",
						(pktptr - &imagebuf),n);
			}
		}
		else printf("Simulated send of image packet to laser of %d bytes.\n",nleft);
	}
		
	return(OK);
}

