/*******************************************************************
 * lasermainx.c -- Top level program for laser light show demo
 * 
 * Ron Wilder -- Integrated Solutions Inc.
 * 1 Sep 1989 -- Date of Birth
 *
 * This module contains the main startup routine for the laser 
 * light show demonstration program.
 * Flow is as follows:
 *   - open socket connection with laser target system
 *   - open up windows for host side
 *   - set up callbacks and event handlers for windows
 *   - loop forever processing events
 *******************************************************************/ 

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Scroll.h>
#include <X11/Composite.h>
#include <X11/Command.h>
#include <X11/cursorfont.h>
#include <stdio.h>
#include "laserxt.h"			/* laser show misc xt related stuff */

#define ERROR		-1 			/* for laser draw app */

/* external functions */
extern int  connect_to_laser();		/* sets up connection to laser target */
extern void create_all_windows();	/* opens up all widgets and windows */
extern void add_all_event_handlers();	/* adds event handlers to widgets */

/* GLOBALS */
#include "laserglobals.h"	/* globals for event handlers and widgets */

void main(argc, argv)
    unsigned int argc;
    char **argv;
{

	/* following flag is used to abort any signals over the ether net */
	if (argc > 1) user_interface_test = TRUE;
	else user_interface_test = FALSE;

	if (user_interface_test) {
		printf("*******************************************************\n");
		printf("T E S T I N G    U S E R    I N T E R F A C E   O N L Y\n");
		printf("There was a command line argument -- KLUDGE FOR NOW	   \n");
		printf("*******************************************************\n");
	}

	/* set up connection to laser target */
	if(connect_to_laser(&serverSock) == ERROR) {
		printf("Exiting draw due to laser target problem.\n");
		exit(1);
	}

	/* Create the top level widget (initialize Xt) */
	toplevel = XtInitialize( NULL, "LaserShow", options, Num_options,
						&argc, argv);

	/* Open up the windows */
	create_all_windows(toplevel);

	/* add event handlers for drawing window */
	add_all_event_handlers();

	/* loop forever processing events */
	XtMainLoop();
}

