#include "is-copyright.h"

/*
 *	Draw a spiral in an X window
 *
 *	Compile with:
 *	cc -O xspiral.c -o xspiral -lX
 */
#include <sys/types.h>
#include <X/Xlib.h>
#include <stdio.h>
#include <strings.h>

#define XMIN	0
#define YMIN	0
#include "sin.h"
#define SIN(x)	sin[(x)%360]
#define COS(x)  sin[((x)+90)%360]

Window w;
int background;	    		/* color of background */
int foreground;		    	/* color of graph */

struct pen{
    int	x, y;
    int	angle;
};

struct pen 	bic;
int	width, height;
int	size, angle;
int	delta = 2;
int	thickness = 1;

spiral(pen, maxsize, angle)
struct pen	*pen;
int	maxsize, angle;
{
    register i;
    for(i=1; i<maxsize; i+=delta){
	go(pen, i);
	turn(pen, angle);
    }
}

go(pen, distance)
struct pen	*pen;
int	distance;
{
    register	deltax, deltay;
    if(!distance) return;
    deltax = distance * COS(pen->angle);
    deltay = distance * SIN(pen->angle);
    if(distance < 0){
	pen->x += deltax;
	pen->y += deltay;
	XLine(w, pen->x, pen->y, pen->x-deltax, pen->y-deltay,
		thickness, thickness, foreground, GXcopy, AllPlanes);
    }else{
	XLine(w, pen->x, pen->y, pen->x+deltax, pen->y+deltay,
		thickness, thickness, foreground, GXcopy, AllPlanes);
	pen->x += deltax;
	pen->y += deltay;
    }
}

turn(pen, angle)
struct pen	*pen;
int	angle;
{
    pen->angle = (pen->angle + angle) % 360;
}

main(argc, argv) 
int argc;
char **argv;
{
    int	max_color;
    register char *option;
    char *border_color;
    char *back_color;
    int border_width = 2;
    int reverse = 0;
    char *geometry;			/* user supplied geometry spec */
    char def[32];			/* default size */
    char display[128];
    register int i;
    OpaqueFrame window;			/* frame for the window */
    Pixmap border_pixmap;
    Color cdef;
    long random();

    if ((option = XGetDefault(argv[0],"ReverseVideo")) != NULL)
	if (strcmp (option, "on") == 0)
	    reverse = 1;
    if ((option = XGetDefault(argv[0],"BorderWidth")) != NULL)
    	border_width = atoi(option);
    if ((border_color = XGetDefault(argv[0],"Border")) == NULL)
	border_color = XGetDefault(argv[0],"BorderColor");
    back_color = XGetDefault(argv[0],"Background");
    display[0] = '\0';

    for (i=1; i<argc; i++) {	  	                /* Parse line */
	if (argv[i][0] == '=') {			/* geometry */
	    geometry = argv[i];
	    continue;
	}
	if (index(argv[i], ':') != NULL) {		/* host:display */
	    (void)strncpy(display, argv[i], sizeof(display));
	    continue;
	}
	if (strcmp(argv[i], "-rv") == 0 ||
	    strcmp(argv[i], "-reverse") == 0) {		/* black on white */
	    reverse = 1;
	    continue;
	}
	if (strcmp(argv[i], "-fw") == 0 ||
	    strcmp(argv[i], "-forward") == 0) {		/* white on black */
	    reverse = 0;
	    continue;
	}
	if (strcmp(argv[i], "-bw") == 0) {		/* border width */
	    if (++i >= argc) usage(argv[0]);
	    border_width = atoi(argv[i]);
	    continue;
	}
	if (strcmp(argv[i], "-bd") == 0) {	       /* border color */
	   if (++i >= argc) usage(argv[0]);
	   border_color = argv[i];
	   continue;
	}
	if (strcmp(argv[i], "-bg") == 0) {		/* background color */
	   if (++i >= argc) usage(argv[0]);
	   back_color = argv[i];
	   continue;
	}
	if (argv[i][0] == '-') usage (argv[0]);
    }
    if (!XOpenDisplay(display)) {
       	fprintf (stderr, "%s: Could not open display %s!\n", argv[0], display);
	exit(1);
    }

    /* set up border pixmap */
    if (border_color && DisplayCells() > 2 &&
	XParseColor(border_color, &cdef) && XGetHardwareColor(&cdef))
	border_pixmap = XMakeTile(cdef.pixel);
    else if (border_color && strcmp(border_color, "black") == 0)
	border_pixmap = BlackPixmap;
    else
	border_pixmap = WhitePixmap;

    /* set up background color */
    if (back_color && DisplayCells() > 2 &&
	XParseColor(back_color, &cdef) && XGetHardwareColor(&cdef)) {
	background = cdef.pixel;
    } else if (back_color && strcmp(back_color, "white") == 0) {
	background = WhitePixel;
    } else
	background = BlackPixel;

    if (reverse && DisplayPlanes() == 1) {
	background = (background == BlackPixel ? WhitePixel : BlackPixel);
    }

    window.bdrwidth = border_width;
    window.border = border_pixmap;
    window.background = XMakeTile(background);

    width = 400;
    height = 400;
    (void) sprintf(def, "=%dx%d+100+100", width, height);
    w = XCreate("Spirals", argv[0], geometry, def, &window, width/4, height/4);

    if (!w) {
	fprintf(stderr, "XCreateWindow failed\n");
	exit(1);
    }
    XSelectInput(w, ExposeWindow | ButtonPressed);
    XMapWindow(w);
    if (DisplayPlanes() == 1)
	max_color = 2;
    else
	max_color = DisplayCells();
    foreground = max_color;
    srandom(time((time_t *)0));
    while (!XPending());	/* wait for first exposure event */
    while (1) {
	XEvent ev;
	if (XPending()) {
	    XNextEvent(&ev);
	    if (ev.type == ExposeWindow) {
		width = ((XExposeEvent *)&ev)->width;
		height = ((XExposeEvent *)&ev)->height;
		size = width < height ? width : height;
	    } else
		exit(0);
	} else {
	    XSync(0);
	    sleep(2);
	}
	XPixSet(w, 0, 0, width, height, background);
	angle = random() % 360;
	bic.angle = random() % 360;
	bic.x = width/2;
	bic.y = height/2;
	foreground = (foreground+1) % max_color;
	if (foreground == background)
	    foreground = (foreground+1) % max_color;
	spiral(&bic, size, angle);
    }
}

usage (program)
char *program;
{
    fprintf(stderr,
	"usage: %s [-help] [-fw] [-rv] [-bw borderwidth] [-bd bordercolor]\n	[-bg backgroundcolor] [=geom] [host:display]\n",
	program);
    exit(1);
}
