/*
 * xfish.c  -  serves no useful purpose whatsoever
 *
 *  Author:    John H. Bradley, University of Pennsylvania
 *                (bradley@cis.upenn.edu)
 *                     March, 1987
 */


#include <stdio.h>
#include <math.h>
#include <strings.h>
#include <signal.h>
#include <X/Xlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/timeb.h>


/* handy-dandy functions */
#define max(a, b) ((a) > (b) ? (a) : (b))
#define min(a, b) ((a) < (b) ? (a) : (b))
#define abs(a) ((a) < 0 ? -(a) : (a))


/* colors */
int ForeColor, BackColor;

/* objects */
Window   theWindow;
Bitmap   fishBMask,fishrBMask,stipB;
Pixmap   stipP;
Cursor   curs;


#define cross_width 16
#define cross_height 16
#define cross_x_hot 7
#define cross_y_hot 7
static short cross_bits[] = {      /* fish-zappin' cursor */
   0x0000, 0x03e0, 0x0c98, 0x1084,
   0x1414, 0x2082, 0x2082, 0x3b6e,
   0x2082, 0x2082, 0x1414, 0x1084,
   0x0c98, 0x03e0, 0x0000, 0x0000};

static short cross_mask_bits[] = {
   0x07e0, 0x0ff8, 0x1ffc, 0x3ffe,
   0x3ffe, 0x7fff, 0x7fff, 0x7fff,
   0x7fff, 0x7fff, 0x3ffe, 0x3ffe,
   0x1ffc, 0x0ff8, 0x03e0, 0x0000};


#define fish_width 32
#define fish_height 16
static short fish_bits[32] =       /* a left-going fish */
  {0xc000, 0x0007, 0xb000, 0x0006,
   0x7f80, 0xe003, 0x8260, 0xb003,
   0x0018, 0x680c, 0x0264, 0x37f0,
   0x0062, 0x2800, 0xaa01, 0x36aa,
   0x0046, 0x2800, 0x0338, 0x5fc0,
   0x28b0, 0xb030, 0x39c0, 0xe00e,
   0xee00, 0x0001, 0x5000, 0x0000,
   0xa000, 0x0000, 0xc000, 0x0000};


static short fish_mask_bits[32] = 
  {0xc000, 0x0007, 0xf000, 0x0007,
   0xff80, 0xe003, 0xffe0, 0xf003,
   0xfff8, 0x780f, 0xfffc, 0x3fff,
   0xfffe, 0x3fff, 0xffff, 0x3fff,
   0xfffe, 0x3fff, 0xfff8, 0x7fff,
   0xfff0, 0xf03f, 0xffc0, 0xe00f,
   0xfe00, 0x0001, 0x7000, 0x0000,
   0xe000, 0x0000, 0xc000, 0x0000};

static short fishr_bits[32] =        /* a right-going fish */
  {0xe000, 0x0003, 0x6000, 0x000d,
   0xc007, 0x01fe, 0xc00d, 0x0641,
   0x3012, 0x1800, 0x0fec, 0x2640,
   0x0014, 0x4600, 0xaaac, 0x804a,
   0x0014, 0x6200, 0x03fa, 0x1cc0,
   0x0c0d, 0x0d14, 0x7007, 0x039c,
   0x8000, 0x0077, 0x0000, 0x000a,
   0x0000, 0x0005, 0x0000, 0x0003};

static short fishr_mask_bits[32] = 
  {0xe000, 0x0003, 0xe000, 0x000f,
   0xc007, 0x01ff, 0xc00f, 0x07ff,
   0xf01e, 0x1fff, 0xfffc, 0x3fff,
   0xfffc, 0x7fff, 0xfffc, 0xffff,
   0xfffc, 0x7fff, 0xfffe, 0x1fff,
   0xfc0f, 0x0fff, 0xf007, 0x03ff,
   0x8000, 0x007f, 0x0000, 0x000e,
   0x0000, 0x0007, 0x0000, 0x0003};


#define MAXFISH 100
struct fishstr {  short x,y,dx,dy,fnum;  } fish[MAXFISH];

int NUMFISH=20, startnfish=20, shots=0;

/* checkerboard pattern (theoretically the same as the Root Window pattern) */
static short check_bits[] = {
   0xeeee, 0xdddd, 0x7777, 0xbbbb,
   0xeeee, 0xdddd, 0x7777, 0xbbbb,
   0xeeee, 0xdddd, 0x7777, 0xbbbb,
   0xeeee, 0xdddd, 0x7777, 0xbbbb};

long starttime;

/**************/
main(argc, argv)
    int   argc;
    char *argv[];
/**************/
{
    int i,dpcs,n;
    char *strind;

    char *fc, *bc;
    char *display = NULL;
    int rvflag    = 0;      /* don't use reverse video as a default */

    Color cdef;
    WindowInfo winfo;

    char *def;
    short bot,right;


    /*********************Defaults*********************/
    
    if ((def=XGetDefault(argv[0],"ReverseVideo"))!=NULL)
         if (strcmp(def,"on")==0) rvflag=1;

    fc  = XGetDefault(argv[0], "Foreground");
    bc  = XGetDefault(argv[0], "Background");


    /*********************Options*********************/

    for (i = 1; i < argc; i++) {

        strind = index(argv[i], ':');       /* is it display address? */
        if(strind != NULL) {
            display = argv[i];
            continue;
            }

        if (strcmp(argv [i], "-rv") == 0) {
            rvflag++;
            continue;
            }

        if (n=atoi(argv[i])) {
            if (n<1) n=1;
            if (n>100) n=100;
            NUMFISH=startnfish=n;
            continue;
            }

        Syntax(argv[0]);
    }


    /*****************************************************/

    /* Open up the display. */

    if (XOpenDisplay(display) == NULL) {
        fprintf(stderr, "%s: Can't open display '%s'\n",
                         argv[0], DisplayName());
        exit(1);
        }

    

    /* Set normal default colors */
    if (!rvflag) { ForeColor=BlackPixel;  BackColor=WhitePixel; }
            else { ForeColor=WhitePixel;  BackColor=BlackPixel; }


    /* Set up colors and pixmaps. */
    dpcs=DisplayCells();
    if (dpcs>2&&(fc !=NULL)&&XParseColor(fc ,&cdef)&&XGetHardwareColor(&cdef))
        ForeColor=cdef.pixel;

    if (dpcs>2&&(bc !=NULL)&&XParseColor(bc ,&cdef)&&XGetHardwareColor(&cdef))
        BackColor=cdef.pixel;


    /* Open the main window. */
    {
    int min_width, min_height;
    char default_geom[20];
    OpaqueFrame frame;
    
    min_width  = DisplayWidth();
    min_height = DisplayHeight();
    sprintf (default_geom, "%dx%d+0+0", min_width, min_height);

    stipB = XStoreBitmap(16,16,check_bits);
    stipP = XMakePixmap(stipB,ForeColor,BackColor);

    frame.bdrwidth   = 2;
    frame.border     = XMakeTile(ForeColor);
    frame.background = stipP;

    theWindow = XCreate("Fishies",argv[0],default_geom,default_geom,
                          &frame,min_width,min_height);

    if (!theWindow) XFishError("Can't open fish window");
    }

    XQueryWindow(theWindow,&winfo);
    bot=winfo.height;  right=winfo.width;
    
    XMapWindow    (theWindow);
    XLowerWindow  (theWindow);

    fishBMask =XStoreBitmap(fish_width,fish_height,fish_mask_bits);
    fishrBMask=XStoreBitmap(fish_width,fish_height,fishr_mask_bits);
    
    /* init fish */
    for (i=0; i<NUMFISH; i++) {
        fish[i].x=rand()%(right-100)+50;
        fish[i].y=rand()%(bot-100)+50;
        fish[i].dx = (abs(rand()%4)+3);
        if ((rand()%5)==0) fish[i].dx += 5;  /* hyper fish */

        /* switch direction based on a higher-order bit.  the low-order bit
           tended to be useless */
        if (rand()&0x10) fish[i].dx = -fish[i].dx;  

        fish[i].dy=rand()%7-3;  if (fish[i].dy==0) fish[i].dy=1;
        }

    XSelectInput(theWindow,ButtonPressed);
    curs = XCreateCursor(cross_width,cross_height,cross_bits,
                         cross_mask_bits, cross_x_hot, cross_y_hot,
                         ForeColor, BackColor, GXcopy);

    XDefineCursor(theWindow,curs);

    starttime=time(0);
    /**************** Main loop *****************/

    while (1) {
        XEvent event;
        short  x,y,bnum;

        if (XPending()) {
            XNextEvent(&event);
            if (event.type == ButtonPressed) {
                XButtonEvent *butevent = (XButtonEvent *) &event;

                bnum = butevent->detail & 0xff;
                if ((bnum == LeftButton) || (bnum == RightButton)) {

                    if (bnum == RightButton) shots++;

                    /* find out what fishy was hit */

                    x = butevent->x;  y = butevent->y;
                    for (i=0; i<NUMFISH; i++) {
                        if ( (x >= fish[i].x) &&
                             (x <= fish[i].x+fish_width) &&
                             (y >= fish[i].y) &&
                             (y <= fish[i].y+fish_height) ) break;
                        }

                    if (i!=NUMFISH) {  /* found one */
                        XFeep(0);
                        EraseFish(i);
                        if (bnum == LeftButton) {  /* bounce fish */
                            fish[i].dx = -fish[i].dx;
                            fish[i].dy = -fish[i].dy;
                            DrawFish(i);
                            }
                        else {                     /* destroy fish */
                            if (NUMFISH==1) Stats();
                            bcopy(&fish[NUMFISH-1],&fish[i],
                                  sizeof(struct fishstr));
                            NUMFISH--;
                            }
                        }
                    }
                }
           }

        /* move fish */
        for (i=0; i<NUMFISH; i++) {
            EraseFish(i);

            fish[i].x += fish[i].dx;
            fish[i].y += fish[i].dy;
            if (fish[i].x < -50 || fish[i].x > (right+50))
                fish[i].dx = -fish[i].dx;
            if (fish[i].y < 0 || fish[i].y > (bot-16))
                fish[i].dy = -fish[i].dy;

            DrawFish(i);
            }
        Timer(100000L);
    }  /* end main loop */
}

/*****************/
EraseFish(i)
      int i;
{
    if (fish[i].dx<0)
        XTileFill(theWindow,fish[i].x,fish[i].y,fish_width,fish_height,
                    stipP,fishBMask,GXcopy,AllPlanes);
    else
        XTileFill(theWindow,fish[i].x,fish[i].y,fish_width,fish_height,
                    stipP,fishrBMask,GXcopy,AllPlanes);
}

/*****************/
DrawFish(i)
     int i;
{
    if (fish[i].dx<0) 
        XBitmapBitsPut(theWindow,fish[i].x,fish[i].y,
            fish_width,fish_height,fish_bits,ForeColor,BackColor,
            fishBMask,GXcopy,AllPlanes);
    else
        XBitmapBitsPut(theWindow,fish[i].x,fish[i].y,
            fish_width,fish_height,fishr_bits,ForeColor,BackColor,
            fishrBMask,GXcopy,AllPlanes);
}


/***********************************/
Syntax(call)
 char *call;
{
    printf ("Usage: %s [-rv] [host:display] [number of fish] \n",call);
    exit(0);
}


/***********************************/
XFishError (identifier)
       char *identifier;
{
    fprintf(stderr, "xfish: %s\n", identifier);
    exit(1);
}



/*******/
Stats()
{
    long curtime;
    float acc;

    curtime=time(0);
    acc = (float) shots  / (float) startnfish;
    XFeep(0);  XFeep(0);  XFeep(0);  XFlush();
    printf("You used %d shots to hit %d fish.  (in %d seconds)\n",
            shots,startnfish,curtime-starttime);
    printf("  For an accuracy ratio of: %f\n", acc);

    if (acc < 1.5) printf("Nice shootin', Tex!\n");
    exit(0);
}



static int timerdone;

/*******/
onalarm()
/*******/
{
  timerdone=1;
}

/*******/
Timer(val)
 long val;
/*******/
{
    /* waits 'val' microseconds */

    struct itimerval it;

    bzero(&it, sizeof(it));
    it.it_value.tv_usec = val;
    timerdone=0;
    signal(SIGALRM,onalarm);
    setitimer(ITIMER_REAL, &it, (struct itimerval *)0);
    while (1) {
        sigblock(sigmask(SIGALRM)); /* note:  have to block, so that ALRM */
        if (timerdone) break;       /* doesn't occur between 'if (timerdone)'*/
        else sigpause(0);           /* and calling sigpause(0) */
        }
    sigblock(0);                    /* turn ALRM blocking off */
    signal(SIGALRM,SIG_DFL);
}

