#include "is-copyright.h"

/*	fill.c		Perform a simple raster operation a section of the
 *			screen
 *
 *	PixFill		Do a function on the screen
 *	StippleFill	Do a stippled function on the screen
 *
 *	Copyright (c) 1986, Integrated Solutions, Inc.
 */

#include "Xis.h"

PixFill(srcpix, xymask, dstx, dsty, width, height, clips, clipcount, func, zmask)
int		srcpix;
BITMAP		*xymask;
register int	dstx, dsty;
int		width, height;
register CLIP	*clips;
register int	clipcount;
int		func;
int		zmask;
{
    CLIP bounds, i;
    PIXMAP *fillpix;
    extern PIXMAP *MakePixmap();

#ifdef DEBUG
if (debug & D_PixFill)
    fprintf(stderr, "PixFill(srcpix=0x%x, xymask=0x%x, dstx=%d, dsty=%d,\n	width=%d, height=%d, clips=0x%x, clipcount=%d, func=%d, zmask=0x%04x)\n",
	srcpix, xymask, dstx, dsty, width, height, clips, clipcount,
	func, zmask);
if (debug & D_PixFill_data)
    printf_bitmap("xymask", xymask);
#endif DEBUG

    fillpix = MakePixmap((BITMAP *)NULL, srcpix, 0);

    bounds.top = dsty;
    bounds.left = dstx;
    bounds.width = width;
    bounds.height = height;

    for ( ; clipcount; clipcount--, ++clips) {
	if (Overlap(clips[0], bounds)) {
	    i = Intersection(clips[0], bounds);
	    CheckCursor(i);
	    GIP_RasterOp((unsigned char)func,
		fillpix, 0, 0,
		&ScreenPixmap, i.left, i.top,
		xymask, i.left - dstx, i.top - dsty,
		i.width, i.height,
		zmask);
	}

    }
    RestoreCursor();
    if (!--fillpix->refcnt)
	FreePixmap (fillpix);
}



extern int errno;
#include <errno.h>

int StippleFill (srcpix, xoff, yoff, stipmask, dstx, dsty, width, height, clips, clipcount, func, zmask)
int	srcpix;		/* source pixel */
int	xoff, yoff;	/* stipple origin */
BITMAP	*stipmask;	/* stipple mask */
int	dstx, dsty;	/* destination */
int	width, height;
CLIP	*clips;		/* clipping rectangles */
int	clipcount;
int	func;		/* GX display function */
int	zmask;		/* plane mask */
{
    static char funcmap[16][2] = {
	{GXandInverted,	GXandInverted},	/* GXclear */
	{GXandInverted, GXnoop},	/* GXand */
	{GXandInverted,	GXxor},		/* GXandReverse */
	{GXandInverted, GXor},		/* GXcopy */
	{GXnoop,	GXandInverted},	/* GXandInverted */
	{GXnoop,	GXnoop},	/* GXnoop */
	{GXnoop,	GXxor},		/* GXxor */
	{GXnoop,	GXor},		/* GXor */
	{GXxor,		GXandInverted},	/* GXnor */
	{GXxor,		GXnoop},	/* GXequiv */
	{GXxor,		GXxor},		/* GXinvert */
	{GXxor,		GXor},		/* GXorReverse */
	{GXor,		GXandInverted},	/* GXcopyInverted */
	{GXor,		GXnoop},	/* GXorInverted */
	{GXor,		GXxor},		/* GXnand */
	{GXor,		GXor}		/* GXset */
    };

    int		newfunc = funcmap[func][srcpix & 1];
    PIXMAP	*tile, *MakePixmap();

    if ((stipmask->width != 16) || (stipmask->height != 16)) {
	errno = EINVAL;
	return (0);
    }
    tile = MakePixmap(stipmask, 1, 0);
    TileFill(tile, xoff, yoff, (Bitmap *)0, dstx, dsty, width, height,
	    clips, clipcount, newfunc, zmask);
    FreePixmap(tile);
    return(1);
}
