/*
 *	$Source: /u1/Xr/src/Xrlib/Editor/RCS/polyUtil.c,v $
 *	$Header: polyUtil.c,v 1.1 86/12/17 09:07:07 swick Exp $
 */

#ifndef lint
static char *rcsid_polyUtil_c = "$Header: polyUtil.c,v 1.1 86/12/17 09:07:07 swick Exp $";
#endif	lint


#include <Xr/xr-copyright.h>

/* $Header: polyUtil.c,v 1.1 86/12/17 09:07:07 swick Exp $ */
/* Copyright 1986, Hewlett-Packard Company */
/* Copyright 1986, Massachussetts Institute of Technology */

static char rcsid[] = "$Header: polyUtil.c,v 1.1 86/12/17 09:07:07 swick Exp $";
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        polyUtil.c
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: 
 **         This file contains several routines which may be used by
 **         field editors, to draw arbitrary polygons.  As with all
 **         of the other field editor drawing routines, these also
 **         use a graphics context structure to obtain the drawing
 **         environment.
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	polyUtil.c,v $
 * Revision 1.1  86/12/17  09:07:07  swick
 * Initial revision
 * 
 * Revision 7.0  86/11/13  08:30:54  08:30:54  fred ()
 * Final QA Release
 * 
 * Revision 6.0  86/11/10  15:39:31  15:39:31  fred ()
 * QA #2 release
 * 
 * Revision 5.1  86/11/07  14:27:16  14:27:16  fred ()
 * Added new copyright message.
 * 
 * Revision 5.0  86/10/28  08:41:09  08:41:09  fred ()
 * QA #1.1 release
 * 
 * Revision 4.0  86/10/20  12:17:09  12:17:09  fred ()
 * QA #1 release
 * 
 * Revision 3.1  86/10/16  09:24:47  09:24:47  fred ()
 * Performance enhanced: added use of register variables.
 * 
 * Revision 3.0  86/10/02  16:06:58  16:06:58  fred ()
 * Alpha release set to 3.0
 * 
 * Revision 2.1  86/09/17  06:02:14  06:02:14  fred ()
 * Filled in the procedure headers.
 * 
 * Revision 2.0  86/09/16  08:17:20  08:17:20  fred ()
 * No change; upgraded to revision 2.0 to match other source.
 * 
 * Revision 1.1  86/09/03  14:00:45  14:00:45  fred ()
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/



#include <X/Xlib.h>
#include <Xr/defs.h>
#include <Xr/types.h>




/*************************************<->*************************************
 *
 *  _XrPoly (windowId, GC, count, pointList)
 *
 *     Window   windowId;
 *     INT32    GC;
 *     INT32    count;
 *     Vertex * pointList;
 *
 *   Description:
 *   -----------
 *     This routine will draw the outline of the polygon whose points
 *     are contained within the 'pointList' parameter; refer to the X
 *     documentation for a discussion of how this array of Vertex's
 *     should be organized.  The line width, pen color and replacement
 *     rule are all obtained from the specified graphics context.
 *
 *
 *   Inputs:
 *   ------
 *     windowId = Id for the window in which the polygon is to be drawn.
 *
 *     GC = The index of the graphics context which contains the drawing
 *          environment.  The fields of importance in the graphic context
 *          are:
 *
 *          XrLINEWIDTHVAL  = The width of the line used to draw the polygon.
 *          XrFOREGROUNDVAL = The pen color to use during drawing.
 *          XrALUVAL        = The replacement rule.
 *
 *     count = The number of vertex points in the 'pointList' array.
 *
 *     pointList = The list of vertex's making up the polygon.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XDraw()  [libX.a]
 *
 *************************************<->***********************************/

_XrPoly (windowId, GC, count, pointList)

            Window  windowId;
   register INT32   GC;
            INT32   count;
            INT8  * pointList;

{
   XDraw (windowId, (Vertex *) pointList, count,
          xr_GCList[GC][XrLINEWIDTHVAL], xr_GCList[GC][XrLINEWIDTHVAL],
          xr_GCList[GC][XrFOREGROUNDVAL], xr_GCList[GC][XrALUVAL], AllPlanes);
}

/*************************************<->*************************************
 *
 *  _XrFillPoly (windowId, GC, count, pointList)
 *
 *   Description:
 *   -----------
 *     This routine will draw the the polygon defined by the points 
 *     contained within the 'pointList' parameter, and will fill it
 *     either using a Solid or Tiled fill; refer to the X documentation
 *     for a discussion of how this array of Vertex's should be
 *     organized.  The fill style, tile id, pen color and replacement
 *     rule are all obtained from the specified graphics context.
 *
 *
 *   Inputs:
 *   ------
 *     windowId = The window Id for the window in which the polygon is
 *                to be drawn.
 *
 *     GC = The index of the graphics context which contains the drawing
 *          environment.  The fields of importance in the graphic context
 *          are:
 *
 *          XrFILLSTYLEVAL  = The type of filling to use: Solid or Tiled.
 *          XrFOREGROUNDVAL = The pen color, if doing a solid fill.
 *          XrTILEVAL       = Tile Id, if doing a tiled fill.
 *          XrALUVAL        = The replacement rule.
 *
 *     count = The number of vertex points in the 'pointList' array.
 *
 *     pointList = The list of vertex's making up the polygon.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XDrawFilled()  [libX.a]
 *   XDrawTiled()   [libX.a]
 *
 *************************************<->***********************************/

_XrFillPoly (windowId, GC, count, pointList)

   Window  windowId;
   INT32   GC;
   INT32   count;
   INT8  * pointList;

{
   if (xr_GCList[GC][XrFILLSTYLEVAL] == Solid)
      XDrawFilled (windowId, (Vertex *) pointList, count,
                   xr_GCList[GC][XrFOREGROUNDVAL], xr_GCList[GC][XrALUVAL],
                   AllPlanes);
   else if (xr_GCList[GC][XrFILLSTYLEVAL] == Tiled)
      XDrawTiled (windowId, (Vertex *) pointList, count,
                  xr_GCList[GC][XrTILEVAL],xr_GCList[GC][XrALUVAL],AllPlanes);
}


