/*
 *	$Source: /u1/X/DECToolkit/src/RCS/DiskSource.c,v $
 *	$Header: DiskSource.c,v 1.1 86/12/17 09:01:11 swick Exp $
 */

#ifndef lint
static char *rcsid_DiskSource_c = "$Header: DiskSource.c,v 1.1 86/12/17 09:01:11 swick Exp $";
#endif	lint

#ifndef lint
static  char    *sccsid = "@(#)DiskSource.c	1.6          12/11/86";
#endif lint
/*
 *			  COPYRIGHT 1986
 *		   DIGITAL EQUIPMENT CORPORATION
 *		       MAYNARD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
 * DIGITAL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT RIGHTS,
 * APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN ADDITION TO THAT
 * SET FORTH ABOVE.
 *
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting documentation,
 * and that the name of Digital Equipment Corporation not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission.
 */


/* File: DiskSource.c */

#include <X/Xlib.h>
#include <stdio.h>
#include "Toolkit.h"		
#include "TextDisplay.h"	/** included in all Text subwindow files **/

/* Private DiskSource Definitions */

typedef struct _TDiskSourceData {
    FILE *file;
    TTextPosition position, /*** read position for file ***/
		  length;   /*** length of file ***/
    char *buffer;	    /*** piece of file in memory ***/
    int charsInBuffer;	    /*** number of bytes used in memory ***/
} TDiskSourceData, *TDiskSourcePtr;

#define bufSize 1000
#define Increment(data, position, direction)\
{\
    if (direction == left) {\
	if (position > 0) \
	    position -= 1;\
    }\
    else {\
	if (position < data->length)\
	    position += 1;\
    }\
}

static char Look(data, position, direction)
  TDiskSourcePtr data;
  TTextPosition position;
  enum ScanDirection direction;
{
    TTextPosition pos;

    if (direction == left) {
	if (position == 0)
	    return('\n');
	else {
	    FillBuffer(data, position - 1);
	    return(data->buffer[position - data->position - 1]);
	}
    }
    else {
	if (position == data->length)
	    return('\n');
	else {
	    FillBuffer(data, position);
	    return(data->buffer[position - data->position]);
	}
    }
}

/***
 *** this routine will read source into "text", starting at "pos", for	
 *** "maxRead" characters or end.
 ***/
int DiskReadText (src, pos, text, maxRead)
  TTextSource *src;
  TTextPosition pos;
  TTextBlock *text;
  int maxRead;
{
    TTextPosition nextPos, count;
    TDiskSourcePtr data;

    data = (TDiskSourcePtr) src->data;
    FillBuffer(data, pos);
    text->ptr = data->buffer + (pos - data->position);
    count = data->charsInBuffer - (pos - data->position);
    text->length = (maxRead > count) ? count : maxRead;
    return pos + text->length;
}

/***
 *** this routine reads text starting at "pos" into memory.
 ***/
static int FillBuffer (data, pos)
  TDiskSourcePtr data;
  TTextPosition pos;
{
    TTextPosition readPos;
  
    /*** check to see if you really need to read anything ***/
    if ((pos < data->position ||
	    pos >= data->position + data->charsInBuffer - 100) &&
	    data->charsInBuffer != data->length) {
	if (pos < (bufSize / 2))
	    readPos = 0;
	else
	    if (pos >= data->length - bufSize)
		readPos = data->length - bufSize;
	    else
		if (pos >= data->position + data->charsInBuffer - 100)
		    readPos = pos - (bufSize / 2);
		else
		    readPos = pos;
	fseek(data->file, readPos, 0);
	data->charsInBuffer = fread(data->buffer, sizeof(char), bufSize,
                                data->file);
	data->position = readPos;
    }
}

/***
 *** this routine does nothing for a disk source, since you can not edit it. 
 ***/
static int DiskReplaceText (src, startPos, endPos, text)
  TTextSource *src;
  TTextPosition startPos, endPos;
  TTextBlock *text;
{
    return (0);
}


/***
 *** returns the lenth of the file.
 ***/
static TTextPosition DiskGetLastPos (src)
  TTextSource *src;
{
    return (((TDiskSourceData *)(src->data))->length);
}

/***
 *** lets you modify the lenth of the source.
 ***/
static int DiskSetLastPos (src, lastPos)
  TTextSource *src;
  TTextPosition lastPos;
{
    ((TDiskSourceData *)(src->data))->length = lastPos;
}


/***
 *** what time of text insertion is allowed for this source.
 ***/
static enum InsertionType DiskEditType()
{
 return(none);
}


/***
 *** This routine will start at
 *** the "pos" position of the source and scan in the appropriate
 *** direction until it finds something of the right sType.  It returns 
 *** the new position.  If upon reading it hits the end of the buffer
 *** in memory, it will refill the buffer.
 ***/
static TTextPosition DiskScan (src, pos, sType, dir, word_break_symbols)
  TTextSource *src;
  TTextPosition pos;
  enum SelectionType sType;
  enum ScanDirection dir;
  char *word_break_symbols;
{
    TDiskSourcePtr data;
    TTextPosition position;
    int whiteSpace;
    char    c;

    data = (TDiskSourcePtr) src->data;
    position = pos;
    switch (sType) {
	case charSelection: 
	    Increment(data, position, dir);
	    break;
	case wordSelection: 
	    whiteSpace = 0; 
	    while (position > 0 && position < data->length) {
		FillBuffer(data, position);
		c = Look(data, position, dir);
		whiteSpace = (c == ' ') || (c == '\t') || (c == '\n');
		if (whiteSpace)
		    break;
		else
		   if (index(word_break_symbols, c) != 0)
			break;
		Increment(data, position, dir);
	    }
	    break;
	case lineSelection: 
	    position = pos;
	    while (position > 0 && position < data->length) {
		FillBuffer(data, position);
		if (Look(data, position, dir) == '\n')
		    break;
		Increment(data, position, dir);
	    }
	    break;
	case allSelection: 
	    if (dir == left)
		position = 0;
	    else
		position = data->length;
    }
    return(position);
}



/*********************** Public routines ****************************/

int *TCreateDiskSource (name)
  char *name;
{
    TTextSource *src;
    TDiskSourcePtr data;

    src = (TTextSource *) Tmalloc(sizeof(TTextSource));
    src->read = DiskReadText;
    src->replace = DiskReplaceText;
    src->getLastPos = DiskGetLastPos;
    src->setLastPos = DiskSetLastPos;
    src->getEditType = DiskEditType;
    src->scan = DiskScan;
    src->data = (int *) (Tmalloc(sizeof(TDiskSourceData)));
    data = (TDiskSourcePtr) src->data;
    if ((data->file = fopen(name, "r")) == NULL)
	return(0);
    fseek (data->file, 0, 2);  
    data->length = ftell (data->file);  
    data->buffer = (char *) Tmalloc(bufSize);
    data->position = 0;
    data->charsInBuffer = 0;
    src->data = (int *) (data);
    return(int *) src;
}

void TDestroyDiskSource (src)
  TTextSource *src;
{
    free(src->data);
    free(src);
}
