/*	if_ddavar.h		V1.0		30 April 1986		*/

#define	NDDACH 		64		/* maximum number of channels */
#define DDA_SUPR	0x00		/* supervisory path for control */

#define DDAMTU		1006		/* maximum IP msg length */
#define	DDA_OQMAX	8		/* max IP msgs on LCN output q */
#define DELAY_CNT	50000
#define DDA_TIMEOUT	10

/* Link status codes */
#define LINK_DOWN	0x00		/* Link layer is down		*/
#define LINK_UP		0x01		/* Link layer is up		*/
#define LINK_DISABLED	0x02		/* Link layer is disabled	*/

/*
 * The following parameter modification commands such as BAUD_CNTL, or 
 * WATCHDOG, are one-byte values containing size and ID followed by 0-2 bytes 
 * of parameter information.  The number of bytes of parameter information is 
 * specified in the most significant 2 bits of the command, the other 6 bits 
 * are the ID.  A 00, 01, or 10 specify respectively 0, 1, or 2 bytes of 
 * parameter information follow.
 */
/* Line control codes */
#define LINK_DISABLE	0x00		/* Disable link layer		*/
#define LINK_ENABLE	0x01		/* Enable link layer		*/
#define LINK_LOOPBACK	0x42		/* Link layer loopback mode	*/
#define   LOOP_NONE	0x00		/*   Loopback off		*/
#define   LOOP_EXTERNAL	0x01		/*   Loopback external		*/
#define   LOOP_INTERNAL	0x03		/*   Loopback internal		*/
#define DTE_DCE_MODE	0x43		/* DTE/DCE Mode Parameter       */
#define   DTE        	0x00		/*   operate as DTE             */
#define   DCE        	0x01		/*   operate as DCE             */
#define DTE_ADDRESS 	0x44		/* DTE Address Parameter        */
#define   DTE_ADRVAL 	0x03		/*   DTE Address value          */
#define DCE_ADDRESS 	0x45		/* DCE Address Parameter        */
#define   DCE_ADRVAL 	0x01		/*   DCE Address value          */
#define IFRAME_TIMEO	0x46		/* I-Frame Timeout Parameter    */
#define   IFRAME_TOVAL 	0x03		/*   I-Frame Timeout value 3s   */
#define POLL_TIMEO  	0x47		/* Poll Timeout Parameter       */
#define   POLL_TOVAL 	0x03		/*   Poll Timeout value 3s      */
#define ADM_TIMEO  	0x48		/* ADM Timeout Parameter        */
#define   ADM_TOVAL 	0x03		/*   ADM Timeout value 3s       */
#define RETRY_LIMIT	0x4a		/* Retry Limit Parameter        */
#define   RETRY_VAL 	0x14		/*   20 (decimal) retries       */
#define	WATCHDOG	0x4b		/* Watchdog Timeout Parameter   */
#define   WATCHDG_VAL	0x03		/*   Watchdog Timeout value 3s  */
#define	BAUD_CNTL	0xa9		/* Baud Rate Parameter          */
#define	CLOCK_CNTL	0x6a		/* Select Clock Source          */
#define   EXTERNAL_CLOCK  0x00		/* clock generated externally   */
#define   INTERNAL_CLOCK  0x01		/* clock generated internally 	*/
#define	IDLE_POLL	0x4d		/* Idle Poll Parameter          */
#define   IDLE_POLL_ON	0x01		/*   Idle Polling on            */
#define   IDLE_POLL_OFF	0x00		/*   Idle Polling off           */
#define	FRAME_WINDOW	0x4e		/* Frame Window Parameter       */
#define   FWINDW_VAL  	0x07		/*   Frame Window value 7       */
#define	PKT_WINDOW	0x4f		/* Packet Window Parameter	*/
#define   PWINDW_VAL  	0x02		/*   Packet Window value 2      */
#define	PKT_SIZE   	0x90		/* Packet Size Parameter        */
#define   PVAL_BYTE1	0x08		/*   least significant byte     */
#define   PVAL_BYTE2	0x00		/*   most significant byte      */
#define	HIGH_THRESH	0x51		/* High Buffer Threshold Param  */
#define   HTRSH_VAL	0x08		/*   High Threshold value       */
#define	LOW_THRESH	0x52		/* Low Buffer Threshold Param   */
#define   LTRSH_VAL	0x08		/*   Low Threshold value        */
#define	QUEUED_BUFS	0x53		/* Max Number of Queued Buffers */
#define   QBUF_VAL 	0x08		/*   Queued Buffer value        */
#define	QUEUED_IFRAMES	0x54		/* Max Number Queued I-Frames   */
#define   QIFRAME_VAL 	0x08		/*   Queued I-Frame value       */
#define	FRAME_SIZE      0x95		/* Maximum Frames Size Parametr */
#define   FRAME_SIZE1 	0x95		/*   least significant byte     */
#define   FRAME_SIZE2 	0x01		/*   most significant byte      */
					/*   for value of 405 (decimal) */
#define	LCGN      	0x56		/* Logical Channel Group Number */
#define   LCGN_VAL    	0x00		/*   lcgn value                 */
#define	SVC_LIMIT	0x57		/* Switched Virtual Circuit     */
#define   SVC_VAL     	0x20		/*   SVC value 32 (decimal)     */

/* X25 supervisor message codes */
#define CALL		0x00		/* outgoing call		*/
#define RING		0x01		/* incoming call		*/
#define CLEARVC		0x02		/* clear by VCN			*/
#define	ANSWER		0x03		/* answer call			*/
#define CLEARLC		0x04		/* clear by LCN			*/
#define	RESET		0x20		/* reset LCN			*/
#define RESET_ACK	0x21		/* reset ack			*/
#define INTERRUPT	0x22		/* X25 interrupt		*/
#define	READY		0x23		/* flow control ready		*/
#define INTR_ACK	0x24		/* interrupt ack		*/
#define RESTART		0x40		/* X25 restart			*/
#define	RSTRT_ACK	0x41		/* restart ack			*/
#define SYS_STATUS	0x42		/* system status msg		*/
#define LINE_CNTL	0x60		/* link control cmnd		*/
#define LINE_STATUS	0x61		/* link status resp		*/

/* X25 facilities */
#define	X25_FACIL_DDA	0x04		/* DDA mode facility		*/
#define FAC_DDASTD	0x01		/*   DDA standard mode		*/

/* X25 protocols */
#define	X25_PROTO_IP	0xcc		/* X25 IP protocol type code	*/
