/*
 * RA-50 registers and structures
 */

struct radevice {
	short	ra_ip;		/* initialization and polling */
	short	ra_sa;		/* status and address */
};

#define	RA_ERR		0100000	/* error bit */
#define	RA_STEP4	0040000	/* step 4 has started */
#define	RA_STEP3	0020000	/* step 3 has started */
#define	RA_STEP2	0010000	/* step 2 has started */
#define	RA_STEP1	0004000	/* step 1 has started */
#define	RA_NV		0002000	/* no host settable interrupt vector */
#define	RA_QB		0001000	/* controller supports Q22 bus */
#define	RA_DI		0000400	/* controller implements diagnostics */
#define	RA_IE		0000200	/* interrupt enable */
#define	RA_PI		0000001	/* host requests adapter purge interrupts */
#define	RA_GO		0000001	/* start operation, after init */


/*
 * RA Communications Area
 */

struct raca {
	short	ca_xxx1;	/* unused */
	char	ca_bdp;		/* BDP to purge */
	char	ca_xxx2;	/* unused */
	short	ca_cmdint;	/* command queue transition interrupt flag */
	short	ca_rspint;	/* response queue transition interrupt flag */
	struct	{
		u_short rl;
		u_short rh;
	}	ca_rspdsc[NRSP];/* response descriptors */
	struct	{
		u_short	cl;
		u_short	ch;
	}	ca_cmddsc[NCMD];/* command descriptors */
};

#define	ca_ringbase	ca_rspdsc[0].rl

#define	RA_OWN	0x8000		/* RA owns this descriptor */
#define	RA_INT	0x4000		/* allow interrupt on ring transition */
