struct eldevice {
	u_short		elcs;		/* control status */
	union {				/* bus address */
		u_short rw;		/* data transfer */
		u_short getstat;	/* get status # of heads */
	}		elba;	
	union {				/* disk address */
		u_short	rw;		/* disk read/write track address */
		u_short	getstat;	/* get status # of logical tracks */
	}		elda;
	union {				/* multi-purpose register */
		u_short	getstat;	/* get status # of sectors per track */
		u_short readhdr;	/* read header */
		u_short	rw;		/* read/write word count */
	}		elmp;
	u_short		elbae;		/* 22bit bus address extention */
};

/* rlcs */
/* commands */
#define	EL_FORMAT	0x0000		/* format and read bad track map */
#define	EL_WCHECK	0x0002		/* write check */
#define	EL_GETSTAT	0x0004		/* get status */
#define	EL_SEEK		0x0006		/* explicit seek */
#define	EL_RHDR		0x0008		/* read header */
#define	EL_WRITE	0x000A		/* write data with implicit seek */
#define	EL_READ		0x000C		/* read data with implicit seek */
#define	EL_GETSSTAT	0x000E		/* get seek status */

#define	EL_DRDY		0x0001		/* When set indicates drive ready */
#define EL_SOFT		0x0010		/* Soft error on drive, corrected */
#define EL_ECC		0x0020		/* ECC error on drive, corrected */
#define	EL_IE		0x0040		/* interrupt enable */
#define	EL_CRDY		0x0080		/* controller ready */
#define	EL_DS0		0x0100		/* drive select 0 */
#define	EL_DS1		0x0200		/* drive select 1 */
#define	EL_OPI		0x0400		/* operation incomplete */
#define	EL_DCRC		0x0800		/* CRC error occurred */
#define	EL_DLT		0x1000		/* data late or header not found */
#define	EL_NXM		0x2000		/* non-existant memory */
#define	EL_DE		0x4000		/* selected drive flagged an error */
#define	EL_ERR		0x8000		/* composite error */

#define	EL_DCRDY	(EL_DRDY | EL_CRDY)

#define	ELCS_BITS \
"\20\20ERR\17DE\16NXM\15DLT\14DCRC\13OPI\12DS1\11DS0\10CRDY\7IE\6ECC\5SOFT\1DRDY"
