/*
 * drreg.h
 */ 

#define DRADMD 0x3A    	        /* address modifier for dma*/
#define DR_ZERO 0x0
#define DR_TICK 600
#define DR_TOCK 2
#define DR_PADD 0x55		/* used as a PADD in various places */
#define PAD_NUM	1		/* used as a PADD in various places */

/* define various dr11 driver internal flags - to be stored in dr_flags*/

#define DR_OPEN 0x0001     	/* this dr11 has been opened*/
#define DR_PRES 0x0002     	/* this dr11 is present*/
#define DR_ACTV 0x0004     	/* waiting for end-of-range*/
#define DR_ATWT 0x0008     	/* waiting for attention int*/
#define DR_ATRX 0x0010     	/* attn received-resets when read*/
#define DR_TMDM 0x0020     	/* time-out waiting for e-o-r*/
#define DR_TMAT 0x0040     	/* time-out waiting for attention*/
#define DR_DMAX 0x0080     	/* end of range int received*/

/* define various commands to be used when the used program calls ioctl()*/
#define DR_WAIT 0x0010     	/* wait for attention interrup*/
#define DR_RSET 0x1000     	/* issue master clear tos dev & board*/
#define DR_PIOW 0x0020     	/* write to p-i/o register*/
#define DR_PACL 0x0040     	/* send pulse to device*/
#define DR_DACL 0x0080     	/* defer aclo pulse until go*/
#define DR_PCYL 0x0100     	/* set cycle with next go*/
#define DR_DFCN 0x0200
				/* don't update function bits until*/ 
				/* next go issued*/
#define DR_RATN 0x4000
				/* reset attention flag -- use */
				/* with extreme caution!!!*/
#define DR_RDMA 0x8000
				/*reset dma end-of-range flag */
				/* should never be used!!*/
#define DR_SFCN 0x0001   	/* set function bits*/
#define DR_STIM 0x0400   	/* set wait and dma time-out val*/
#define DR_FMSK 0x000E   	/* function bit mask*/
#define DR_RPER 0x2000   	/* clear parity flag*/
#define DR_STGO 0xF000   	/* set GO bit */
#define DR_PFN1 0x0002   	/* set FCN1 */
#define DR_PFN3 0x0008   	/* set FCN3 */
#define DR_STAT 0x00F0   	/* get last status back to user */

/* ioctl call */
#define DR_IOC_WAIT ((0x10 << 16) | IOC_OUT | DR_WAIT)
#define DR_IOC_RSET ((0x10 << 16) | IOC_OUT | DR_RSET)
#define DR_IOC_PIOW ((0x10 << 16) | IOC_IN  | DR_PIOW)
#define DR_IOC_PACL ((0x10 << 16) | IOC_OUT | DR_PACL)
#define DR_IOC_DACL ((0x10 << 16) | IOC_OUT | DR_DACL)
#define DR_IOC_PCYL ((0x10 << 16) | IOC_OUT | DR_PCYL)
#define DR_IOC_DFCN ((0x10 << 16) | IOC_OUT | DR_DFCN)
#define DR_IOC_RATN ((0x10 << 16) | IOC_OUT | DR_RATN)
#define DR_IOC_RDMA ((0x10 << 16) | IOC_OUT | DR_RDMA)
#define DR_IOC_SFCN ((0x10 << 16) | IOC_OUT | DR_SFCN)
#define DR_IOC_STIM ((0x10 << 16) | IOC_IN  | DR_STIM)
#define DR_IOC_FMSK ((0x10 << 16) | IOC_OUT | DR_FMSK)
#define DR_IOC_RPER ((0x10 << 16) | IOC_OUT | DR_RPER)
#define DR_IOC_STGO ((0x10 << 16) | IOC_OUT | DR_STGO)
#define DR_IOC_PFN1 ((0x10 << 16) | IOC_OUT | DR_PFN1)
#define DR_IOC_PFN3 ((0x10 << 16) | IOC_OUT | DR_PFN3)
#define DR_IOC_STAT ((0x10 << 16) | IOC_OUT | DR_STAT)

/* define control register bits*/
#define RDMA 0x8000     	/* resets the dma end-of-range flag*/
#define RATN 0x4000     	/* resets the attention flag*/
#define RPER 0x2000     	/* resets the device parity error flag*/
#define MCLR 0x1000     	/* master clear board and INIt device */
#define CYCL 0x0100     	/* forces dma cycle if dma enabled*/
#define IENB 0x0040     	/* enables interrupts*/
#define FCN3 0x0008     	/* function bit 3 to de (FNCT3 H)*/
#define FCN2 0x0004     	/* enables dma and pulses GO to device*/ 
                                /* also asserts ACLO FCN2 H to device */
#define FCN1 0x0002     	/* function bit 1 to device (FCN1 H) */ 
#define GO   0x0001     	/* enables dma and pulses GO to device*/ 

/* define status register bits*/
#define DMAF 0x8000    		/* indicates dma end-of-range*/
#define ATTF 0x4000     	/* indicates attention false-to-true*/
#define ATTN 0x2000     	/* current state of ATTENTION H input*/
#define PERR 0x1000     	/* set by external parity error*/
#define STTA 0x0800     	/* STATUS A H input state*/
#define STTB 0x0400     	/* STATUS B H input state*/
#define STTC 0x0200     	/* STATUS C H input state*/
#define REDY 0x0080     	/* board ready for command (dma not on)*/
#define IENF 0x0040     	/* interrupts enabled if on*/
#define BERR 0x0020     	/* set if bus error during dma*/
#define FC3S 0x0008     	/* state of FCN3 latch */
#define FC2S 0x0004     	/* state of FCN2 latch*/
#define FC1S 0x0002     	/* state of FCN1 latch*/
#define OKMSK	0xFF80

/* define pulse command register bits -- which include RDMA,
 * RPER, MCLR, CYCL, FCN2, GO and two additional interrupt mask
 * control bits
 */

#define SMSK 0x0040     	/* pulses interrupt mask on*/
#define RMSK 0X0020     	/* pulses interrupt mask off*/

