/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)trap.h	6.2 (Berkeley) 6/8/85
 */

/*
 * ISI: IS68K {VQ}BUS 680{12}0 trap type values
 */

/* The first constant values are known to the real world <signal.h> */
#define	T_RESADFLT	0x00	/* reserved addressing fault */
#define	T_PRIVINFLT	0x01	/* privileged instruction fault */
#define	T_RESOPFLT	0x02	/* reserved operand fault */
/* End of known constants */

#define	T_BUSERR	0x03	/* bus error */
#define	T_ADDERR	0x04	/* address error */
#define	T_ZERODIV	0x05	/* divide by zero */
#define	T_CHK		0x06	/* CHK instruction */
#define	T_TRAPV		0x07	/* TRAPV instruction */
#define	T_SEGFLT	0x08	/* segment fault */
#define	T_PROTFLT	0x09	/* protection fault */
#define	T_TRCTRAP	0x0A	/* trace trap */
#define	T_NMI		0x0B	/* nonmaskable interrupt */
#define	T_PAGEFLT	0x0C	/* page fault */
#define	T_L1010EM	0x0D	/* line 1010 emulation */
#define	T_L1111EM	0x0E	/* line 1111 emulation */
#define	T_FMTERR	0x0F	/* stack format error */
#define	T_TRAP		0x10	/* trap instruction */
#define	T_SYSCALL	0x11	/* system call instruction */
#define	T_ASTFLT	0x12	/* asynchronous trap */
#define	T_STRAY		0x13	/* stray trap or interrupt */
#define	T_BPTFLT	0x14	/* breakpoint fault trap */
#define T_SEGVIO	0x15	/* segment violation */
#define T_CNTXFLT	0x16	/* context fault (68020) */
#define	T_COPROC	0x17	/* coprocessor protocol violation (68020) */
#define	T_FPE		0x18	/* floating point exception (68881) */
#define	T_PARITY	0x19	/* parity error */

#define	USER		0x20	/* user-mode flag added to type */

#ifdef	TRAP_TYPE
/*
 * The following array must match above indexes.
 */
char	*trap_type[] = {
	"Reserved addressing mode",	/* 0x00 */
	"Privileged instruction",	/* 0x01 */
	"Reserved operand",		/* 0x02 */
	"Bus error",			/* 0x03 */
	"Address error",		/* 0x04 */
	"Divide by zero",		/* 0x05 */
	"CHK trap",			/* 0x06 */
	"TRAPV trap",			/* 0x07 */
	"Segment fault",		/* 0x08 */
	"Protection violation",		/* 0x09 */
	"Trace trap",			/* 0x0A */
	"Nonmaskable interrupt",	/* 0x0B */
	"Page fault",			/* 0x0C */
	"A-Line emulation trap",	/* 0x0D */
	"F-Line emulation trap",	/* 0x0E */
	"Stack format trap",		/* 0x0F */
	"Trap trap",			/* 0x10 */
	"System call trap",		/* 0x11 */
	"Asynchronous trap",		/* 0x12 */
	"Stray interrupt",		/* 0x13 */
	"Breakpoint trap",		/* 0x14 */
	"Segment violation",		/* 0x15 */
	"Context fault",		/* 0x16 */
	"Coprocessor violation",	/* 0x17 */
	"Floating point exception",	/* 0x18 */
	"Parity error",			/* 0x19 */
};
#define	NTRAP_TYPES	(sizeof trap_type / sizeof trap_type[0])
#endif	TRAP_TYPE

/*
 * 680{12}0 exception stack frame layouts and extended layouts.
 *
 * The "esf" structures describe the 68020 hardware stack frames.
 * The "xsf" structures extend the short status register to a full
 * longword to match the kernel stack (the pc and psl must look like
 * elements in an array of ints).
 */
#ifndef	LOCORE

/* 68010, and 68020
 * format 0:	Normal 4-word stack frame - interrupts, format errors,
 *		trap #n, illegal instructions, A-line and F-line emulator traps,
 *		privilege violations, coprocessor pre-instruction exceptions.
 */
struct esf0 {	
	u_short	esf_sw;		/* status register */
	u_int	esf_pc;		/* program counter */
	u_short	esf_vec;	/* stack format and vector offset */
};
struct xsf0 {	
	u_int	xsf_psl;	/* program status longword */
	u_int	xsf_pc;		/* program counter */
	u_short	xsf_vec;	/* stack format and vector offset */
};

/* 68020
 * format 1:	Throwaway 4-word stack frame - interrupt while in master state.
 */
struct esf1 {
  	u_short	esf_sw;		/* status register */
	u_int	esf_pc;		/* program counter */
	u_short	esf_vec;	/* stack format and vector offset */
};
struct xsf1 {	
	u_int	xsf_psl;	/* program status longword */
	u_int	xsf_pc;		/* program counter */
	u_short	xsf_vec;	/* stack format and vector offset */
};

/* 68020
 * format 2:	Normal 6-word stack frame - chk, chk2, cptrapcc, trapv trace,
 *		zero divide, and coprocessor post-instruction exceptions.
 */
struct esf2 {	
	u_short	esf_sw;		/* status register */
	u_int	esf_pc;		/* program counter */
	u_short	esf_vec;	/* stack format and vector offset */
	u_int	esf_iaddr;	/* addr of instr causing trap */
};
struct xsf2 {	
	u_int	xsf_psl;	/* program status longword */
	u_int	xsf_pc;		/* program counter */
	u_short	xsf_vec;	/* stack format and vector offset */
	u_int	xsf_iaddr;	/* addr of instr causing trap */
};

/* 68010
 * format 8:	Bus Error on 68010.
 */
struct esf8 {	
	u_short	esf_sw;		/* status register */
	u_int	esf_pc;		/* program counter */
	u_short	esf_vec;	/* stack format and vector offset */
	u_short	esf_ssw_10;	/* special status word */
	u_int	esf_faddr_10;	/* data cycle fault addr */
	u_short	esf_rsv0;	/* reserved by Motorola */
	u_short	esf_dob;	/* data output buffer */
	u_short	esf_rsv1;	/* reserved by Motorola */
	u_short	esf_dib;	/* data input buffer */
	u_short	esf_rsv2;	/* reserved by Motorola */
	u_short	esf_ii[16];	/* internal information */
};
struct xsf8 {	
	u_int	xsf_psl;	/* program status longword */
	u_int	xsf_pc;		/* program counter */
	u_short	xsf_vec;	/* stack format and vector offset */
	u_short	xsf_ssw_10;	/* special status word */
	u_int	xsf_faddr_10;	/* data cycle fault addr */
	u_short	xsf_rsv0;	/* reserved by Motorola */
	u_short	xsf_dob;	/* data output buffer */
	u_short	xsf_rsv1;	/* reserved by Motorola */
	u_short	xsf_dib;	/* data input buffer */
	u_short	xsf_rsv2;	/* reserved by Motorola */
	u_short	xsf_ii[16];	/* internal information */
};

/* 68020
 * format 9:	Coprocessor mid-instruction 10-word stack frame.
 */
struct esf9 {	
	u_short	esf_sw;		/* status register */
	u_int	esf_pc;		/* program counter */
	u_short	esf_vec;	/* stack format and vector offset */
	u_int	esf_iaddr;	/* addr of coproc instr */
	u_int	esf_ireg[2];	/* internal regs */
};
struct xsf9 {	
	u_int	xsf_psl;	/* program status longword */
	u_int	xsf_pc;		/* program counter */
	u_short	xsf_vec;	/* stack format and vector offset */
	u_int	xsf_iaddr;	/* addr of coproc instr */
	u_int	xsf_aireg[2];	/* internal regs */
};

/* 68020
 * format A:	Short bus cycle fault stack frame - address error or bus error
 *		on instruction boundary.
 */
struct esfa {	
	u_short	esf_sw;		/* status register */
	u_int	esf_pc;		/* program counter */
	u_short	esf_vec;	/* stack format and vector offset */
	u_short	esf_reg1;	/* internal reg */
	u_short	esf_ssw_20;	/* special status word */
	u_short	esf_ipipec;	/* instr pipe stage C */
	u_short	esf_ipipeb;	/* instr pipe stage B */
	u_int	esf_faddr_20;	/* data cycle fault addr */
	u_int	esf_ireg2;	/* internal reg */
	u_int	esf_idob;	/* data output buffer */
	u_int	esf_ireg3;	/* internal reg */
};
struct xsfa {	
	u_int	xsf_psl;	/* program status longword */
	u_int	xsf_pc;		/* program counter */
	u_short	xsf_vec;	/* stack format and vector offset */
	u_short	xsf_sreg1;	/* internal reg */
	u_short	xsf_ssw_20;	/* special status word */
	u_short	xsf_ipipec;	/* instr pipe stage C */
	u_short	xsf_ipipeb;	/* instr pipe stage B */
	u_int	xsf_faddr_20;	/* data cycle fault addr */
	u_int	xsf_ireg2;	/* internal reg */
	u_int	xsf_idob;	/* data output buffer */
	u_int	xsf_ireg3;	/* internal reg */
};

/* 68020
 * format B:	Long bus cycle fault stack frame - address error or bus error
 *		not on instruction boundary.
 */
struct esfb {
	u_short	esf_sw;		/* status register */
	u_int	esf_pc;		/* program counter */
	u_short	esf_vec;	/* stack format and vector offset */
	u_short	esf_sreg1;	/* internal reg */
	u_short	esf_ssw_20;	/* special status word */
	u_short	esf_ipipec;	/* instr pipe stage C */
	u_short	esf_ipipeb;	/* instr pipe stage B */
	u_int	esf_faddr_20;	/* data cycle fault addr */
	u_int	esf_ireg2;	/* internal reg */
	u_int	esf_idob;	/* data output buffer */
	u_int	esf_aireg3[2];	/* internal reg */
	u_int	esf_ibaddr;	/* stage B addr */
	u_int	esf_ireg4;	/* internal reg */
	u_int	esf_idib;	/* data input buffer */
	u_int	esf_aireg5[11];	/* internal regs */
};
struct xsfb {
	u_int	xsf_psl;	/* program status longword */
	u_int	xsf_pc;		/* program counter */
	u_short	xsf_vec;	/* stack format and vector offset */
	u_short	xsf_sseg1;	/* internal reg */
	u_short	xsf_ssw_20;	/* special status word */
	u_short	xsf_ipipec;	/* instr pipe stage C */
	u_short	xsf_ipipeb;	/* instr pipe stage B */
	u_int	xsf_faddr_20;	/* data cycle fault addr */
	u_int	xsf_ireg2;	/* internal reg */
	u_int	xsf_idob;	/* data output buffer */
	u_int	xsf_aireg3[2];	/* internal reg */
	u_int	xsf_ibaddr;	/* stage B addr */
	u_int	xsf_ireg4;	/* internal reg */
	u_int	xsf_idib;	/* data input buffer */
	u_int	xsf_aireg5[11];	/* internal regs */
};

/*
 * Union of all stack frame layouts
 */
union esf {
	struct esf0	f0;
	struct esf1	f1;
	struct esf2	f2;
	struct esf8	f8;
	struct esf9	f9;
	struct esfa	fa;
	struct esfb	fb;
};
union xsf {
	struct xsf0	xf0;
	struct xsf1	xf1;
	struct xsf2	xf2;
	struct xsf8	xf8;
	struct xsf9	xf9;
	struct xsfa	xfa;
	struct xsfb	xfb;
};
#endif	!LOCORE

/*
 * Stack frame formats in vector offset word.
 */
#define	ESF_VECMSK	0x0fff		/* mask for sVec vector offset */
#define	ESF_VECSHIFT	2		/* shift for sVec vector */
#define	ESF_FMTMSK	0xf000		/* mask for sVec formats */
#define	ESF_FMTSHIFT	12		/* shift for sVec formats */
#define	ESF_FMT0	0x0000		/* stack format 0 68010, 68020*/
#define	ESF_FMT1	0x1000		/* stack format 1 68020*/
#define	ESF_FMT2	0x2000		/* stack format 2 68020*/
#define	ESF_FMT8	0x8000		/* stack format 8 68010*/
#define	ESF_FMT9	0x9000		/* stack format 9 68020*/
#define	ESF_FMTA	0xa000		/* stack format A 68020*/
#define	ESF_FMTB	0xb000		/* stack format B 68020*/
#define	ESF_SOFT	0x4000		/* Software collapse frame bit */
#define	ESF_SOFT_BIT	6		/* bit in upper byte */

/*
 * Stack frame sizes in bytes.
 */
#define	ESF_ISIZE0	8
#define	ESF_ISIZE1	8
#define	ESF_ISIZE2	12
#define	ESF_ISIZE8	58
#define	ESF_ISIZE9	20
#define	ESF_ISIZEA	32
#define	ESF_ISIZEB	92

#define	XSF_ISIZE0	(ESF_ISIZE0 + 2)
#define	XSF_ISIZE1	(ESF_ISIZE1 + 2)
#define	XSF_ISIZE2	(ESF_ISIZE2 + 2)
#define	XSF_ISIZE8	(ESF_ISIZE8 + 2)
#define	XSF_ISIZE9	(ESF_ISIZE9 + 2)
#define	XSF_ISIZEA	(ESF_ISIZEA + 2)
#define	XSF_ISIZEB	(ESF_ISIZEB + 2)

/*
 * Special status word on 68020
 */
#define	ESF_SSW_20_AFC	0x0007		/* data cycle address function code */
#define	ESF_SSW_20_SIZ	0x0030		/* data cycle size code */
#define	ESF_SSW_20_RW	0x0040		/* data cycle read/write (read==1) */
#define	ESF_SSW_20_RM	0x0080		/* data cycle read/modify/write  */
#define	ESF_SSW_20_DF	0x0100		/* data cycle fault/rerun flag  */
#define	ESF_SSW_20_RB	0x1000		/* instr pipe stage B rerun flag */
#define	ESF_SSW_20_RC	0x2000		/* instr pipe stage C rerun flag */
#define	ESF_SSW_20_FB	0x4000		/* instr pipe stage B fault flag */
#define	ESF_SSW_20_FC	0x8000		/* instr pipe stage C fault flag */
#define	ESF_SSW_20_BITS	\
"\20\20IPCF\17IPBF\16IPCR\15IPBR\11RERUN\10READ\7RMW\6SIZ1\5SIZ0\3FC2\2FC1\1FC0"
#define ESF_SSW_20_SOFTMSK \
	~(ESF_SSW_20_DF|ESF_SSW_20_RB|ESF_SSW_20_RC) /* dont rerun */

/*
 * Special status word on 68010
 */
#define	ESF_SSW_10_AFC	0x0007		/* data cycle address function code */
#define	ESF_SSW_10_RW	0x0100		/* data cycle read/write (read==1) */
#define	ESF_SSW_10_BY	0x0200		/* byte transfer flag */
#define	ESF_SSW_10_HB	0x0400		/* high byte */
#define	ESF_SSW_10_RM	0x0800		/* read/modify/write cycle */
#define	ESF_SSW_10_DF	0x1000		/* data fetch flag */
#define	ESF_SSW_10_RR	0x8000		/* Re-run flag, 1-> software rerun */
#define	ESF_SSW_10_BITS	\
"\20\20RERUN\16IFETCH\16DFETCH\14RMW\13HBYTE\12BYTE\11READ\3FC2\2FC1\1FC0"

/*
 * 68881 exception vectors
 */

#define	    FPE_TRAPCC_VEC	0x07	/* FTRAPcc instruction */
#define	    FPE_FLINE_VEC	0x0b	/* F-Line emulation trap */
#define	    FPE_COPROC_VEC	0x0d	/* coprocessor protocol violation */
#define	    FPE_FBSUN_VEC	0x30	/* branch/set on unordered */
#define	    FPE_INEXCT_VEC	0x31	/* inexact result */
#define	    FPE_FLTDIV_VEC	0x32	/* divide by zero floating fault */
#define	    FPE_FLTUND_VEC	0x33	/* floating underflow */
#define	    FPE_FOPERR_VEC	0x34	/* operand error */
#define	    FPE_FLTOVF_VEC	0x35	/* floating overflow fault */
#define	    FPE_FLTNAN_VEC	0x36	/* divide by zero floating fault */
