/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)scb.h	6.2 (Berkeley) 6/8/85
 */

/*
 * ISI: IS68K System control block layout
 */
#define	NSCBVEC	256
#define BUSVEC	(2<<2)				/* bus error offset */
#define ADRVEC	(3<<2)				/* address error offset */
#define ILLVEC	(4<<2)				/* illegal instruction offset */
#define NMIVEC	(31<<2)				/* non maskable offset */

#ifndef LOCORE 

struct scb {
    union {
	int	(*scb_blk[NSCBVEC])();
	struct {
	/*  0*/	int	(*scb_isp)();		/* reset stack pointer */
	/*  1*/	int	(*scb_ipc)();		/* reset program counter */
	/*  2*/	int	(*scb_buserr)();	/* bus error */
	/*  3*/	int	(*scb_adrerr)();	/* address error */
	/*  4*/	int	(*scb_illins)();	/* illegal instruction */
	/*  5*/	int	(*scb_zerodiv)();	/* zero divide */
	/*  6*/	int	(*scb_chk)();		/* CHK instruction */
	/*  7*/	int	(*scb_trapv)();		/* TRAPV instruction */
	/*  8*/	int	(*scb_privvio)();	/* privilege violation */
	/*  9*/	int	(*scb_trace)();		/* trace */
	/* 10*/	int	(*scb_l1010em)();	/* A-line emulation */
	/* 11*/	int	(*scb_l1111em)();	/* F-line emulation */
	/* 12*/	int	(*scb_reserved0)();	/* reserved by Motorola */
	/* 13*/	int	(*scb_coproc)();	/* coprocessor protocol vio */
	/* 14*/	int	(*scb_fmterr)();	/* exception stack format err */
	/* 15*/	int	(*scb_uninvec)();	/* uninitialized vector */
	/* 16*/	int	(*scb_reserved1[8])();	/* reserved by Motorola */
	/* 24*/	int	(*scb_spurint)();	/* spurious interrupt */
	/* 25*/	int	(*scb_autovec[3])();	/* autovector #1-3 */
	/* 28*/	int	(*scb_procint)();	/* autovector #4  processor */
	/* 29*/	int	(*scb_lclock)();	/* autovector #5, line clock */
	/* 30*/	int	(*scb_autovec6)();	/* autovector #6 */
	/* 31*/	int	(*scb_nmi)();		/* autovecrot #7, NMI */
	/* 32*/	int	(*scb_trap[16])();	/* trap instructions */
	/* 48*/	int	(*scb_fpe[8])();	/* Motorola 68881 */
	/* 56*/	int	(*scb_pmmu[8])();	/* Motorola PMMU */

#define SCBDEV	64				/* start of device interupts */
	/* 64*/	int	(*scb_devint[192])();	/* external devices */
	/*256*/
	} scb_ivec;
    } scb_vec
};

#ifdef KERNEL
extern	struct scb scb;
extern	int Xstray();
#endif

#define	scbentry(f, how)		((int (*)())(((int)f)+how))

#define	SCB_KSTACK	0
#define	SCB_ISTACK	1
#define	SCB_WCS		2
#define	SCB_HALT	3
#endif
