/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)clock.h	6.2 (Berkeley) 6/8/85
 */

#define	SECDAY		((unsigned)(24*60*60))		/* seconds per day */
#define	SECYR		((unsigned)(365*SECDAY))	/* per common year */

#define	YRREF		1970
#define	LEAPYEAR(year)	((year)%4==0)	/* good till time becomes negative */

#ifdef	VBUS
/*
 * time from QICII or TC50 battery clock.
 * NOTE: These macros MUST be used at spl >= controller interrupt level.
 */
#define BCLOCK_WAIT()		do DELAY(200); while(*battery_clock & 0x8000);
#define BCLOCK_READ(i, v)	*battery_clock = 0xC000 | ((i & 0xF)<<8); \
				BCLOCK_WAIT(); v = *battery_clock & 0xFF; \
				v = ((v >> 4) * 10)  + (v & 0xF);
#define BCLOCK_WRITE(i, v)	*battery_clock = 0xD000 | ((i&0xF)<<8) | \
				((((v/10) << 4) + (v%10)) & 0xFF); BCLOCK_WAIT()
#define BCLOCK_GET()		*battery_clock = 0xE000; BCLOCK_WAIT()
#define BCLOCK_SET()		*battery_clock = 0xF000; BCLOCK_WAIT()
#define	BCLOCK_RESET()		*battery_clock = 0;

static	int	dmsize[12] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
#endif	VBUS
