/*
 * IS68010 QBUS CPU card constants:
 */

#define	MEMR_MASK	0xFFC00000	/* memory region mask */
#define	MAXU_ADDR	0x00400000	/* size of user virtual space */
#define	SYSV_BASE	0x00000000	/* system virtual base */
#define	NONT_MASK	0x003FFFFF	/* non-translated address space mask */

/* CONTEXT/BOARD STATUS REGISTER (CBX) */
#ifdef LOCORE
#define	CXW	0xC10000		/* must be written with a word access */
#define	CXR	0xC10001		/* must be read with a byte access */
#else  LOCORE
#define	CXW	((u_short *)0xC10000)	/* must be written with a word access */
#define	CXR	((u_char *)0xC10001)	/* must be read with a byte access */
#endif LOCORE
#define	CX_PARITYENABLE	0x01		/* parity enable bit */
#define	CX_INVALIDPAGE	0x02
#define	CX_PROTECTION	0x04
#define	CX_BUSTIMEOUT	0x08
#define CTXMASK		0xF0
#define CTXSHIFT	4

/* BOARD STATUS REGISTER (BSR) */
#ifdef LOCORE
#define	BSR	0xC30000		/* board status register */
#else  LOCORE
#define	BSR	((u_short *)0xC30000)	/* board status register */
#endif LOCORE
#define	BSR_SWITCH8	0x0001
#define	BSR_SWITCH7	0x0002
#define	BSR_SWITCH6	0x0004
#define	BSR_SWITCH5	0x0008
#define	BSR_IBHALTL	0x0010
#define	BSR_IBPOKH	0x0020
#define	BSR_HALT	0x0040
#define	BSR_LOCALPARITY	0x0080
#define	BSR_BUSPARITY	0x0100
#define	BSR_POWERFAIL	0x0200

#define BSR_NSPEEDS	2
#define	BSR_CPUSPEED	(BSR_SWITCH8)
#define	BSR_CPUSPEED10	(0)		/* switch 8 on */
#define	BSR_CPUSPEED12	(BSR_SWITCH8)	/* switch 8 off */
#define BSR_DISK	(BSR_SWITCH7)
#define	BSR_DISK_EHP	(BSR_SWITCH7)	/* EMMULEX hp controler, switch 7 off */
#define	BSR_BAUD	(BSR_SWITCH5|BSR_SWITCH6)
#define BSR_BAUD_9600	(0)		/* switch 5 and 6 on */
#define BSR_BAUD_19200	(BSR_SWITCH6)	/* switch 5 on, switch 6 off */
#define BSR_BAUD_1200	(BSR_SWITCH5)	/* switch 5 off, switch 6 on */
#define BSR_BAUD_300	(BSR_SWITCH5|BSR_SWITCH6) /* switch 5 and 6 off */

/* PROM */
#ifdef LOCORE
#define	PROM		0xC00000
#else  LOCORE
#define	PROM		((u_short *)0xC00000)
#endif LOCORE
#define	PROM_BASE	PROM
#define PROM_REBOOT	PROM+8

/* NUMBER OF CONTEXTS */
#define NCTX		16		/* Number of Contexts */
#define CTX_SYS		0	
#define CTX_INVALID	15		/* unallocated context */

/* SEGMENT REGISTERS */
#define NSEGPERCTX	64		/* number of segs per context */
#define NSEGREG		NSEGPERCTX*NCTX	/* total number of seg registers */
#define	SEGREGBASE	0x400000	/* base address of seg registers */
#define	SEGTYPE		short
#define	SEGPROTMASK	0xC0		/* mask for protection bits */
#define SEGPROT_NO	0x00		/* protection for no access */
#define SEGPROT_REO	0x40		/* protection for read execute only */
#define SEGPROT_ALL	0x80		/* protection for all access */
#define SEGPROT_EO	0xC0		/* protection for user execute only */
#define	SEGPROTSHIFT	6		/* shift to right justify protection */
#define SEGINVALID	0		/* SEGPROT_NO, invalid segment   vio */
#define SEGPAGEDOUT	1		/* SEGPROT_NO, paged out segment flt */
#define	SEGREGINCR	0x010000	/* incr to next seg reg in same ctx */
#define SEGREGSHIFT	16		/* shift for #<=>seg reg conversion */
#define SEGCTXINCR	0x001000	/* incr to same seg reg in next ctx */
#define SEGCTXSHIFT	12		/* shift for #<=>ctx reg conversion */
#define SEGNXTINCR	1		/* incr contents of reg for next seg */

/* PAGE REGISTERS */
#define NPAGPERSEG	16		/* number of pages in a segment */
#define PAGSEGSHIFT	4		/* shift for pag<=>seg conversion */
#define NPAGBANKS	64		/* number of page register banks */
#define NPAGREG		NPAGBANKS*NPAGPERSEG /* number of page registers */
#define	PAGREGBASE	0x800000	/* base address of page registers */
#define	PAGREGINCR	0x001000	/* incr to next page register */
#define PAGREGSHIFT	12		/* shift for #<=>pag reg conversion */
#define PAGVALSHIFT	2		/* shift for #<=>pag reg value */
#define PAGNXTINCR	4		/* incr contents of pag for next page */
#define PAGREFBIT	1		/* page referenced bit */
#define PAGMODBIT	0		/* page modified bit */
#define PAGOUTPAGE	0x3FC		/* paged out page */
#define PAGINVPAGE	0x3FD		/* page invalid page */
#define PAGNUMMASK	0xFFC		/* mask for physical page number */
