/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)uio.h	7.1 (Berkeley) 6/4/86
 */

#ifndef _UIO_
#define	_UIO_

struct iovec {
	caddr_t	iov_base;
	int	iov_len;
};

struct uio {
	struct	iovec *uio_iov;
	int	uio_iovcnt;
	off_t	uio_offset;
	short	uio_segflg;
	short	uio_fmode;
#define	uio_seg	uio_segflg		/* NFS: compatibility */
	int	uio_resid;
#ifdef	is68k
	int	uio_offset_sysv;	/* ISI: SYSV: */
	int	uio_offset_buf;		/* ISI: SYSV: */
#endif	is68k
};

enum	uio_rw { UIO_READ, UIO_WRITE };

/*
 * Segment flag values (should be enum).
 */
#define UIO_USERSPACE	0		/* from user data space */
#define UIO_SYSSPACE	1		/* from system space */
#define UIO_USERISPACE	2		/* from user I space */
#define UIOSEG_USER	UIO_USERSPACE	/* NFS: compatibility */
#define UIOSEG_USR	UIO_USERSPACE	/* NFS: compatibility */
#define UIOSEG_KERNEL	UIO_SYSSPACE	/* NFS: compatibility */
#endif
