/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)systm.h	7.1 (Berkeley) 6/4/86
 */

/*
 * Random set of variables
 * used by more than one
 * routine.
 */
extern	char version[];		/* system version */

/*
 * Nblkdev is the number of entries
 * (rows) in the block switch. It is
 * set in binit/bio.c by making
 * a pass over the switch.
 * Used in bounds checking on major
 * device numbers.
 */
int	nblkdev;

/*
 * Number of character switch entries.
 * Set by cinit/prim.c
 */
int	nchrdev;

int	nswdev;			/* number of swap devices */
int	mpid;			/* generic for unique process id's */
char	runin;			/* scheduling flag */
char	runout;			/* scheduling flag */
int	runrun;			/* scheduling flag */
char	curpri;			/* more scheduling */

int	maxmem;			/* actual max memory per process */
int	physmem;		/* physical memory on this CPU */
int	lockablemem;		/* memory reserved for process locking */

int	nswap;			/* size of swap space */
int	updlock;		/* lock for sync */
daddr_t	rablock;		/* block to be read ahead */
int	rasize;			/* size of block in rablock */
extern	int intstack[];		/* stack for interrupts */
dev_t	rootdev;		/* device of the root */
dev_t	dumpdev;		/* device to take dumps on */
long	dumplo;			/* offset into dumpdev */
dev_t	swapdev;		/* swapping device */
dev_t	argdev;			/* device for argument lists */
struct vnode *rootvp;		/* NFS: vnode of root filesystem */
struct	vnode	*swapdev_vp;	/* NFS: vnode equivalent to above */
struct	vnode	*argdev_vp;	/* NFS: vnode equivalent to above */
int	int_svc;		/* depth of nested interrupts */

#ifdef vax
extern	int icode[];		/* user init code */
extern	int szicode;		/* its size */
#endif

daddr_t	bmap();
int	memall();
int	vmemall();
#ifdef is68k
#ifdef	M68020			/* ISI: */
int	memallpt();		/* ISI: */
int	vmemallpt();		/* ISI: */
#endif	M68020			/* ISI: */
#endif is68k
caddr_t	wmemall();
caddr_t	kmem_alloc();		/* NFS: */
swblk_t	vtod();			/* NFS: */
struct vnode *bdevvp();		/* NFS: */
struct vnode *specvp();		/* NFS: */

/*
 * Structure of the system-entry table
 */
extern struct sysent
{
	int	sy_narg;		/* total number of arguments */
	int	(*sy_call)();		/* handler */
} sysent[];

int	noproc;			/* no one is running just now */
char	*panicstr;
int	wantin;
int	boothowto;		/* reboot flags, from console subsystem */
int	selwait;

extern	char vmmap[];		/* poor name! */

/* casts to keep lint happy */
#define	insque(q,p)	_insque((caddr_t)q,(caddr_t)p)
#define	remque(q)	_remque((caddr_t)q)
/*#define	queue(q,p)	_queue((caddr_t)q,(caddr_t)p) /* ISI: SYSV: */
#define	dequeue(q)	_dequeue((caddr_t)q)
