/*
 * ISI: kernel debugger
 */
#define MONITOR		0x1f		/* Console escape: <SHIFT><CTL>_ */

#define BYTE		1		/* display formats */
#define WORD		2
#define LONG		4

#define NUM_LINES	16		/* number of dumped lines   */
#define NUM_BYTES	16		/* number of dumped bytes   */
#define NUM_BRKPTS	16		/* max number of brk points */

#define BRKPT		0x4e4f		/* break instruction        */

#define ESC		0x1b
#define CR		0x0d
#define LF		0x0a
#define NAK		0x15
#define BS		0x08
#define DEL		0x7f

#define DBG_MAGIC	0xc35dfa72
#define NEWDBG_MAGIC	0x46af091e

#define	NDBG_SYM	4400
#define	NDBG_STR	(NDBG_SYM*10)

struct	debug_nl {
	char	*name;
	unsigned long value;
};

#define MAXTOK		80

#define isnull(c)	((c) == 0)
#define issymbolic(c)	(((c) == '_') || ((c) == ':') || \
			((c) >= 'A' && (c) <= 'Z') || \
			((c) >= 'a' && (c) <= 'z'))
#define isnumeric(c)	(((c) >= '0' && (c) <= '9') || \
			 ((c) >= 'A' && (c) <= 'F') || \
			 ((c) >= 'a' && (c) <= 'f'))
#define iswhitespace(c) ((c) == ' ' || (c) == '\t')
#define isbinop(c)	(((c) == '+') || \
		 	 ((c) == '-') || \
		 	 ((c) == '*') || \
		 	 ((c) == '%') || \
		 	 ((c) == '&') || \
		 	 ((c) == '|'))
