/*
 * BSD system parameter formulae.
 *
 * This file is copied into each directory where we compile
 * the kernel; it should be modified there to suit local taste
 * if necessary.
 *
 * Compiled with -DHZ=xx -DTIMEZONE=x -DDST=x -DMAXUSERS=xx
 */
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/socket.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/text.h"
#include "../h/vnode.h"
#include "../h/file.h"
#include "../h/callout.h"
#include "../h/clist.h"
#include "../h/cmap.h"
#include "../h/mbuf.h"
#include "../h/kernel.h"
#include "../ufs/inode.h"
#include "../ufs/quota.h"
#include "../specfs/fifo.h"
#include "../machine/cpu.h"
#include "../is68kdev/pdma.h"

/* DEVICE SPECIFIC */
#include "vb.h"			/* VMEBUS */
#include "nw.h"			/* VMEBUS */
#include "dl.h"			/* QBUS */
#include "dz.h"			/* QBUS */

int	rrtimeslice =	10;	/* nth of second round robin time slice */
#ifndef	BUFPAGES
#define	BUFPAGES	0
#endif
int	bufpages =	BUFPAGES;/* user defineable kernel buffers in pages */
int	bufpcnt =	20;	/* % of memory above 2 meg to use as buffers */
int	lockablemem =	0;	/* user defineable lockable mem in pages */
int	detachedmem =	0;	/* user defineable detached mem in pages */
#ifdef	DEBUGGER
int	enable_debugger = 1;	/* disable/enable kernel debug monitor */
#else	DEBUGGER
int	enable_debugger = 0;	/* disable/enable kernel debug monitor */
#endif	DEBUGGER

#define POPCONSOLE	0	/* disable/enable non-panic console pop-up */
short	popconsole = POPCONSOLE;

#ifndef	HZ
#define	HZ		60
#endif	HZ
int	hz =		HZ;
int	tick =		1000000 / HZ;
int	tickadj =	1000000 / HZ / 10;

struct	timezone tz =	{ TIMEZONE, DST };

#define	NPROC		(20 + 8 * MAXUSERS)
#define NINODE		((NPROC + 16 + MAXUSERS) + 64)
int	maxuprc =	MAXUPRC;
int	nproc =		NPROC;
int	ntext =		36 + MAXUSERS;
int	ninode =	NINODE;
int     ncsize =	NINODE * 11 / 10;
int	nfile =		16 * (NPROC + 16 + MAXUSERS) / 10 + 32;
int	ncallout =	16 + NPROC;
int	nclist =	100 + 10 * MAXUSERS;
int	nport =		NPROC / 2;
int     nmbclusters =	NMBCLUSTERS;
#ifdef QUOTA
int	nquota =	(MAXUSERS * 9) / 7 + 3;
int	ndquot =	NINODE + (MAXUSERS * NMOUNT) / 4;
#endif
#ifdef	TCP_COMPAT_42
int	tcp_compat_42 =	1;
#else	TCP_COMPAT_42
int	tcp_compat_42 =	0;
#endif	TCP_COMPAT_42

#ifdef	UDP_COMPAT_42
int	udp_compat_42 =	1;
#else	UDP_COMPAT_42
int	udp_compat_42 =	0;
#endif	UDP_COMPAT_42

struct fifoinfo	fifoinfo = {	/* fifo parameters */
	FIFOBUF,
	FIFOMAX,
	FIFOBSZ,
	FIFOMNB
};

/* 
 * These are initialized at bootstrap time to values dependent on memory size
 */
int	nbuf, nswbuf;

/*
 * The following array is indexed by the major number, and should return
 * the two letter name for the block device.  NOTE: This should be part of the 
 * "bdevsw" block device switch structure.
 */
char	*bdevname[] = {
#ifdef	QBUS
	0, "el", "hp", "rk", "ra", "rl", "rd", "rx", "tm", "ts", 0
#else	QBUS
	0, "sd", "sm", "gd", "rf",    0, "rd",    0,    0, "ts", 0
#endif	QBUS
};
int nbdevnames = (sizeof bdevname) / (sizeof bdevname[0]);

/*
 * The following array has the names of devices which will get probed 
 * on a cluster node, it must be null terminated.
 */
char	*clu_name_list[] = { "vb", "gp", "sk", (char *)0 };

int	rdswapsize = 66880;	/* size in blocks of diskless/cluster swap */

/*
 * These have to be allocated somewhere; allocating them here forces loader 
 * errors if this file is omitted.
 */
struct	proc	*proc, *procNPROC;
struct	text	*text, *textNTEXT;
struct	inode	*inode, *inodeNINODE;
struct	file	*file, *fileNFILE;
struct 	callout	*callout;
struct	cblock	*cfree;
struct	buf	*buf, *swbuf;
short		*swsize;
int		*swpf;
char		*buffers;
struct	cmap	*cmap, *ecmap;
struct	nch	*nch;
#ifdef QUOTA
struct	quota	*quota, *quotaNQUOTA;
struct	dquot	*dquot, *dquotNDQUOT;
#endif

struct locklist *locklist, *locklistNRLOCKS;

#ifndef	TRFS
uid_t		trfs_rootuid = -3;
Rexit(n)	{exit(n);}
MidToRpid()	{return 0;}
REMchdirec()	{return 1;}
Wrelse()	{}
#endif	TRFS

#ifndef	QUOTA
qtinit()	{}
struct quota *
getquota()	{ return (struct quota *)0; }
#endif	QUOTA

#ifndef	GPROF
kmstartup()	{}
#endif	GPROF

#ifndef	NFS	
nfs_svc(){}				/* NFS: systemcall */
nfs_async_daemon(){}			/* NFS: systemcall */
nfs_getfh(){}				/* NFS: systemcall */
exportfs(){}				/* NFS: systemcall */
klm_lockctl() { return EINVAL;}
#endif	NFS	

#ifndef	DEBUGGER
dbg_addkvsymbol(){return(0);}
#endif	DEBUGGER

#ifndef	SYSV
preg_vtopte() {panic("preg_vtopte");}
#endif	SYSV

/* getmachtype system call */
getmachtype()
{
	union {
		int itype;
		struct machtype type;
	} typem;
	extern int	have_68881;
	extern int	skybase;
	extern char	*gpaddr;

#define machine	typem.type

	typem.itype = 0;
#ifdef	M68010
	machine.type_cpu = MACH_TYPE_CPU_68010;
#else	M68010
	machine.type_cpu = MACH_TYPE_CPU_68020;
	if (have_68881)
		machine.type_coprocessor |= MACH_TYPE_COPROC_68881;
#endif	M68010
	if (skybase)
		machine.type_coprocessor |= MACH_TYPE_COPROC_SKY;
#ifdef	QBUS
	machine.type_bus = MACH_TYPE_BUS_QBUS;
#else	QBUS
	machine.type_bus = MACH_TYPE_BUS_VBUS;
#endif	QBUS
#ifdef	TRFS
	machine.type_trfs = 1;
	if (diskless)
		machine.type_diskless = 1;
#ifdef	VBUS
	if (vbnum)
		machine.type_cluster = 1;
#endif	VBUS
#endif	TRFS
	if (gpaddr)
		machine.type_graphics = 1;
#ifdef	NFS
	machine.type_nfs = 1;
#endif	NFS
#ifdef	SYSV
	machine.type_sysv = 1;
#endif	SYSV
	u.u_r.r_val1 = typem.itype;
}

/*
 * VME specific
 */
#ifndef	GWS
GP_fork()	{}
GP_initialize() { return 0 ;}
#endif	GWS

#if	NVB == 0
int vbnum =	0;
int vbreboot()	{}
int VB_initialize() {}
int vbcheck() {}
#endif	NVB == 0

#if	NNW == 0
int NW_initialize() {}
#endif	NNW == 0

/*
 * QBUS specific
 */
#if	NDL == 0
struct	pdma dlpdma[1];
#endif	NDL == 0

#if	NDZ == 0
struct	pdma dzpdma[1];
#endif	NDZ == 0
