#!/bin/sh

if [ ! -r version.release ]; then echo 4 > version.release; fi
if [ ! -r version.subrelease ]; then echo 0 > version.subrelease; fi
if [ ! -r version.revision ]; then echo D > version.revision; fi
if [ ! -r version.local ]; then echo 0 > version.local; fi
echo `cat version.release` `cat version.subrelease` \
	`cat version.revision` `cat version.local` > version

awk '	{ release = $1;	subrelease = $2; revision = $3; local = $4 + 1; }\
END	{	printf "char stub[] = \"\";\n" > "vers.c";\
		printf "char version[] = \"IS68K 4.3BSD UNIX: %d.%01d%s #%d: ", \
		release, subrelease, revision, local > "vers.c";\
		printf "%d\n", local > "version.local"; }' < version

if `grep -s SYSV Makefile`; then \
	if [ ! -r version.sysvrel ]; then echo 1 > version.sysvrel; fi
	if [ ! -r version.sysvsubrel ]; then echo 0 > version.sysvsubrel; fi
	if [ ! -r version.sysvrev ]; then echo B > version.sysvrev; fi
	echo -n "SYSV `cat version.sysvrel`.`cat version.sysvsubrel``cat version.sysvrev`: " >> vers.c
fi

echo `pwd` | awk -F/ '{printf $NF;}' >> vers.c
echo \(`whoami`@`hostname`\):`../conf/newdate "+%D %H:%M"`'\n\' >> vers.c
echo 'Copyright (c) 1987 by Integrated Solutions, Inc.\n\n";' >> vers.c
echo -n "char options[] = \"" >> vers.c
head -2 Makefile | awk -F- '{  for (i = 2; i <= NF ; i++) printf "%s ", substr($i,2)}' >> vers.c
echo "\";" >> vers.c
rm -f version
