(*$w-*)
short		 = -32768..32767;
TYPEVTSCHARS	= packed array[1..16] of char;
TYPEMTABSIZE	= packed array[1..33] of char;

MOUSESTATE = packed set of
	(VTNOP31, VTNOP30, VTNOP29, VTNOP28,
	 VTNOP27, VTNOP26, VTNOP25, VTNOP24,
	 VTNOP23, VTNOP22, VTNOP21, VTNOP20,
	 VTNOP19, VTNOP18, VTNOP17, VTNOP16,
	 VTNOP15, VTNOP14, VTNOP13, VTNOP12,
	 VTNOP11, VTNOP10, VTNOP09, VTNOP08,
         VTMOUSELEFT,VTMOUSEMIDDLE,VTMOUSERIGHT, VTNOP04,
	 VTMOUSEDOWN,VTMOUSEUP,VTMOUSENOBUTTON,VTMOUSECONTINUOUS );

gconfig =
   packed record
      w,h:short;		(* screen width and height	*)
      xres,yres:short;		(* screen x and y resolution	*)
      lutsize:integer;		(* color lookup table size	*)
      nred,ngreen,nblue:integer;(* number of rgb intensities	*)
      nwindows:short;		(* number of windows		*)
      nistyles:short;		(* number of icon styles	*)
      nicons:short;		(* number of icons		*)
      realcolors:integer;	(* number of real colors	*)
end;

kconfig	=
   packed record
      kcdelay,			(* delay before repeat		*)
      kcramp,			(* acceleration			*)
      kcinitial,		(* initial repeat rate		*)
      kcmax,			(* final repeat rate		*)
      kcclick : char;		(* key click loudness		*)
end;

mconfig =
   packed record
      mcdelta : char;		(* minimum delta		*)
      mctable:TYPEMTABSIZE;	(* substitution values		*)
end;

vconfig =
   packed record
      vctimeout : integer;	(* dimming delay		*)
      vcworklevel,		(* working brightness		*)
      vcidlelevel: char;	(* idle brightness		*)
end;

RASTER =
   packed record
      width : short;		(* width of raster in bytes	*)
      address : ^short;		(* pointer to raster data	*)
end;

vtseq =
   packed record
      ctype: integer;
      case integer of		(* type of input sequence	*)
	 VTEOF : ();
	 VTASCII :
	    (ascii : char);	(* ascii character		*)
	 VTHARDKEY :
	    (mode, 		(* hardkey: shift mode		*)
	    keycode : char);	(* hardkey: key code		*)
	 VTMOUSE :
	    (buttons:MOUSESTATE;(* mouse: button transition	*)
	    window : char;	(* mouse: the window number	*)
	    pane:char;       	(* mouse: the pane-id		*)
	    x, y : short);	(* mouse: the location		*)
end;

defsfk =
   packed record
      num : short;		(* key number  0..9 for f1..f10	*)
      highlighted: boolean;     (* highlight value		*)
      uname : TYPEVTSCHARS; 	(* upper name			*)
      lname : TYPEVTSCHARS;	(* lower name			*) 
end;
wstate	= 
   packed record
      fcolor, bcolor,   	(* current color index		*)
      font,			(* current font ID		*)
      xpos, ypos,		(* current position		*)
      addressing,		(* current addressing mode	*)
      justification,		(* string justification		*)
      orientation,		(* string orientation		*)
      direction,		(* string direction		*)
      ctype,			(* character attributes		*)
      xphase,yphase,		(* phase of patterns		*)
      thickness,		(* line thickness		*)
      count,mask,		(* line style mask and count	*)
      width,height,		(* window size			*)
      px,py,pw,ph,		(* permanent clipping bounds	*)
      tx,ty,tw,th,		(* temporary clipping bounds	*)
      mmode			(* mouse input mode		*)
	 : short;
      ldisc			(* current line discipline	*)
	 : integer;
      cvisible			(* local cursor visibility	*)
	 : short;
end;
(*$w+*)
