/*
 *	libgip defines
 */
#include <vt.h>

extern char *GIP_Error;
extern short *screen;

#define GIPclear	0	/* 0			*/
#define GIPand		1	/* src AND dst		*/
#define GIPandReverse	2	/* src AND NOT dst	*/
#define GIPcopy		3	/* src			*/
#define GIPandInverted	4	/* NOT src AND dst	*/
#define GIPnoop		5	/* dst			*/
#define GIPxor		6	/* src XOR dst		*/
#define GIPor		7	/* src OR dst		*/
#define GIPnor		8	/* NOT src AND NOT dst	*/
#define GIPequiv	9	/* NOT src XOR dst	*/
#define GIPinvert	10	/* NOT dst		*/
#define GIPorReverse	11	/* src OR NOT dst	*/
#define GIPcopyInverted	12	/* NOT src		*/
#define GIPorInverted	13	/* NOT src OR dst	*/
#define GIPnand		14	/* NOT src OR NOT dst	*/
#define GIPset		15	/* 1			*/

#ifndef NOGIPSTRUCTS
typedef	struct _pixmap {
	short	width;		/* in pixels */
	short	height;		/* in pixels */
	short	refcnt;		/* reference count */
	char	tile;		/* 0: not a tile, 1: tile (pattern) */
	char	kind;		/* XY-FORMAT, Z-FORMAT, and # of planes */
	RASTER  *data;		/* ptr to an array of rasters */
} PIXMAP;
#endif NOGIPSTRUCTS

/* defines for the PIXMAP kind field */
#define XYFORMAT	(0x80)
#define ZFORMAT		(0x40)
#define CONSTANT	(0x20)
#define NPLANEMASK	(0x0f)	/* note max # of planes is 16 (ok for X!) */

#ifndef NOGIPSTRUCTS
typedef	struct _bitmap {
	short	width;		/* in pixels */
	short	height;		/* in pixels */
	short	refcnt;		/* reference count */
	char	kind;		/* unused  */
	RASTER  *data;		/* ptr to an array of rasters */
} BITMAP;
#endif NOGIPSTRUCTS

extern PIXMAP ScreenPixmap;
extern short  *gpfifo;

/* for backward compatibility with XV10R4 */
#define	GIP_LoadLUT	GIP_set_lookup
