/* pic_enp.c - jumpering of CMC ENP-10 board */

/*
modification history
--------------------
*/

/*
This module contains the jumpering of the CMC ENP-10 and ENP-10/e.

The ENP-10 board must contain LINK10 PROMs (version 3.1 or so).
The PROMs are the same (according to CMC) for both boards.
*/

#include <stdio.h>

#include "UniWorks.h"
#include "picture.h"


/*******************************************************************************
*
* drawEnp - draw ENP-10 or ENP-10/e jumper config
*/

VOID drawEnp (pic, interactive)
    char *pic;
    BOOL interactive;

    {
    char input [90];
    int n = NONE;

    if (interactive)
	{
	printf ("Which ENP-10 board (0=ENP-10, 1=ENP-10/e)?");

	if (gets (input) == NULL)
	    return;

	sscanf (input, "%d", &n);

	switch (n)
	    {
	    case 0:
		drawEnp10 (pic);
		break;
	    case 1:
		drawEnp10e (pic);
		break;
	    }
	}
    else
	{
	/* XXX need to do them both but must return after each? */
	drawEnp10 (pic);
	}

    if (!inc_enp)
	printf ("Warning: ENP-10 not included.\n");
    }
/*******************************************************************************
*
* drawEnp10 - draw ENP-10 jumper config
*/

VOID drawEnp10 (pic)
    char *pic;

    {
    int io_adrs;
    int int_lvl;

    printAt (pic, 36, 1, "ENP-10");

    /* I/O address */

    io_adrs = ~(enp_io >> 17);
    jumperAt (pic, 6, 13, 7, VERTICAL, HORIZONTAL, io_adrs);
    printAt (pic, 8, 14, "IO ADRS");

    /* int level */
    int_lvl = (0x1 << (il_enp - 1));
    jumperAt (pic, 22, 3, 7, HORIZONTAL, VERTICAL, int_lvl);
    printAt (pic, 22, 4, "INT LVL");

    /* int ack */
    if (il_enp & 0x1)
	printAt (pic, 45, 3, "L");
    else
	printAt (pic, 45, 3, "R");
    if (il_enp & 0x2)
	printAt (pic, 45, 4, "L");
    else
	printAt (pic, 45, 4, "R");
    if (il_enp & 0x4)
	printAt (pic, 45, 5, "L");
    else
	printAt (pic, 45, 5, "R");

    printAt (pic,  47, 4, "INT ACK");

    /* miscellaneous */

#ifdef	ENET_1_0
    /* Ethernet type 1.0 */

    jumperAt (pic, 74, 7, 1, VERTICAL, HORIZONTAL, 0x1);
    printAt (pic,  65, 7, "ENET 1.0");
    printAt (pic,  65, 8, "(rev. d)");

    /* DIP-16 */

    jumperAt (pic, 74, 13, 8, VERTICAL, HORIZONTAL, 0xff);
    printAt (pic, 70, 14, "DIP");
#endif	ENET_1_0
    }
/*******************************************************************************
*
* drawEnp10e - draw ENP-10/e jumper config
*/

VOID drawEnp10e (pic)
    char *pic;

    {
    int io_adrs;
    int int_lvl;

    printAt (pic, 34, 1, "ENP-10/e");

    /* I/O address (JP16) */
    io_adrs = ~(enp_io >> 17);
    jumperAt (pic, 14, 3, 7, HORIZONTAL, VERTICAL, io_adrs);
    printAt (pic, 14, 4, "IO ADRS");

    /* int level (JP15) */
    int_lvl = (0x1 << (il_enp - 1));
    jumperAt (pic, 22, 3, 7, HORIZONTAL, VERTICAL, int_lvl);
    printAt (pic, 22, 4, "INT LVL");

    /* int ack (JP11) */
    /* OUT = 1 and IN = 0; also bits are upside down */
    jumperAt (pic, 5, 12, 3, VERTICAL, HORIZONTAL, bitflip (~il_enp) >> 29);
    printAt (pic, 7, 13, "INT ACK");

    /* miscellaneous */

#ifdef	ENET_1_0

    /* Ethernet type 1.0 */

    jumperAt (pic, 66, 18, 2, VERTICAL, HORIZONTAL, 0x2);
    printAt (pic,  68, 18, "ENET 1.0");

    /* DIP-16 */

    jumperAt (pic, 64, 14, 8, VERTICAL, HORIZONTAL, 0xff);
    printAt (pic,  59, 15, "DIP");
#endif	ENET_1_0
    }
/*******************************************************************************
*
* bitflip - reverse bit pattern
*/

LOCAL int bitflip (value)
    int value;

    {
    int ix;
    int tmp = 0;

    for (ix = 0; ix < 32; ix++)
	{
	tmp <<= 1;
	tmp |= value & 1;
	value >>= 1;
	}

    return (tmp);
    }
