/* xdr_dbx.h - xdr for additional dbxWorks structures */

/*
modification history
--------------------
01c,11feb88,rdc  added VX_TASK_SUSPEND.
01b,20jan88,gae  added modification history.
	   +rdc  added VX_FP_INQUIRE.
01a,18sep87,rdc  created.
*/

#ifndef INCxdrdbxh
#define INCxdrdbxh

#include "wait.h"

/*
 * Structures used to pass structures required for
 * process control but not part of the standard ptrace interface
 */

/*
 * arg_info is used to pass arguments into process start
 */
struct arg_info {
	int rargc;
	char **rargv;
};
typedef struct arg_info Arg_info;

/*
 * wait_info is used to return status from the process wait call
 */
struct wait_info {
	int pid;
	union wait status;
};
typedef struct wait_info Wait_info;

/*
 * structure used to pass back the information for a single file
 * loaded in VxWorks
 */
struct ldfile {
	char 	*name;
	int 	txt_addr;
	int 	data_addr;
	int 	bss_addr;
};
typedef struct ldfile ldfile;

/*
 * structure used to return a list of all files loaded over to 
 * VxWorks. (VX_STATE_INQ return)
 */
struct ldtabl {
	u_int tbl_size;
	ldfile *tbl_ent;
};
typedef struct ldtabl ldtabl;

#define MAXNCMDARGS 100
#define MAXSTRLEN 256
#define MAXTBLSZ 100


#define PROCESS_START	50
#define PROCESS_WAIT	51
#define VX_STATE_INQ	60
#define VX_LOAD		61	
#define VX_SYMBOL_INQ	62
#define VX_BREAK_ADD	63
#define VX_BREAK_DELETE	64
#define VX_FP_INQUIRE	65
#define VX_TASK_SUSPEND	66

bool_t xdr_arg_info();
bool_t xdr_wait_info();
bool_t xdr_ldfile();
bool_t xdr_ldtabl();

#endif	INCxdrdbxh
