/* frc21/config.h - Force SYS68K/CPU-21/9 configuration header */

/*
modification history
--------------------
*/

/*
This file contains the parameters that define the configuration
for UniWorks on the Force SYS68K/CPU-21/9.
*/

#ifndef INCconfigh
#define INCconfigh

#include "frc21.h"

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/frc21/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"

/******************************************************************************/
/*                                                                            */
/*                  KERNEL SOFTWARE CONFIGURATION                             */
/*                                                                            */
/******************************************************************************/

#define FREE_RAM_ADRS		(&end)	/* start right after bss of UniWorks */	

#define MAX_TASKS		25	/* maximum # of tasks in system */

#define INT_LOCK_LEVEL  	7	/* interrupt disable mask */

#define MAX_SYS_SYMBOLS		3500	/* max symbols in sys symbol table */

#define ROOT_STACK_SIZE		5000	/* size of root's stack, in bytes */
#define SHELL_STACK_SIZE	10000	/* size of shell's stack, in bytes */

#define ISR_STACK_SIZE		1000	/* size of ISR stack, in bytes */

/* i/o system parameters */

#define NUM_DRIVERS		20	/* max 20 drivers in drvTable */
#define NUM_FILES		50	/* max 50 file open simultaneously */
#define NUM_RT_FILES		5	/* max 5 RT-11 files open */


/******************************************************************************/
/*                                                                            */
/*                  "GENERIC" SOFTWARE CONFIGURATION                          */
/*                                                                            */
/******************************************************************************/

/* included software facilities */

#define	INCLUDE_SHELL		/* command shell */
#define	INCLUDE_RLOGIN		/* remote login */
#define INCLUDE_RPC		/* rpc package */
#define INCLUDE_FLOATING_POINT	/* floating point I/O */
#define INCLUDE_MC68881		/* MC68881/2 float point proc */
#define	INCLUDE_STDIO		/* standard I/O */
#define	INCLUDE_RAMDRV		/* ram disk driver */
#define INCLUDE_DEBUG		/* native debugging */
#define	INCLUDE_TIMEX		/* timexLib for exec timing */
#define	INCLUDE_1.5COMPAT	/* 1.5 compatibility routines */

/* if only .5 Meg is available the following modules should be excluded. */

#define	HALF_MEG	FALSE	/* TRUE = CPU-21, FALSE = CPU-29 */

#ifdef	HALF_MEG
#define	INCLUDE_DBX		/* DBX debugger */
#define INCLUDE_NFS		/* nfs package */
#define INCLUDE_TELNET		/* telnet-style remote login */
#define	INCLUDE_RT11		/* RT-11 file system */
#define	INCLUDE_RAM		/* RAM pseudo-disk driver */
#endif	HALF_MEG

/*#define	INCLUDE_SPY	/* can't use - no auxiliary clock on CPU-21 */

/* included hardware support */

#define INCLUDE_BP		/* include backplane net interface */
#define INCLUDE_ENP		/* include CMC Ethernet interface*/

/* excluded hardware support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define INCLUDE_EX		/* include Excelan Ethernet interface */
#define INCLUDE_PN		/* include Proteon network interface*/
#define INCLUDE_NW		/* include ISI Ethernet interface */
#define INCLUDE_VB		/* include isi backplane net interface*/
#define INCLUDE_HM		/* include isi backplane net interface*/
#define	INCLUDE_TS		/* TC50 half-inch tape driver */
#define	INCLUDE_SM		/* Interphase SMD controller */
#define INCLUDE_IE			/* include Sun Ethernet interface*/
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE

/* excluded facilities/support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/*#define INCLUDE_FORTRAN*/
#define INCLUDE_PASCAL		/* support for Pascal */
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE


/******************************************************************************/
/*                                                                            */
/*                   "GENERIC" BOARD CONFIGURATION                            */
/*                                                                            */
/******************************************************************************/

/* interrupt vectors */

#define VEC_BASE_ADRS		((char *) LOCAL_MEM_LOCAL_ADRS)

#define INT_VEC_CONFIG_TBL	63	/* usrCftbl ptr */

#define TRAP_KERNEL		0	/* trap 0 - kernel trap */
#define TRAP_UNIWORKS		1	/* trap 1 - UniWorks trap */
#define TRAP_DEBUG		2	/* trap 2 - breakpoint trap */


/******************************************************************************/
/*                                                                            */
/*                   "MISCELLANEOUS" CONSTANTS                                */
/*                                                                            */
/******************************************************************************/


/* Messages from exceptions during exceptions go at the following address */

#define EXC_MSG_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x800))

/* The bootroms put the boot line at the following address */

#define BOOT_LINE_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x700))

/* Default NFS parameters */

#define NFS_USER_ID	2001
#define NFS_GROUP_ID	100

/*
 * Device controller I/O addresses: the CPU-21/9 needs top bits 0xfc000000 set
 */

#define IO_ADRS_EX	((char *) 0xfc000000)	/* 24A,16D Excelan ethernet */
#define IO_ADRS_ENP	((char *) 0xfcde0000)	/* 24A,16D ENP ethernet */
#define IO_ADRS_IE	((char *) 0xfc300000)	/* 24A,16D Sun Ethernet */
#define IO_ADRS_NW	((char *) 0xfcf80000)	/* 24A,16D ISI Ethernet */
#define IO_ADRS_PN	((char *) 0xfc100000)	/* 24A,16D Proteon ProNet */


/* interrupt vectors */

#define INT_VEC_CLOCK		INT_VEC_PIT1_TIMER	/* PIT timer 1 */


/* backplane network parameters */

/*
 * The CPU-21/9 board does not have mailboxes so the backplane driver polls.
 */

#define BP_ANCHOR_ADRS	((char *) 0xfb800000)	/* backplane shared memory */

#define BP_INT_TYPE	BP_INT_NONE		/* backplane polls */
#define BP_INT_ARG1	0
#define BP_INT_ARG2	0
#define BP_INT_ARG3	0

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#define BP_MEM_ADRS	BP_ANCHOR_ADRS	/* off-board shared mem adrs */
#define BP_MEM_SIZE	0x40000		/* 256K */


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * The CPU-21/9 local memory is not dual-ported and hence not accessible
 * from the bus.
 */

#define LOCAL_MEM_LOCAL_ADRS	0x0		/* fixed */
#define LOCAL_BUS_MEM_ADRS	NONE		/* not dual ported */

/* The following address is the base address of the on-board rom monitor */

#define ROM_BASE_ADRS	((char *) 0xff000000)	/* without forcebug */

#endif	INCconfigh
