/* pic_dy4.c - dy4 jumpering */

static char *copyright = "Copyright 1987, Wind River Systems, Inc.";

/*
modification history
--------------------
01c,04apr88,gae  removed call to printPic().
01b,16mar88,gae  renamed from pic_dy4.c for new jump.
01a,07nov87,jcf  created
*/

/*
This module contains the jumpering of the dy4.
It is only used by the utility jump (4).

SEE ALSO: jump (4)
*/

#include "UniWorks.h"
#include "config.h"
#include "picture.h"


/*******************************************************************************
*
* drawBoard - draw cpu jumper config
*/

VOID drawBoard (pic)
    char *pic;

    {
    int ix;
    int int_lvl = 0;
    int id_num = 0;
    int tmp = 0;

    if (low_byte_bus == NONE)
	{
	low_byte_bus = 0x100000;
	printf ("Vme bus address is determined at runtime, showing 0x100000\n");
	}

    printAt (pic, 37, 1, "DY4");

    /* bus base address */
    tmp = ~(low_byte_bus >> 19);
    for (ix = 0; ix < 5; ix++)
	{
	id_num = id_num << 1;
	id_num |= (tmp >> ix) & 0x1;
	}

    jumperAt (pic, 34, 3, 5, HORIZONTAL, VERTICAL, id_num);
    printAt (pic, 34, 4, "IO");

    /* int level */
    int_lvl |= (inc_ex)  ? (1 << (il_ex - 1))  : 0;
    int_lvl |= (inc_enp) ? (1 << (il_enp - 1)) : 0;
    int_lvl |= (inc_ie)  ? (1 << (il_ie - 1))  : 0;
    int_lvl |= (inc_nw)  ? (1 << (il_nw - 1))  : 0;
    int_lvl |= (inc_pn)  ? (1 << (il_pn - 1))  : 0;

    jumperAt (pic, 27, 8, 10, VERTICAL, HORIZONTAL, int_lvl);

    printAt (pic, 29, 11, "INT");
    printAt (pic, 29, 8, "SEE MANPAGE");

    jumperAt (pic, 66, 13, 9, VERTICAL, HORIZONTAL, 0x22);
    printAt (pic, 68, 18, "INT ACK");
    printAt (pic, 68, 19, "SEE MAN.");

    /* MISC */
    jumperAt (pic, 66, 11, 1, VERTICAL, HORIZONTAL, 0x1);
    printAt  (pic, 68, 11, "RWD");

    jumperAt (pic, 72, 4, 1, HORIZONTAL, VERTICAL, 0x1);
    printAt  (pic, 70, 5, "SCON");

    jumperAt (pic, 44, 3, 4, HORIZONTAL, VERTICAL, 0xf);

    jumperAt (pic, 10, 3, 2, HORIZONTAL, VERTICAL, 0x3);
    jumperAt (pic, 10, 4, 4, VERTICAL, HORIZONTAL, 0xd);
    printAt (pic, 12, 4, "BUS GRANT");
    printAt (pic, 14, 5, "LVL 3");

    jumperAt (pic, 10, 9, 2, HORIZONTAL, VERTICAL, 0x1);
    jumperAt (pic, 10, 10, 1, VERTICAL, HORIZONTAL, 0x0);
    }
